/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.helpdesk.web;

import com.axelor.apps.base.db.Timer;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.helpdesk.db.Ticket;
import com.axelor.apps.helpdesk.db.repo.TicketRepository;
import com.axelor.apps.helpdesk.service.TicketService;
import com.axelor.apps.helpdesk.service.TimerTicketService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.apps.tool.date.DurationTool;
import com.axelor.db.Model;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;

@Singleton
public class TicketController {
    private static final String HIDDEN_ATTR = "hidden";

    public void assignToMeTicket(ActionRequest request, ActionResponse response) {
        try {
            Long id = (Long)request.getContext().get((Object)"id");
            List ids = (List)request.getContext().get((Object)"_ids");
            if (id == null && ids == null) {
                response.setAlert(I18n.get((String)"Please select tickets"));
            } else {
                ((TicketService)Beans.get(TicketService.class)).assignToMeTicket(id, ids);
                response.setReload(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeFromStartDateTime(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            if (ticket.getStartDateT() != null) {
                if (ticket.getDuration() != null && ticket.getDuration() != 0L) {
                    response.setValue("endDateT", (Object)DateTool.plusSeconds((LocalDateTime)ticket.getStartDateT(), (long)ticket.getDuration()));
                } else if (ticket.getEndDateT() != null && ticket.getEndDateT().isAfter(ticket.getStartDateT())) {
                    Duration duration = DurationTool.computeDuration((LocalDateTime)ticket.getStartDateT(), (LocalDateTime)ticket.getEndDateT());
                    response.setValue("duration", (Object)DurationTool.getSecondsDuration((Duration)duration));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeFromDuration(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            if (ticket.getDuration() != null) {
                if (ticket.getStartDateT() != null) {
                    response.setValue("endDateT", (Object)DateTool.plusSeconds((LocalDateTime)ticket.getStartDateT(), (long)ticket.getDuration()));
                } else if (ticket.getEndDateT() != null) {
                    response.setValue("startDateT", (Object)DateTool.minusSeconds((LocalDateTime)ticket.getEndDateT(), (long)ticket.getDuration()));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void computeFromEndDateTime(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            if (ticket.getEndDateT() != null) {
                if (ticket.getStartDateT() != null && ticket.getStartDateT().isBefore(ticket.getEndDateT())) {
                    Duration duration = DurationTool.computeDuration((LocalDateTime)ticket.getStartDateT(), (LocalDateTime)ticket.getEndDateT());
                    response.setValue("duration", (Object)DurationTool.getSecondsDuration((Duration)duration));
                } else if (ticket.getDuration() != null) {
                    response.setValue("startDateT", (Object)DateTool.minusSeconds((LocalDateTime)ticket.getEndDateT(), (long)ticket.getDuration()));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void manageTimerButtons(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            TimerTicketService service = (TimerTicketService)Beans.get(TimerTicketService.class);
            Timer timer = service.find(ticket);
            boolean hideStart = false;
            boolean hideCancel = true;
            if (timer != null) {
                hideStart = timer.getStatusSelect() == 1;
                hideCancel = timer.getTimerHistoryList().isEmpty() || timer.getStatusSelect().equals(0);
            }
            response.setAttr("startTimerBtn", HIDDEN_ATTR, (Object)hideStart);
            response.setAttr("stopTimerBtn", HIDDEN_ATTR, (Object)(!hideStart ? 1 : 0));
            response.setAttr("cancelTimerBtn", HIDDEN_ATTR, (Object)hideCancel);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeTotalTimerDuration(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            if (ticket.getId() != null) {
                Duration duration = ((TimerTicketService)Beans.get(TimerTicketService.class)).compute(ticket);
                response.setValue("$_totalTimerDuration", (Object)Float.valueOf((float)duration.toMinutes() / 60.0f));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void startTimer(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            ((TimerTicketService)Beans.get(TimerTicketService.class)).start(ticket, ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void stopTimer(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            ((TimerTicketService)Beans.get(TimerTicketService.class)).stop(ticket, ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancelTimer(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            ((TimerTicketService)Beans.get(TimerTicketService.class)).cancel(ticket);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeRealDuration(ActionRequest request, ActionResponse response) {
        try {
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            if (ticket.getId() != null && ticket.getRealTotalDuration().compareTo(BigDecimal.ZERO) == 0) {
                response.setValue("realTotalDuration", (Object)Float.valueOf((float)((TimerTicketService)Beans.get(TimerTicketService.class)).compute(ticket).toMinutes() / 60.0f));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional
    public void timerStateOn(ActionRequest request, ActionResponse response) {
        try {
            TicketRepository ticketRepo = (TicketRepository)((Object)Beans.get(TicketRepository.class));
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            ticket = (Ticket)((Object)ticketRepo.find(ticket.getId()));
            ticket.setTimerState(true);
            ticketRepo.save((Model)((Object)ticket));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional
    public void timerStateOff(ActionRequest request, ActionResponse response) {
        try {
            TicketRepository ticketRepo = (TicketRepository)((Object)Beans.get(TicketRepository.class));
            Ticket ticket = (Ticket)((Object)request.getContext().asType(Ticket.class));
            ticket = (Ticket)((Object)ticketRepo.find(ticket.getId()));
            ticket.setTimerState(false);
            ticketRepo.save((Model)((Object)ticket));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

