/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.service;

import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.repo.EmailAddressRepository;
import com.axelor.apps.message.service.MailAccountService;
import com.axelor.auth.AuditableRunner;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.inject.Beans;
import com.axelor.mail.MailAccount;
import com.axelor.mail.MailBuilder;
import com.axelor.mail.MailException;
import com.axelor.mail.MailReader;
import com.axelor.mail.MailSender;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailMessageRepository;
import com.axelor.mail.service.MailService;
import com.axelor.mail.service.MailServiceImpl;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaAttachment;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MailServiceMessageImpl
extends MailServiceImpl {
    private Logger log = LoggerFactory.getLogger(MailService.class);
    private ExecutorService executor = Executors.newCachedThreadPool();
    private MailSender sender = null;
    private MailReader reader = null;
    private EmailAccount senderAccount = null;
    private EmailAccount readerAccount = null;
    @Inject
    private MailAccountService mailAccountService;

    public Model resolve(String email) {
        EmailAddressRepository addresses = (EmailAddressRepository)((Object)Beans.get(EmailAddressRepository.class));
        EmailAddress address = (EmailAddress)addresses.all().filter("self.address = ?1", new Object[]{email}).fetchOne();
        if (address != null) {
            return address;
        }
        return super.resolve(email);
    }

    public List<InternetAddress> findEmails(String matching, List<String> selected, int maxResult) {
        ArrayList<String> where = new ArrayList<String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        where.add("self.address is not null");
        if (!StringUtils.isBlank((CharSequence)matching)) {
            where.add("(LOWER(self.address) like LOWER(:email))");
            params.put("email", "%" + matching + "%");
        }
        if (selected != null && !selected.isEmpty()) {
            where.add("self.address not in (:selected)");
            params.put("selected", selected);
        }
        String filter = Joiner.on((String)" AND ").join(where);
        Query query = Query.of(EmailAddress.class);
        if (!StringUtils.isBlank((CharSequence)filter)) {
            query.filter(filter);
            query.bind(params);
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (EmailAddress emailAddress : query.fetch(maxResult)) {
            try {
                InternetAddress item = new InternetAddress(emailAddress.getAddress());
                addresses.add(item);
            }
            catch (AddressException addressException) {}
        }
        return addresses;
    }

    public void fetch() throws MailException {
        EmailAccount emailAccount = this.mailAccountService.getDefaultReader();
        if (emailAccount == null) {
            super.fetch();
        } else {
            MailReader reader = this.getMailReader(emailAccount);
            AuditableRunner runner = (AuditableRunner)Beans.get(AuditableRunner.class);
            runner.run(() -> {
                try {
                    this.fetch(reader);
                }
                catch (Exception e) {
                    this.log.error("Unable to fetch messages", (Throwable)e);
                }
            });
        }
    }

    public void send(MailMessage message) throws MailException {
        MimeMessage email;
        EmailAccount emailAccount = this.mailAccountService.getDefaultSender();
        if (emailAccount == null) {
            super.send(message);
            return;
        }
        Preconditions.checkNotNull((Object)message, (Object)"mail message can't be null");
        Model related = this.findEntity(message);
        final MailSender sender = this.getMailSender(emailAccount);
        Set recipients = this.recipients(message, related);
        if (recipients.isEmpty()) {
            return;
        }
        MailMessageRepository messages = (MailMessageRepository)Beans.get(MailMessageRepository.class);
        MailBuilder builder = sender.compose().subject(this.getSubject(message, related));
        for (String recipient : recipients) {
            builder.to(new String[]{recipient});
        }
        for (MetaAttachment attachment : messages.findAttachments(message)) {
            Path filePath = MetaFiles.getPath((MetaFile)attachment.getMetaFile());
            File file = filePath.toFile();
            builder.attach(file.getName(), file.toString());
        }
        try {
            builder.html(this.template(message, related));
            email = builder.build(message.getMessageId());
            LinkedHashSet<String> references = new LinkedHashSet<String>();
            if (message.getParent() != null) {
                references.add(message.getParent().getMessageId());
            }
            if (message.getRoot() != null) {
                references.add(message.getRoot().getMessageId());
            }
            if (!references.isEmpty()) {
                email.setHeader("References", Joiner.on((String)" ").skipNulls().join(references));
            }
        }
        catch (IOException | MessagingException e) {
            throw new MailException(e);
        }
        this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MailServiceMessageImpl.this.send(sender, email);
                return true;
            }
        });
    }

    private MailSender getMailSender(EmailAccount emailAccount) {
        if (this.senderAccount == null || !this.senderAccount.getId().equals(emailAccount.getId()) || !this.senderAccount.getVersion().equals(emailAccount.getVersion())) {
            this.senderAccount = emailAccount;
            this.sender = null;
        }
        if (this.sender == null) {
            MailAccount mailAccount = this.mailAccountService.getMailAccount(emailAccount);
            this.sender = new MailSender(mailAccount);
        }
        return this.sender;
    }

    private MailReader getMailReader(EmailAccount emailAccount) {
        if (this.readerAccount == null || !this.readerAccount.getId().equals(emailAccount.getId()) || !this.readerAccount.getVersion().equals(emailAccount.getVersion())) {
            this.readerAccount = emailAccount;
            this.reader = null;
        }
        if (this.reader == null) {
            MailAccount mailAccount = this.mailAccountService.getMailAccount(emailAccount);
            this.reader = new MailReader(mailAccount);
        }
        return this.reader;
    }
}

