/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.service;

import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.db.JpaSupport;
import com.axelor.db.Model;
import com.axelor.event.Observes;
import com.axelor.events.ShutdownEvent;
import com.axelor.exception.service.TraceBackService;
import com.axelor.mail.MailBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.time.LocalDateTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SendMailQueueService
extends JpaSupport {
    private static final int ENTITY_FIND_TIMEOUT = 10000;
    private static final int ENTITY_FIND_INTERVAL = 200;
    protected MessageRepository messageRepository;
    protected UserRepository userRepository;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ExecutorService executor = Executors.newSingleThreadExecutor();

    @Inject
    public SendMailQueueService(MessageRepository messageRepository, UserRepository userRepository) {
        this.messageRepository = messageRepository;
        this.userRepository = userRepository;
    }

    public void submitMailJob(MailBuilder mailBuilder, Message message) {
        long messageId = message.getId();
        this.log.debug("Submitting job to executor for message {}...", (Object)messageId);
        User currentUser = AuthUtils.getUser();
        this.executor.submit(() -> {
            try {
                long startTime = System.currentTimeMillis();
                boolean done = false;
                PersistenceException persistenceException = null;
                this.log.debug("Sending message {}...", (Object)messageId);
                mailBuilder.send();
                this.log.debug("Message {} sent.", (Object)messageId);
                do {
                    try {
                        this.inTransaction(() -> {
                            Message updateMessage = this.findMessage(messageId);
                            this.getEntityManager().lock((Object)updateMessage, LockModeType.PESSIMISTIC_WRITE);
                            updateMessage.setSentByEmail(true);
                            updateMessage.setStatusSelect(3);
                            updateMessage.setSentDateT(LocalDateTime.now());
                            if (currentUser != null) {
                                updateMessage.setSenderUser((User)this.userRepository.find(currentUser.getId()));
                            }
                            this.messageRepository.save((Model)updateMessage);
                        });
                        done = true;
                    }
                    catch (PersistenceException e) {
                        persistenceException = e;
                        this.sleep();
                    }
                } while (!done && System.currentTimeMillis() - startTime < 10000L);
                if (!done) {
                    throw persistenceException;
                }
            }
            catch (Exception e) {
                this.log.debug("Exception when sending email", (Throwable)e);
                TraceBackService.trace((Throwable)e);
            }
            return true;
        });
    }

    protected void onApplicationShutdown(@Observes ShutdownEvent event) {
        this.log.debug("Shutting down mail executor..");
        this.executor.shutdown();
    }

    private Message findMessage(Long messageId) {
        Message foundMessage;
        long startTime = System.currentTimeMillis();
        while ((foundMessage = (Message)this.messageRepository.find(messageId)) == null && System.currentTimeMillis() - startTime < 10000L) {
            this.sleep();
        }
        if (foundMessage == null) {
            throw new EntityNotFoundException(messageId.toString());
        }
        return foundMessage;
    }

    private void sleep() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

