/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.web;

import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.TemplateRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GenerateMessageController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void callMessageWizard(ActionRequest request, ActionResponse response) {
        Model context = (Model)request.getContext().asType(Model.class);
        String model = request.getModel();
        LOG.debug("Call message wizard for model : {} ", (Object)model);
        String[] decomposeModel = model.split("\\.");
        String simpleModel = decomposeModel[decomposeModel.length - 1];
        Query templateQuery = ((TemplateRepository)((Object)Beans.get(TemplateRepository.class))).all().filter("self.metaModel.fullName = ?1 AND self.isSystem != true", new Object[]{model});
        try {
            long templateNumber = templateQuery.count();
            LOG.debug("Template number : {} ", (Object)templateNumber);
            if (templateNumber == 0L) {
                response.setView(ActionView.define((String)I18n.get((String)"Create message")).model(Message.class.getName()).add("form", "message-form").param("forceEdit", "true").context("_mediaTypeSelect", (Object)2).context("_templateContextModel", (Object)model).context("_objectId", (Object)context.getId().toString()).map());
            } else if (templateNumber > 1L) {
                response.setView(ActionView.define((String)I18n.get((String)"Select template")).model(Wizard.class.getName()).add("form", "generate-message-wizard-form").param("show-confirm", "false").context("_objectId", (Object)context.getId().toString()).context("_templateContextModel", (Object)model).context("_tag", (Object)simpleModel).map());
            } else {
                response.setView(this.generateMessage(context.getId(), model, simpleModel, (Template)templateQuery.fetchOne()));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateMessage(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        Map templateContext = (Map)context.get((Object)"_xTemplate");
        Template template = null;
        if (templateContext != null) {
            template = (Template)((TemplateRepository)((Object)Beans.get(TemplateRepository.class))).find(Long.parseLong(templateContext.get("id").toString()));
        }
        Long objectId = Long.parseLong(context.get((Object)"_objectId").toString());
        String model = (String)context.get((Object)"_templateContextModel");
        String tag = (String)context.get((Object)"_tag");
        try {
            response.setView(this.generateMessage(objectId, model, tag, template));
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public Map<String, Object> generateMessage(long objectId, String model, String tag, Template template) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxelorException, IOException {
        LOG.debug("template : {} ", (Object)template);
        LOG.debug("object id : {} ", (Object)objectId);
        LOG.debug("model : {} ", (Object)model);
        LOG.debug("tag : {} ", (Object)tag);
        Message message = null;
        message = template != null ? ((TemplateMessageService)Beans.get(TemplateMessageService.class)).generateMessage(objectId, model, tag, template) : ((MessageService)Beans.get(MessageService.class)).createMessage(model, Math.toIntExact(objectId), null, null, null, null, null, null, null, null, null, 2, null, null);
        return ActionView.define((String)I18n.get((String)"Create message")).model(Message.class.getName()).add("form", "message-form").param("forceEdit", "true").context("_showRecord", (Object)message.getId().toString()).map();
    }
}

