/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.web;

import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.repo.EmailAccountRepository;
import com.axelor.apps.message.service.MailAccountService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.mail.MessagingException;

@Singleton
public class MailAccountController {
    public void validateSmtpAccount(ActionRequest request, ActionResponse response) {
        EmailAccount account = (EmailAccount)((Object)request.getContext().asType(EmailAccount.class));
        try {
            ((MailAccountService)Beans.get(MailAccountService.class)).checkMailAccountConfiguration(account);
            response.setValue("isValid", (Object)Boolean.TRUE);
            response.setFlash(I18n.get((String)"Connection successful"));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setValue("isValid", (Object)Boolean.FALSE);
        }
    }

    public void checkDefaultMailAccount(ActionRequest request, ActionResponse response) throws AxelorException {
        EmailAccount account = (EmailAccount)((Object)request.getContext().asType(EmailAccount.class));
        try {
            ((MailAccountService)Beans.get(MailAccountService.class)).checkDefaultMailAccount(account);
        }
        catch (AxelorException e) {
            response.setAttr("isDefault", "value", (Object)false);
            response.setFlash(e.getMessage());
        }
    }

    public void fetchEmails(ActionRequest request, ActionResponse response) throws MessagingException, IOException {
        EmailAccount account = (EmailAccount)((Object)request.getContext().asType(EmailAccount.class));
        account = (EmailAccount)((EmailAccountRepository)((Object)Beans.get(EmailAccountRepository.class))).find(account.getId());
        int totalFetched = ((MailAccountService)Beans.get(MailAccountService.class)).fetchEmails(account, true);
        response.setFlash(I18n.get((String)String.format("Total email fetched: %s", totalFetched)));
    }

    public void validate(ActionRequest request, ActionResponse response) {
        if (request.getContext().get((Object)"newPassword") != null) {
            response.setValue("password", (Object)((MailAccountService)Beans.get(MailAccountService.class)).getEncryptPassword(request.getContext().get((Object)"newPassword").toString()));
        }
    }
}

