/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ABCAnalysisClass;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ABC_ANALYSIS", indexes={@Index(columnList="name"), @Index(columnList="abcAnalysisSeq"), @Index(columnList="company"), @Index(columnList="stock_location")})
public class ABCAnalysis
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ABC_ANALYSIS_SEQ")
    @SequenceGenerator(name="BASE_ABC_ANALYSIS_SEQ", sequenceName="BASE_ABC_ANALYSIS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="ABC Analysis N\u00b0", readonly=true)
    @NameColumn
    private String abcAnalysisSeq;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Type", selection="abc.analysis.type.select")
    private String typeSelect = "com.axelor.apps.base.service.ABCAnalysisServiceImpl";
    @Widget(title="Status", selection="abc.analysis.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="ABC Classes")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="abcAnalysis", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ABCAnalysisClass> abcAnalysisClassList;
    @Widget(title="Products")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productSet;
    @Widget(title="Product categories")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductCategory> productCategorySet;
    @Widget(title="Product families")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductFamily> productFamilySet;
    @Widget(title="Stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Start date")
    private LocalDate startDate;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ABCAnalysis() {
    }

    public ABCAnalysis(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbcAnalysisSeq() {
        return this.abcAnalysisSeq;
    }

    public void setAbcAnalysisSeq(String abcAnalysisSeq) {
        this.abcAnalysisSeq = abcAnalysisSeq;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTypeSelect() {
        return this.typeSelect;
    }

    public void setTypeSelect(String typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public List<ABCAnalysisClass> getAbcAnalysisClassList() {
        return this.abcAnalysisClassList;
    }

    public void setAbcAnalysisClassList(List<ABCAnalysisClass> abcAnalysisClassList) {
        this.abcAnalysisClassList = abcAnalysisClassList;
    }

    public void addAbcAnalysisClassListItem(ABCAnalysisClass item) {
        if (this.getAbcAnalysisClassList() == null) {
            this.setAbcAnalysisClassList(new ArrayList<ABCAnalysisClass>());
        }
        this.getAbcAnalysisClassList().add(item);
        item.setAbcAnalysis(this);
    }

    public void removeAbcAnalysisClassListItem(ABCAnalysisClass item) {
        if (this.getAbcAnalysisClassList() == null) {
            return;
        }
        this.getAbcAnalysisClassList().remove(item);
    }

    public void clearAbcAnalysisClassList() {
        if (this.getAbcAnalysisClassList() != null) {
            this.getAbcAnalysisClassList().clear();
        }
    }

    public Set<Product> getProductSet() {
        return this.productSet;
    }

    public void setProductSet(Set<Product> productSet) {
        this.productSet = productSet;
    }

    public void addProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            this.setProductSet(new HashSet<Product>());
        }
        this.getProductSet().add(item);
    }

    public void removeProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            return;
        }
        this.getProductSet().remove((Object)item);
    }

    public void clearProductSet() {
        if (this.getProductSet() != null) {
            this.getProductSet().clear();
        }
    }

    public Set<ProductCategory> getProductCategorySet() {
        return this.productCategorySet;
    }

    public void setProductCategorySet(Set<ProductCategory> productCategorySet) {
        this.productCategorySet = productCategorySet;
    }

    public void addProductCategorySetItem(ProductCategory item) {
        if (this.getProductCategorySet() == null) {
            this.setProductCategorySet(new HashSet<ProductCategory>());
        }
        this.getProductCategorySet().add(item);
    }

    public void removeProductCategorySetItem(ProductCategory item) {
        if (this.getProductCategorySet() == null) {
            return;
        }
        this.getProductCategorySet().remove(item);
    }

    public void clearProductCategorySet() {
        if (this.getProductCategorySet() != null) {
            this.getProductCategorySet().clear();
        }
    }

    public Set<ProductFamily> getProductFamilySet() {
        return this.productFamilySet;
    }

    public void setProductFamilySet(Set<ProductFamily> productFamilySet) {
        this.productFamilySet = productFamilySet;
    }

    public void addProductFamilySetItem(ProductFamily item) {
        if (this.getProductFamilySet() == null) {
            this.setProductFamilySet(new HashSet<ProductFamily>());
        }
        this.getProductFamilySet().add(item);
    }

    public void removeProductFamilySetItem(ProductFamily item) {
        if (this.getProductFamilySet() == null) {
            return;
        }
        this.getProductFamilySet().remove(item);
    }

    public void clearProductFamilySet() {
        if (this.getProductFamilySet() != null) {
            this.getProductFamilySet().clear();
        }
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ABCAnalysis)) {
            return false;
        }
        ABCAnalysis other = (ABCAnalysis)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("abcAnalysisSeq", (Object)this.getAbcAnalysisSeq()).add("typeSelect", (Object)this.getTypeSelect()).add("statusSelect", (Object)this.getStatusSelect()).add("startDate", (Object)this.getStartDate()).add("endDate", (Object)this.getEndDate()).omitNullValues().toString();
    }
}

