/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderCreateService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.bankpayment.service.invoice.payment.InvoicePaymentValidateServiceBankPayImpl;
import com.axelor.apps.businessproject.db.InvoicingProject;
import com.axelor.apps.businessproject.db.repo.InvoicingProjectRepository;
import com.axelor.exception.AxelorException;
import com.axelor.team.db.TeamTask;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public class InvoicePaymentValidateProjectServiceImpl
extends InvoicePaymentValidateServiceBankPayImpl {
    private InvoicingProjectRepository invoicingProjectRepo;

    @Inject
    public InvoicePaymentValidateProjectServiceImpl(PaymentModeService paymentModeService, MoveService moveService, MoveLineService moveLineService, AccountConfigService accountConfigService, InvoicePaymentRepository invoicePaymentRepository, ReconcileService reconcileService, BankOrderCreateService bankOrderCreateService, BankOrderService bankOrderService, InvoicePaymentToolService invoicePaymentToolService, InvoicingProjectRepository invoicingProjectRepo) {
        super(paymentModeService, moveService, moveLineService, accountConfigService, invoicePaymentRepository, reconcileService, bankOrderCreateService, bankOrderService, invoicePaymentToolService);
        this.invoicingProjectRepo = invoicingProjectRepo;
    }

    @Transactional(rollbackOn={Exception.class})
    public void validate(InvoicePayment invoicePayment, boolean force) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        super.validate(invoicePayment, force);
        Invoice invoice = invoicePayment.getInvoice();
        InvoicingProject invoicingProject = (InvoicingProject)((Object)this.invoicingProjectRepo.all().filter("self.invoice.id = ?1 AND self.project.invoicingSequenceSelect = ?2", new Object[]{invoice.getId(), 1}).fetchOne());
        if (invoicingProject != null) {
            for (TeamTask teamTask : invoicingProject.getTeamTaskSet()) {
                teamTask.setIsPaid(invoice.getHasPendingPayments());
            }
        }
    }
}

