/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.AnalyticMoveLineRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.factory.CancelFactory;
import com.axelor.apps.account.service.invoice.factory.ValidateFactory;
import com.axelor.apps.account.service.invoice.factory.VentilateFactory;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.alarm.AlarmEngineService;
import com.axelor.apps.businessproject.service.InvoiceServiceProject;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.supplychain.service.invoice.InvoiceServiceSupplychainImpl;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class InvoiceServiceProjectImpl
extends InvoiceServiceSupplychainImpl
implements InvoiceServiceProject {
    @Inject
    public InvoiceServiceProjectImpl(ValidateFactory validateFactory, VentilateFactory ventilateFactory, CancelFactory cancelFactory, AlarmEngineService<Invoice> alarmEngineService, InvoiceRepository invoiceRepo, AppAccountService appAccountService, PartnerService partnerService, InvoiceLineService invoiceLineService, AccountConfigService accountConfigService, MoveToolService moveToolService) {
        super(validateFactory, ventilateFactory, cancelFactory, alarmEngineService, invoiceRepo, appAccountService, partnerService, invoiceLineService, accountConfigService, moveToolService);
    }

    public List<String> editInvoiceAnnex(Invoice invoice, String invoiceIds, boolean toAttach) throws AxelorException {
        if (invoice.getPrintingSettings() == null) {
            throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on invoice %s."), invoice.getInvoiceId()), new Object[]{invoice});
        }
        if (Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null) != null && !AuthUtils.getUser().getActiveCompany().getAccountConfig().getDisplayTimesheetOnPrinting().booleanValue() && !AuthUtils.getUser().getActiveCompany().getAccountConfig().getDisplayExpenseOnPrinting().booleanValue()) {
            return null;
        }
        String language = ReportSettings.getPrintingLocale((Partner)invoice.getPartner());
        String title = I18n.get((String)"Invoice");
        if (invoice.getInvoiceId() != null) {
            title = title + invoice.getInvoiceId();
        }
        Integer invoicesCopy = invoice.getInvoicesCopySelect();
        ReportSettings rS = ReportFactory.createReport((String)"InvoiceAnnex.rptdesign", (String)(title + "-" + I18n.get((String)"Annex") + "-${date}"));
        if (toAttach) {
            rS.toAttach((Model)((Object)invoice));
        }
        String fileLink = rS.addParam("InvoiceId", (Object)invoiceIds).addParam("Locale", (Object)language).addParam("Timezone", invoice.getCompany() != null ? invoice.getCompany().getTimezone() : null).addParam("InvoicesCopy", (Object)invoicesCopy).addParam("HeaderHeight", (Object)invoice.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)invoice.getPrintingSettings().getPdfFooterHeight()).generate().getFileLink();
        List<String> res = Arrays.asList(title, fileLink);
        return res;
    }

    @Transactional(rollbackOn={Exception.class})
    public void cancel(Invoice invoice) throws AxelorException {
        super.cancel(invoice);
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            for (AnalyticMoveLine analyticMoveLine : invoiceLine.getAnalyticMoveLineList()) {
                analyticMoveLine.setProject(null);
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice updateLines(Invoice invoice) {
        AnalyticMoveLineRepository analyticMoveLineRepository = (AnalyticMoveLineRepository)((Object)Beans.get(AnalyticMoveLineRepository.class));
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            invoiceLine.setProject(invoice.getProject());
            for (AnalyticMoveLine analyticMoveLine : invoiceLine.getAnalyticMoveLineList()) {
                analyticMoveLine.setProject(invoice.getProject());
                analyticMoveLineRepository.save((Model)((Object)analyticMoveLine));
            }
        }
        return invoice;
    }
}

