/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.businessproject.service.ProductTaskTemplateService;
import com.axelor.apps.businessproject.service.TeamTaskBusinessProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.TaskTemplate;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class ProductTaskTemplateServiceImpl
implements ProductTaskTemplateService {
    protected TeamTaskBusinessProjectService teamTaskBusinessProjectService;
    protected TeamTaskRepository teamTaskRepository;
    protected ProductCompanyService productCompanyService;

    @Inject
    public ProductTaskTemplateServiceImpl(TeamTaskBusinessProjectService teamTaskBusinessProjectService, TeamTaskRepository teamTaskRepository, ProductCompanyService productCompanyService) {
        this.teamTaskBusinessProjectService = teamTaskBusinessProjectService;
        this.teamTaskRepository = teamTaskRepository;
        this.productCompanyService = productCompanyService;
    }

    @Override
    @Transactional
    public List<TeamTask> convert(List<? extends TaskTemplate> templates, Project project, TeamTask parent, LocalDateTime startDate, BigDecimal qty, SaleOrderLine saleOrderLine) throws AxelorException {
        ArrayList<TeamTask> tasks = new ArrayList<TeamTask>();
        Product product = saleOrderLine.getProduct();
        for (TaskTemplate taskTemplate : templates) {
            BigDecimal qtyTmp;
            BigDecimal bigDecimal = qtyTmp = taskTemplate.getIsUniqueTaskForMultipleQuantity() != false ? BigDecimal.ONE : qty;
            while (qtyTmp.signum() > 0) {
                LocalDateTime dateWithDelay = startDate.plusHours(taskTemplate.getDelayToStart().longValue());
                TeamTask task = this.teamTaskBusinessProjectService.create(taskTemplate, project, dateWithDelay, qty);
                task.setParentTask(parent);
                task.setProduct(product);
                task.setQuantity(taskTemplate.getIsUniqueTaskForMultipleQuantity() == false ? BigDecimal.ONE : qty);
                task.setUnit(product.getUnit());
                task.setUnitPrice((BigDecimal)this.productCompanyService.get(product, "salePrice", project.getCompany()));
                task.setExTaxTotal(task.getUnitPrice().multiply(task.getQuantity()));
                if (saleOrderLine.getSaleOrder().getToInvoiceViaTask().booleanValue()) {
                    task.setToInvoice(true);
                    task.setInvoicingType(2);
                }
                tasks.add((TeamTask)((Object)this.teamTaskRepository.save((Model)((Object)task))));
                List<TeamTask> children = this.convert(taskTemplate.getTaskTemplateList(), project, task, dateWithDelay, BigDecimal.ONE, saleOrderLine);
                tasks.addAll(children);
                qtyTmp = qtyTmp.subtract(BigDecimal.ONE);
            }
        }
        return tasks;
    }
}

