/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.base.db.AppSupplychain;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.businessproject.service.ProjectBusinessService;
import com.axelor.apps.businessproject.service.app.AppBusinessProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectTemplate;
import com.axelor.apps.project.db.TaskTemplate;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.project.service.ProjectServiceImpl;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.saleorder.SaleOrderCreateService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Set;

public class ProjectBusinessServiceImpl
extends ProjectServiceImpl
implements ProjectBusinessService {
    @Inject
    protected AppBusinessProjectService appBusinessProjectService;
    @Inject
    protected ProjectRepository projectRepo;
    @Inject
    protected PartnerService partnerService;
    @Inject
    protected AddressService addressService;

    @Inject
    public ProjectBusinessServiceImpl(ProjectRepository projectRepository) {
        super(projectRepository);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public SaleOrder generateQuotation(Project project) throws AxelorException {
        SaleOrder order = ((SaleOrderCreateService)Beans.get(SaleOrderCreateService.class)).createSaleOrder(project.getCompany());
        Partner clientPartner = project.getClientPartner();
        Partner contactPartner = project.getContactPartner();
        if (contactPartner == null && clientPartner.getContactPartnerSet().size() == 1) {
            contactPartner = clientPartner.getContactPartnerSet().iterator().next();
        }
        Company company = project.getCompany();
        order.setProject((Project)((Object)this.projectRepo.find(project.getId())));
        order.setClientPartner(clientPartner);
        order.setContactPartner(contactPartner);
        order.setCompany(company);
        order.setMainInvoicingAddress(this.partnerService.getInvoicingAddress(clientPartner));
        order.setMainInvoicingAddressStr(this.addressService.computeAddressStr(order.getMainInvoicingAddress()));
        order.setDeliveryAddress(this.partnerService.getDeliveryAddress(clientPartner));
        order.setDeliveryAddressStr(this.addressService.computeAddressStr(order.getDeliveryAddress()));
        order.setIsNeedingConformityCertificate(clientPartner.getIsNeedingConformityCertificate());
        order.setCompanyBankDetails(((AccountingSituationService)Beans.get(AccountingSituationService.class)).getCompanySalesBankDetails(company, clientPartner));
        if (project.getCurrency() != null) {
            order.setCurrency(project.getCurrency());
        } else if (clientPartner.getCurrency() != null) {
            order.setCurrency(clientPartner.getCurrency());
        } else {
            order.setCurrency(company.getCurrency());
        }
        if (project.getPriceList() != null) {
            order.setPriceList(project.getPriceList());
        } else {
            order.setPriceList(((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(clientPartner, 1));
        }
        if (order.getPriceList() != null) {
            order.setHideDiscount(order.getPriceList().getHideDiscount());
        }
        if (clientPartner.getPaymentCondition() != null) {
            order.setPaymentCondition(clientPartner.getPaymentCondition());
        } else if (company != null && company.getAccountConfig() != null) {
            order.setPaymentCondition(company.getAccountConfig().getDefPaymentCondition());
        }
        if (clientPartner.getInPaymentMode() != null) {
            order.setPaymentMode(clientPartner.getInPaymentMode());
        } else if (company != null && company.getAccountConfig() != null) {
            order.setPaymentMode(company.getAccountConfig().getInPaymentMode());
        }
        AppSupplychain appSupplychain = ((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain();
        if (appSupplychain != null) {
            order.setShipmentMode(clientPartner.getShipmentMode());
            order.setFreightCarrierMode(clientPartner.getFreightCarrierMode());
            if (clientPartner.getFreightCarrierMode() != null) {
                order.setCarrierPartner(clientPartner.getFreightCarrierMode().getCarrierPartner());
            }
            Boolean interco = appSupplychain.getIntercoFromSale() != false && order.getCreatedByInterco() == false && clientPartner != null && ((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).all().filter("self.partner = ?", new Object[]{clientPartner}).fetchOne() != null;
            order.setInterco(interco);
        }
        return (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).save((Model)((Object)order)));
    }

    @Override
    public Project generateProject(SaleOrder saleOrder) {
        Project project = this.projectRepo.findByName(saleOrder.getFullName() + "_project");
        project = project == null ? this.generateProject(null, saleOrder.getFullName() + "_project", saleOrder.getSalespersonUser(), saleOrder.getCompany(), saleOrder.getClientPartner()) : project;
        saleOrder.setProject(project);
        project.setDescription(saleOrder.getDescription());
        return project;
    }

    public Project generateProject(Project parentProject, String fullName, User assignedTo, Company company, Partner clientPartner) {
        Project project = super.generateProject(parentProject, fullName, assignedTo, company, clientPartner);
        if (!((AppBusinessProjectService)Beans.get(AppBusinessProjectService.class)).isApp("business-project")) {
            return project;
        }
        if (assignedTo != null) {
            project.addMembersUserSetItem(assignedTo);
        }
        project.setImputable(true);
        if (parentProject != null && parentProject.getIsInvoicingTimesheet().booleanValue()) {
            project.setIsInvoicingTimesheet(true);
        }
        return project;
    }

    @Override
    public Project generatePhaseProject(SaleOrderLine saleOrderLine, Project parent) {
        Project project = this.generateProject(parent, saleOrderLine.getFullName(), saleOrderLine.getSaleOrder().getSalespersonUser(), parent.getCompany(), parent.getClientPartner());
        project.setProjectTypeSelect(ProjectRepository.TYPE_PHASE);
        saleOrderLine.setProject(project);
        return project;
    }

    @Transactional
    public Project createProjectFromTemplate(ProjectTemplate projectTemplate, String projectCode, Partner clientPartner) throws AxelorException {
        Project project = super.createProjectFromTemplate(projectTemplate, projectCode, clientPartner);
        if (projectTemplate.getIsBusinessProject().booleanValue()) {
            project.setCurrency(clientPartner.getCurrency());
            if (clientPartner.getPartnerAddressList() != null && !clientPartner.getPartnerAddressList().isEmpty()) {
                project.setCustomerAddress(clientPartner.getPartnerAddressList().iterator().next().getAddress());
            }
            if (clientPartner.getSalePartnerPriceList() != null && clientPartner.getSalePartnerPriceList().getPriceListSet() != null && !clientPartner.getSalePartnerPriceList().getPriceListSet().isEmpty()) {
                project.setPriceList((PriceList)clientPartner.getSalePartnerPriceList().getPriceListSet().iterator().next());
            }
            project.setIsInvoicingExpenses(projectTemplate.getIsInvoicingExpenses());
            project.setIsInvoicingPurchases(projectTemplate.getIsInvoicingPurchases());
            project.setInvoicingComment(projectTemplate.getInvoicingComment());
            project.setIsBusinessProject(projectTemplate.getIsBusinessProject());
        }
        return project;
    }

    public TeamTask createTask(TaskTemplate taskTemplate, Project project, Set<TaskTemplate> taskTemplateSet) {
        TeamTask task = super.createTask(taskTemplate, project, taskTemplateSet);
        return task;
    }
}

