/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.service.DurationService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.repo.ConsumptionLineRepository;
import com.axelor.apps.contract.db.repo.ContractLineRepository;
import com.axelor.apps.contract.db.repo.ContractRepository;
import com.axelor.apps.contract.service.ContractLineService;
import com.axelor.apps.contract.service.ContractServiceImpl;
import com.axelor.apps.contract.service.ContractVersionService;
import com.axelor.apps.project.db.Project;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;

public class ProjectContractServiceImpl
extends ContractServiceImpl {
    @Inject
    public ProjectContractServiceImpl(AppBaseService appBaseService, ContractVersionService versionService, ContractLineService contractLineService, DurationService durationService, ContractLineRepository contractLineRepo, ConsumptionLineRepository consumptionLineRepo, ContractRepository contractRepository) {
        super(appBaseService, versionService, contractLineService, durationService, contractLineRepo, consumptionLineRepo, contractRepository);
    }

    public Invoice generateInvoice(Contract contract) throws AxelorException {
        Invoice invoice = super.generateInvoice(contract);
        Project project = contract.getProject();
        if (project != null && project.getIsBusinessProject().booleanValue()) {
            invoice.setProject(project);
        }
        return invoice;
    }
}

