/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.generator.InvoiceLineGenerator;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.businessproject.service.app.AppBusinessProjectService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseOrderLineServiceImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceServiceImpl;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PurchaseOrderInvoiceProjectServiceImpl
extends PurchaseOrderInvoiceServiceImpl {
    @Inject
    private PriceListService priceListService;
    @Inject
    private PurchaseOrderLineServiceImpl purchaseOrderLineServiceImpl;
    @Inject
    protected AppBusinessProjectService appBusinessProjectService;
    @Inject
    protected ProductCompanyService productCompanyService;

    public void processPurchaseOrderLine(Invoice invoice, List<InvoiceLine> invoiceLineList, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        super.processPurchaseOrderLine(invoice, invoiceLineList, purchaseOrderLine);
        if (((AppBusinessProjectService)Beans.get(AppBusinessProjectService.class)).isApp("business-project")) {
            invoiceLineList.get(invoiceLineList.size() - 1).setProject(purchaseOrderLine.getProject());
        }
    }

    public List<InvoiceLine> createInvoiceLine(Invoice invoice, final PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        BigDecimal price;
        Product product = purchaseOrderLine.getProduct();
        Company company = purchaseOrderLine.getPurchaseOrder() != null ? purchaseOrderLine.getPurchaseOrder().getCompany() : null;
        BigDecimal discountAmount = price = (BigDecimal)this.productCompanyService.get(product, "costPrice", company);
        int discountTypeSelect = 1;
        if (invoice.getPartner().getChargeBackPurchaseSelect() == 2) {
            PriceList priceList = ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(invoice.getPartner(), 1);
            if (priceList != null) {
                PriceListLine priceListLine = this.purchaseOrderLineServiceImpl.getPriceListLine(purchaseOrderLine, priceList, price);
                if (priceListLine != null) {
                    discountTypeSelect = priceListLine.getTypeSelect();
                }
                if (this.appBusinessProjectService.getAppBase().getComputeMethodDiscountSelect() == 2 && discountTypeSelect == 3 || this.appBusinessProjectService.getAppBase().getComputeMethodDiscountSelect() == 3) {
                    Map discounts = this.priceListService.getDiscounts(priceList, priceListLine, price);
                    if (discounts != null) {
                        discountAmount = (BigDecimal)discounts.get("discountAmount");
                        price = this.priceListService.computeDiscount(price, ((Integer)discounts.get("discountTypeSelect")).intValue(), discountAmount);
                    }
                } else {
                    Map discounts = this.priceListService.getDiscounts(priceList, priceListLine, price);
                    if (discounts != null) {
                        discountAmount = (BigDecimal)discounts.get("discountAmount");
                        if (discounts.get("price") != null) {
                            price = (BigDecimal)discounts.get("price");
                        }
                    }
                }
            }
            InvoiceLineGenerator invoiceLineGenerator = new InvoiceLineGenerator(invoice, product, (String)this.productCompanyService.get(product, "name", company), price, price, price, purchaseOrderLine.getDescription(), purchaseOrderLine.getQty(), purchaseOrderLine.getUnit(), null, 0, discountAmount, discountTypeSelect, null, null, false){

                public List<InvoiceLine> creates() throws AxelorException {
                    InvoiceLine invoiceLine = this.createInvoiceLine();
                    invoiceLine.setProject(purchaseOrderLine.getProject());
                    ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                    invoiceLines.add(invoiceLine);
                    return invoiceLines;
                }
            };
            return invoiceLineGenerator.creates();
        }
        if (invoice.getPartner().getChargeBackPurchaseSelect() == 3) {
            price = price.multiply(invoice.getPartner().getChargeBackPurchase().divide(new BigDecimal(100), this.appBusinessProjectService.getNbDecimalDigitForUnitPrice(), 4)).setScale(this.appBusinessProjectService.getNbDecimalDigitForUnitPrice(), 4);
            InvoiceLineGenerator invoiceLineGenerator = new InvoiceLineGenerator(invoice, product, (String)this.productCompanyService.get(product, "name", company), price, price, price, purchaseOrderLine.getDescription(), purchaseOrderLine.getQty(), purchaseOrderLine.getUnit(), null, 0, discountAmount, discountTypeSelect, null, null, false){

                public List<InvoiceLine> creates() throws AxelorException {
                    InvoiceLine invoiceLine = this.createInvoiceLine();
                    invoiceLine.setProject(purchaseOrderLine.getProject());
                    ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                    invoiceLines.add(invoiceLine);
                    return invoiceLines;
                }
            };
            return invoiceLineGenerator.creates();
        }
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), purchaseOrderLine.getQty(), purchaseOrderLine.getUnit(), purchaseOrderLine.getSequence(), false, null, purchaseOrderLine, null){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                invoiceLine.setProject(this.purchaseOrderLine.getProject());
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(PurchaseOrder purchaseOrder) throws AxelorException {
        Invoice invoice = super.generateInvoice(purchaseOrder);
        if (purchaseOrder.getProject() != null) {
            invoice.setProject(purchaseOrder.getProject());
        }
        invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)((Object)invoice)));
        return invoice;
    }
}

