/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service;

import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.businessproject.service.PurchaseOrderLineProjectService;
import com.axelor.apps.businessproject.service.app.AppBusinessProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.supplychain.service.PurchaseOrderLineServiceSupplychainImpl;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;

public class PurchaseOrderLineServiceProjectImpl
extends PurchaseOrderLineServiceSupplychainImpl
implements PurchaseOrderLineProjectService {
    @Inject
    private PurchaseOrderLineRepository purchaseOrderLineRepo;

    public PurchaseOrderLine createPurchaseOrderLine(PurchaseOrder purchaseOrder, SaleOrderLine saleOrderLine) throws AxelorException {
        PurchaseOrderLine line = super.createPurchaseOrderLine(purchaseOrder, saleOrderLine);
        if (line != null && saleOrderLine != null && ((AppBusinessProjectService)Beans.get(AppBusinessProjectService.class)).isApp("business-project")) {
            line.setProject(saleOrderLine.getProject());
        }
        return line;
    }

    @Override
    @Transactional
    public void setProject(List<Long> purchaseOrderLineIds, Project project) {
        if (purchaseOrderLineIds != null) {
            List purchaseOrderLineList = this.purchaseOrderLineRepo.all().filter("self.id in ?1", new Object[]{purchaseOrderLineIds}).fetch();
            for (PurchaseOrderLine line : purchaseOrderLineList) {
                line.setProject(project);
                this.purchaseOrderLineRepo.save((Model)((Object)line));
            }
        }
    }

    public PurchaseOrderLine createAnalyticDistributionWithTemplate(PurchaseOrderLine purchaseOrderLine) {
        PurchaseOrderLine poLine = super.createAnalyticDistributionWithTemplate(purchaseOrderLine);
        List<AnalyticMoveLine> analyticMoveLineList = poLine.getAnalyticMoveLineList();
        if (poLine.getProject() != null && analyticMoveLineList != null) {
            analyticMoveLineList.forEach(analyticLine -> analyticLine.setProject(poLine.getProject()));
        }
        return poLine;
    }

    @Override
    public PurchaseOrderLine updateAnalyticDistributionWithProject(PurchaseOrderLine purchaseOrderLine) {
        for (AnalyticMoveLine analyticMoveLine : purchaseOrderLine.getAnalyticMoveLineList()) {
            analyticMoveLine.setProject(purchaseOrderLine.getProject());
        }
        return purchaseOrderLine;
    }
}

