/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service.batch;

import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.businessproject.db.InvoicingProject;
import com.axelor.apps.businessproject.service.InvoicingProjectService;
import com.axelor.apps.businessproject.service.batch.ProjectInvoicingAssistantBatchService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchInvoicingProjectService
extends AbstractBatch {
    protected ProjectRepository projectRepo;
    protected InvoicingProjectService invoicingProjectService;

    @Inject
    public BatchInvoicingProjectService(ProjectRepository projectRepo, InvoicingProjectService invoicingProjectService) {
        this.projectRepo = projectRepo;
        this.invoicingProjectService = invoicingProjectService;
    }

    protected void process() {
        Map<String, Object> contextValues = null;
        try {
            contextValues = ProjectInvoicingAssistantBatchService.createJsonContext(this.batch);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        ArrayList<Object> generatedInvoicingProjectList = new ArrayList<Object>();
        List projectList = this.projectRepo.all().filter("self.isBusinessProject = :isBusinessProject AND self.toInvoice = :toInvoice AND (self.statusSelect != :statusCanceled AND self.statusSelect != :statusFinished)").bind("isBusinessProject", (Object)true).bind("toInvoice", (Object)true).bind("statusCanceled", (Object)ProjectRepository.STATE_CANCELED).bind("statusFinished", (Object)ProjectRepository.STATE_FINISHED).fetch();
        for (Project project : projectList) {
            try {
                InvoicingProject invoicingProject = this.invoicingProjectService.generateInvoicingProject(project, this.batch.getProjectInvoicingAssistantBatch().getConsolidatePhaseSelect());
                if (invoicingProject == null || invoicingProject.getId() == null) continue;
                this.incrementDone();
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("id", invoicingProject.getId());
                generatedInvoicingProjectList.add(map);
            }
            catch (Exception e) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Project %s"), project.getId()), e), (String)"invoice", (long)this.batch.getId());
            }
        }
        ProjectInvoicingAssistantBatchService.updateJsonObject(this.batch, generatedInvoicingProjectList, "generatedInvoicingProjectSet", contextValues);
    }

    protected void stop() {
        String comment = String.format("\t* %s " + I18n.get((String)"Generated invoicing project") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        this.addComment(comment);
        super.stop();
    }
}

