/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service.projectgenerator.factory;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.businessproject.service.ProductTaskTemplateService;
import com.axelor.apps.businessproject.service.ProjectBusinessService;
import com.axelor.apps.businessproject.service.projectgenerator.ProjectGeneratorFactory;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.meta.schema.actions.ActionView;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ProjectGeneratorFactoryPhase
implements ProjectGeneratorFactory {
    private ProjectBusinessService projectBusinessService;
    private ProjectRepository projectRepository;
    private SaleOrderLineRepository saleOrderLineRepository;
    private ProductTaskTemplateService productTaskTemplateService;

    @Inject
    public ProjectGeneratorFactoryPhase(ProjectBusinessService projectBusinessService, ProjectRepository projectRepository, SaleOrderLineRepository saleOrderLineRepository, ProductTaskTemplateService productTaskTemplateService) {
        this.projectBusinessService = projectBusinessService;
        this.projectRepository = projectRepository;
        this.saleOrderLineRepository = saleOrderLineRepository;
        this.productTaskTemplateService = productTaskTemplateService;
    }

    @Override
    public Project create(SaleOrder saleOrder) {
        Project project = this.projectBusinessService.generateProject(saleOrder);
        project.setIsProject(true);
        project.setIsBusinessProject(true);
        return project;
    }

    @Override
    @Transactional
    public ActionView.ActionViewBuilder fill(Project project, SaleOrder saleOrder, LocalDateTime startDate) throws AxelorException {
        ArrayList<Project> projects = new ArrayList<Project>();
        this.projectRepository.save((Model)((Object)project));
        for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
            Product product = saleOrderLine.getProduct();
            if (product == null || !"service".equals(product.getProductTypeSelect()) || saleOrderLine.getSaleSupplySelect() != 3) continue;
            Project phase = this.projectBusinessService.generatePhaseProject(saleOrderLine, project);
            phase.setFromDate(startDate);
            this.saleOrderLineRepository.save((Model)((Object)saleOrderLine));
            projects.add(phase);
            if (CollectionUtils.isEmpty(product.getTaskTemplateSet())) continue;
            this.productTaskTemplateService.convert(product.getTaskTemplateSet().stream().filter(template -> Objects.isNull(template.getParentTaskTemplate())).collect(Collectors.toList()), phase, null, startDate, saleOrderLine.getQty(), saleOrderLine);
        }
        return ActionView.define((String)String.format("Project%s generated", projects.size() > 1 ? "s" : "")).model(Project.class.getName()).add("grid", "project-grid").add("form", "project-form").param("search-filters", "project-filters").domain(String.format("self.id in (%s)", StringTool.getIdListString(projects)));
    }
}

