/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service.projectgenerator.factory;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.businessproject.service.ProjectBusinessService;
import com.axelor.apps.businessproject.service.TeamTaskBusinessProjectService;
import com.axelor.apps.businessproject.service.projectgenerator.ProjectGeneratorFactory;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;

public class ProjectGeneratorFactoryTask
implements ProjectGeneratorFactory {
    private ProjectBusinessService projectBusinessService;
    private ProjectRepository projectRepository;
    private TeamTaskBusinessProjectService teamTaskBusinessProjectService;
    private TeamTaskRepository teamTaskRepository;
    private ProductCompanyService productCompanyService;

    @Inject
    public ProjectGeneratorFactoryTask(ProjectBusinessService projectBusinessService, ProjectRepository projectRepository, TeamTaskBusinessProjectService teamTaskBusinessProjectService, TeamTaskRepository teamTaskRepository, ProductCompanyService productCompanyService) {
        this.projectBusinessService = projectBusinessService;
        this.projectRepository = projectRepository;
        this.teamTaskBusinessProjectService = teamTaskBusinessProjectService;
        this.teamTaskRepository = teamTaskRepository;
        this.productCompanyService = productCompanyService;
    }

    @Override
    public Project create(SaleOrder saleOrder) {
        Project project = this.projectBusinessService.generateProject(saleOrder);
        project.setIsProject(true);
        project.setIsBusinessProject(true);
        return project;
    }

    @Override
    @Transactional(rollbackOn={Exception.class, AxelorException.class})
    public ActionView.ActionViewBuilder fill(Project project, SaleOrder saleOrder, LocalDateTime startDate) throws AxelorException {
        ArrayList<TeamTask> tasks = new ArrayList<TeamTask>();
        this.projectRepository.save((Model)((Object)project));
        for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
            boolean isTaskGenerated;
            Product product = saleOrderLine.getProduct();
            boolean bl = isTaskGenerated = this.teamTaskRepository.all().filter("self.saleOrderLine = ? AND self.project = ?", new Object[]{saleOrderLine, project}).fetch().size() > 0;
            if (product == null || !"service".equals((String)this.productCompanyService.get(product, "productTypeSelect", saleOrder.getCompany())) || saleOrderLine.getSaleSupplySelect() != 3 || isTaskGenerated) continue;
            TeamTask task = this.teamTaskBusinessProjectService.create(saleOrderLine, project, project.getAssignedTo());
            if (saleOrder.getToInvoiceViaTask().booleanValue()) {
                task.setInvoicingType(2);
            }
            task.setTaskDate(startDate.toLocalDate());
            task.setUnitPrice((BigDecimal)this.productCompanyService.get(product, "salePrice", saleOrder.getCompany()));
            task.setExTaxTotal(saleOrderLine.getExTaxTotal());
            if (project.getIsInvoicingTimesheet().booleanValue()) {
                task.setToInvoice(true);
            } else {
                task.setToInvoice(false);
            }
            this.teamTaskRepository.save((Model)((Object)task));
            tasks.add(task);
        }
        if (tasks == null || tasks.isEmpty()) {
            throw new AxelorException(3, I18n.get((String)"Products must be Service type and Method of Supply Produce."));
        }
        return ActionView.define((String)String.format("Task%s generated", tasks.size() > 1 ? "s" : "")).model(TeamTask.class.getName()).add("grid", "team-task-grid").add("form", "team-task-form").param("search-filters", "team-task-filters").domain(String.format("self.id in (%s)", StringTool.getIdListString(tasks)));
    }
}

