/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.service.projectgenerator.factory;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.businessproject.service.ProductTaskTemplateService;
import com.axelor.apps.businessproject.service.ProjectBusinessService;
import com.axelor.apps.businessproject.service.TeamTaskBusinessProjectService;
import com.axelor.apps.businessproject.service.projectgenerator.ProjectGeneratorFactory;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ProjectGeneratorFactoryTaskTemplate
implements ProjectGeneratorFactory {
    private ProjectBusinessService projectBusinessService;
    private ProjectRepository projectRepository;
    private TeamTaskBusinessProjectService teamTaskService;
    private TeamTaskRepository teamTaskRepository;
    private ProductTaskTemplateService productTaskTemplateService;
    private ProductCompanyService productCompanyService;

    @Inject
    public ProjectGeneratorFactoryTaskTemplate(ProjectBusinessService projectBusinessService, ProjectRepository projectRepository, TeamTaskBusinessProjectService teamTaskService, TeamTaskRepository teamTaskRepository, ProductTaskTemplateService productTaskTemplateService, ProductCompanyService productCompanyService) {
        this.projectBusinessService = projectBusinessService;
        this.projectRepository = projectRepository;
        this.teamTaskService = teamTaskService;
        this.teamTaskRepository = teamTaskRepository;
        this.productTaskTemplateService = productTaskTemplateService;
        this.productCompanyService = productCompanyService;
    }

    @Override
    public Project create(SaleOrder saleOrder) {
        Project project = this.projectBusinessService.generateProject(saleOrder);
        project.setIsProject(true);
        project.setIsBusinessProject(true);
        return project;
    }

    @Override
    @Transactional(rollbackOn={Exception.class, AxelorException.class})
    public ActionView.ActionViewBuilder fill(Project project, SaleOrder saleOrder, LocalDateTime startDate) throws AxelorException {
        ArrayList<Object> tasks = new ArrayList<Object>();
        TeamTask root = (TeamTask)((Object)this.teamTaskRepository.all().filter("self.project = ? AND self.assignedTo = ? AND self.name = ?", new Object[]{project, project.getAssignedTo(), saleOrder.getFullName()}).fetchOne());
        this.projectRepository.save((Model)((Object)project));
        for (SaleOrderLine orderLine : saleOrder.getSaleOrderLineList()) {
            boolean isTaskGenerated;
            Product product = orderLine.getProduct();
            if (product != null && (!"produce".equals((String)this.productCompanyService.get(product, "procurementMethodSelect", saleOrder.getCompany())) && orderLine.getSaleSupplySelect() != 3 || !"service".equals(product.getProductTypeSelect()))) continue;
            boolean bl = isTaskGenerated = this.teamTaskRepository.all().filter("self.saleOrderLine = ? AND self.project = ?", new Object[]{orderLine, project}).fetch().size() > 0;
            if (root == null) {
                root = this.teamTaskService.create(saleOrder.getFullName(), project, project.getAssignedTo());
                root.setTaskDate(startDate.toLocalDate());
                tasks.add(this.teamTaskRepository.save((Model)((Object)root)));
            }
            if (product == null || isTaskGenerated) continue;
            if (!CollectionUtils.isEmpty(product.getTaskTemplateSet())) {
                List<TeamTask> convertedTasks = this.productTaskTemplateService.convert(product.getTaskTemplateSet().stream().filter(template -> Objects.isNull(template.getParentTaskTemplate())).collect(Collectors.toList()), project, root, startDate, orderLine.getQty(), orderLine);
                convertedTasks.stream().forEach(task -> task.setSaleOrderLine(orderLine));
                tasks.addAll(convertedTasks);
                continue;
            }
            TeamTask childTask = this.teamTaskService.create(orderLine.getFullName(), project, project.getAssignedTo());
            this.updateTask(root, childTask, orderLine);
            tasks.add(this.teamTaskRepository.save((Model)((Object)childTask)));
        }
        if (root == null) {
            throw new AxelorException(3, I18n.get((String)"Please complete the order lines with at least one product type 'Service' and the supply mode 'Produce'"));
        }
        return ActionView.define((String)"Tasks").model(TeamTask.class.getName()).add("grid", "team-task-grid").add("form", "team-task-form").param("search-filters", "team-task-filters").domain("self.parentTask = " + root.getId());
    }

    private void updateTask(TeamTask root, TeamTask childTask, SaleOrderLine orderLine) throws AxelorException {
        childTask.setParentTask(root);
        childTask.setQuantity(orderLine.getQty());
        Product product = orderLine.getProduct();
        childTask.setProduct(product);
        childTask.setExTaxTotal(orderLine.getExTaxTotal());
        Company company = orderLine.getSaleOrder() != null ? orderLine.getSaleOrder().getCompany() : null;
        childTask.setUnitPrice(product != null ? (BigDecimal)this.productCompanyService.get(product, "salePrice", company) : null);
        childTask.setUnit(product != null ? (Unit)this.productCompanyService.get(product, "unit", company) : null);
        childTask.setSaleOrderLine(orderLine);
        if (orderLine.getSaleOrder().getToInvoiceViaTask().booleanValue()) {
            childTask.setToInvoice(true);
            childTask.setInvoicingType(2);
        }
    }
}

