/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.web;

import com.axelor.apps.businessproject.service.ExpenseLineProjectService;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.repo.ExpenseLineRepository;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.stream.Collectors;

public class ExpenseLineProjectController {
    public void setProject(ActionRequest request, ActionResponse response) {
        try {
            Project project = (Project)((Object)request.getContext().asType(Project.class));
            project = (Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(project.getId()));
            this.setProject(request, response, project);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    private void setProject(ActionRequest request, ActionResponse response, Project project) {
        List expenseLineSet = (List)request.getContext().get((Object)"expenseLineSet");
        if (expenseLineSet == null || expenseLineSet.isEmpty()) {
            response.setFlash("Please select lines");
        } else {
            List<Long> lineIds = expenseLineSet.stream().map(it -> Long.parseLong(it.get("id").toString())).collect(Collectors.toList());
            ((ExpenseLineProjectService)Beans.get(ExpenseLineProjectService.class)).setProject(lineIds, project);
            response.setAttr("$expenseLineSet", "hidden", (Object)true);
            response.setAttr("addSelectedExpenseLinesBtn", "hidden", (Object)true);
            response.setAttr("unlinkSelectedExpenseLinesBtn", "hidden", (Object)true);
            response.setAttr("cancelManageExpenseLinesBtn", "hidden", (Object)true);
            response.setAttr("expenseLinePanel", "refresh", (Object)true);
            response.setAttr("expensePanel", "refresh", (Object)true);
            response.setAttr("selectNewExpenseLinesBtn", "readonly", (Object)false);
            response.setAttr("manageExpenseLinesBtn", "readonly", (Object)false);
        }
    }

    public void unsetProject(ActionRequest request, ActionResponse response) {
        try {
            this.setProject(request, response, null);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    @Transactional
    public void updateToInvoice(ActionRequest request, ActionResponse response) {
        ExpenseLineRepository expenseLineRepository = (ExpenseLineRepository)Beans.get(ExpenseLineRepository.class);
        try {
            ExpenseLine expenseLine = (ExpenseLine)request.getContext().asType(ExpenseLine.class);
            expenseLine = (ExpenseLine)expenseLineRepository.find(expenseLine.getId());
            expenseLine.setToInvoice(Boolean.valueOf(expenseLine.getToInvoice() == false));
            expenseLineRepository.save((Model)expenseLine);
            response.setValue("toInvoice", (Object)expenseLine.getToInvoice());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

