/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.businessproject.db.InvoicingProject;
import com.axelor.apps.businessproject.db.repo.InvoicingProjectRepository;
import com.axelor.apps.businessproject.service.InvoicingProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class InvoicingProjectController {
    @Inject
    private InvoicingProjectRepository invoicingProjectRepository;

    public void fillIn(ActionRequest request, ActionResponse response) throws AxelorException {
        InvoicingProject invoicingProject = (InvoicingProject)((Object)request.getContext().asType(InvoicingProject.class));
        InvoicingProjectService invoicingProjectService = (InvoicingProjectService)Beans.get(InvoicingProjectService.class);
        Project project = invoicingProject.getProject();
        if (project == null) {
            throw new AxelorException(4, I18n.get((String)"You must select a project/task"));
        }
        invoicingProjectService.clearLines(invoicingProject);
        invoicingProjectService.setLines(invoicingProject, project, 0);
        response.setValues((Object)invoicingProject);
    }

    public void generateInvoice(ActionRequest request, ActionResponse response) throws AxelorException {
        ArrayList<Long> invoiceIdList = new ArrayList<Long>();
        List projects = new ArrayList<Model>();
        String ids = null;
        if (request.getContext().get((Object)"_ids") != null) {
            projects = this.invoicingProjectRepository.all().filter("self.id in ? and self.invoice = null", new Object[]{(List)request.getContext().get((Object)"_ids")}).fetch();
        } else if (((InvoicingProject)((Object)request.getContext().asType(InvoicingProject.class))).getId() != null) {
            projects.add(this.invoicingProjectRepository.find(((InvoicingProject)((Object)request.getContext().asType(InvoicingProject.class))).getId()));
        } else {
            response.setError("Please select lines");
            return;
        }
        if (projects.size() > 0) {
            for (InvoicingProject invProject : projects) {
                Invoice invoice = ((InvoicingProjectService)Beans.get(InvoicingProjectService.class)).generateInvoice(invProject);
                if (invoice == null) continue;
                invoiceIdList.add(invoice.getId());
                try {
                    ((InvoicingProjectService)Beans.get(InvoicingProjectService.class)).generateAnnex(invProject);
                }
                catch (IOException e) {
                    TraceBackService.trace((ActionResponse)response, (Throwable)e);
                }
            }
            ids = StringUtils.join(invoiceIdList, (String)",");
            ActionView.ActionViewBuilder view = ActionView.define((String)I18n.get((String)"Invoice")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters");
            response.setReload(true);
            response.setView(ids.contains(",") ? view.domain("self.id IN (" + ids + ")").map() : view.context("_showRecord", (Object)ids).map());
        }
    }
}

