/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.businessproject.db.InvoicingProject;
import com.axelor.apps.businessproject.service.InvoicingProjectService;
import com.axelor.apps.businessproject.service.ProjectBusinessService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProjectController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void generateQuotation(ActionRequest request, ActionResponse response) {
        try {
            Project project = (Project)((Object)request.getContext().asType(Project.class));
            SaleOrder order = ((ProjectBusinessService)Beans.get(ProjectBusinessService.class)).generateQuotation(project);
            response.setView(ActionView.define((String)I18n.get((String)"Sale quotation")).model(SaleOrder.class.getName()).add("form", "sale-order-form").param("forceTitle", "true").context("_showRecord", (Object)String.valueOf(order.getId())).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generatePurchaseQuotation(ActionRequest request, ActionResponse response) {
        Project project = (Project)((Object)request.getContext().asType(Project.class));
        if (project.getId() != null) {
            response.setView(ActionView.define((String)"Purchase Order").model(PurchaseOrder.class.getName()).add("form", "purchase-order-form").add("grid", "purchase-order-quotation-grid").param("search-filters", "purchase-order-filters").context("_project", (Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(project.getId())).map());
        }
    }

    public void printProject(ActionRequest request, ActionResponse response) throws AxelorException {
        Project project = (Project)((Object)request.getContext().asType(Project.class));
        String name = I18n.get((String)"Project") + " " + (project.getCode() != null ? project.getCode() : "");
        String fileLink = ReportFactory.createReport((String)"Project.rptdesign", (String)(name + "-${date}")).addParam("ProjectId", (Object)project.getId()).addParam("Timezone", project.getCompany() != null ? project.getCompany().getTimezone() : null).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).toAttach((Model)((Object)project)).generate().getFileLink();
        this.logger.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void computeProgress(ActionRequest request, ActionResponse response) {
        BigDecimal duration = BigDecimal.ZERO;
        if (duration.compareTo(BigDecimal.ZERO) == -1 || duration.compareTo(new BigDecimal(100)) == 1) {
            duration = BigDecimal.ZERO;
        }
        response.setValue("progress", (Object)duration);
    }

    public void countToInvoice(ActionRequest request, ActionResponse response) {
        Project project = (Project)((Object)request.getContext().asType(Project.class));
        int toInvoiceCount = 0;
        if (project.getId() != null) {
            toInvoiceCount = ((InvoicingProjectService)Beans.get(InvoicingProjectService.class)).countToInvoice(project);
        }
        response.setValue("$toInvoiceCounter", (Object)toInvoiceCount);
    }

    public void showInvoicingProjects(ActionRequest request, ActionResponse response) {
        Project project = (Project)((Object)request.getContext().asType(Project.class));
        project = (Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(project.getId()));
        response.setView(ActionView.define((String)"Invoice Buisness Project").model(InvoicingProject.class.getName()).add("form", "invoicing-project-form").param("forceEdit", "true").param("show-toolbar", "false").context("_project", (Object)project).map());
    }

    public void printPlannifAndCost(ActionRequest request, ActionResponse response) throws AxelorException {
        Project project = (Project)((Object)request.getContext().asType(Project.class));
        String name = I18n.get((String)"Planification and costs");
        if (project.getCode() != null) {
            name = name + " (" + project.getCode() + ")";
        }
        String fileLink = ReportFactory.createReport((String)"PlannificationAndCost.rptdesign", (String)name).addParam("ProjectId", (Object)project.getId()).addParam("Timezone", project.getCompany() != null ? project.getCompany().getTimezone() : null).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).toAttach((Model)((Object)project)).generate().getFileLink();
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void getPartnerData(ActionRequest request, ActionResponse response) {
        Project project = (Project)((Object)request.getContext().asType(Project.class));
        Partner partner = project.getClientPartner();
        if (partner != null) {
            response.setValue("currency", (Object)partner.getCurrency());
            response.setValue("priceList", project.getClientPartner() != null ? ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(project.getClientPartner(), 1) : null);
        }
    }
}

