/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.web;

import com.axelor.apps.businessproject.service.SaleOrderLineProjectService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.stream.Collectors;

public class SaleOrderLineProjectController {
    public void setProject(ActionRequest request, ActionResponse response) {
        try {
            Project project = (Project)((Object)request.getContext().asType(Project.class));
            project = (Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(project.getId()));
            this.setProject(request, response, project);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    private void setProject(ActionRequest request, ActionResponse response, Project project) {
        List saleOrderLineSet = (List)request.getContext().get((Object)"salesOrderLineSet");
        if (saleOrderLineSet == null || saleOrderLineSet.isEmpty()) {
            response.setFlash("Please select lines");
        } else {
            List<Long> lineIds = saleOrderLineSet.stream().map(it -> Long.parseLong(it.get("id").toString())).collect(Collectors.toList());
            ((SaleOrderLineProjectService)Beans.get(SaleOrderLineProjectService.class)).setProject(lineIds, project);
            response.setAttr("$salesOrderLineSet", "hidden", (Object)true);
            response.setAttr("addSelectedSOLinesBtn", "hidden", (Object)true);
            response.setAttr("unlinkSelectedSOLinesBtn", "hidden", (Object)true);
            response.setAttr("cancelManageSOLinesBtn", "hidden", (Object)true);
            response.setAttr("saleOrderLinePanel", "refresh", (Object)true);
            response.setAttr("saleOrderPanel", "refresh", (Object)true);
            response.setAttr("selectNewSOLinesBtn", "readonly", (Object)false);
            response.setAttr("manageSOLinesBtn", "readonly", (Object)false);
        }
    }

    public void unsetProject(ActionRequest request, ActionResponse response) {
        try {
            this.setProject(request, response, null);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    @Transactional
    public void updateToInvoice(ActionRequest request, ActionResponse response) {
        SaleOrderLineRepository saleOrderLineRepository = (SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class));
        try {
            SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
            saleOrderLine = (SaleOrderLine)((Object)saleOrderLineRepository.find(saleOrderLine.getId()));
            saleOrderLine.setToInvoice(saleOrderLine.getToInvoice() == false);
            saleOrderLineRepository.save((Model)((Object)saleOrderLine));
            response.setValue("toInvoice", (Object)saleOrderLine.getToInvoice());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateAnalyticDistributionWithProject(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
            if (saleOrderLine.getAnalyticMoveLineList() == null) {
                return;
            }
            saleOrderLine = ((SaleOrderLineProjectService)Beans.get(SaleOrderLineProjectService.class)).updateAnalyticDistributionWithProject(saleOrderLine);
            response.setValue("analyticMoveLineList", saleOrderLine.getAnalyticMoveLineList());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

