/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.web;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.businessproject.service.SaleOrderServiceProjectImpl;
import com.axelor.apps.businessproject.service.projectgenerator.ProjectGeneratorFactory;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectGeneratorType;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;

@Singleton
public class SaleOrderProjectController {
    private static final String CONTEXT_SHOW_RECORD = "_showRecord";

    public void generateProject(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            if (saleOrder.getSaleOrderLineList() == null || saleOrder.getSaleOrderLineList().isEmpty()) {
                response.setAlert(I18n.get((String)"Please complete the order lines with at least one product type 'Service' and the supply mode 'Produce'"));
                return;
            }
            String generatorType = (String)request.getContext().get((Object)"_projectGeneratorType");
            LocalDateTime startDate = this.getElementStartDate(request.getContext());
            ProjectGeneratorType projectGeneratorType = ProjectGeneratorType.valueOf(generatorType);
            ProjectGeneratorFactory factory = ProjectGeneratorFactory.getFactory(projectGeneratorType);
            Project project = projectGeneratorType.equals((Object)ProjectGeneratorType.PROJECT_ALONE) ? factory.create(saleOrder) : factory.generate(saleOrder, startDate);
            response.setReload(true);
            response.setView(ActionView.define((String)"Project").model(Project.class.getName()).add("form", "project-form").param("forceEdit", "true").context(CONTEXT_SHOW_RECORD, (Object)String.valueOf(project.getId())).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
            response.setReload(true);
        }
    }

    public void fillProject(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            if (saleOrder.getSaleOrderLineList() == null || saleOrder.getSaleOrderLineList() != null && saleOrder.getSaleOrderLineList().isEmpty()) {
                response.setAlert(I18n.get((String)"Please complete the order lines with at least one product type 'Service' and the supply mode 'Produce'"));
                return;
            }
            String generatorType = (String)request.getContext().get((Object)"_projectGeneratorType");
            LocalDateTime startDate = this.getElementStartDate(request.getContext());
            ProjectGeneratorFactory factory = ProjectGeneratorFactory.getFactory(ProjectGeneratorType.valueOf(generatorType));
            ActionView.ActionViewBuilder view = factory.fill(saleOrder.getProject(), saleOrder, startDate);
            response.setReload(true);
            response.setView(view.map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }

    public void updateLines(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            saleOrder = ((SaleOrderServiceProjectImpl)((Object)Beans.get(SaleOrderServiceProjectImpl.class))).updateLines(saleOrder);
            response.setValue("saleOrderLineList", saleOrder.getSaleOrderLineList());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private LocalDateTime getElementStartDate(Context context) {
        String stringStartDate = (String)context.get((Object)"_elementStartDate");
        LocalDateTime date = !Strings.isNullOrEmpty((String)stringStartDate) ? LocalDateTime.ofInstant(Instant.parse(stringStartDate), ZoneId.systemDefault()) : ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate((Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)).atStartOfDay();
        return date;
    }
}

