/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="PURCHASE_PURCHASE_CONFIG")
@Track(fields={@TrackField(name="company", on={TrackEvent.UPDATE}), @TrackField(name="purchaseOrderInAtiSelect", on={TrackEvent.UPDATE}), @TrackField(name="purchaseOrderSupplierBox", on={TrackEvent.UPDATE}), @TrackField(name="displayBuyerOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayProductCodeOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayTaxDetailOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displaySupplierCodeOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayProductDetailOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="priceRequest", on={TrackEvent.UPDATE}), @TrackField(name="isAnalyticDistributionRequired", on={TrackEvent.UPDATE})})
public class PurchaseConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_PURCHASE_CONFIG_SEQ")
    @SequenceGenerator(name="PURCHASE_PURCHASE_CONFIG_SEQ", sequenceName="PURCHASE_PURCHASE_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Company")
    @NotNull
    @JoinColumn(unique=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Purchase orders ATI/WT", selection="base.in.ati.select")
    private Integer purchaseOrderInAtiSelect = 1;
    @Widget(title="Supplier box in purchase order", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String purchaseOrderSupplierBox;
    @Widget(title="Display price on requested purchase printing")
    private Boolean displayPriceOnQuotationRequest = Boolean.FALSE;
    @Widget(title="Display buyer on printing")
    private Boolean displayBuyerOnPrinting = Boolean.FALSE;
    @Widget(title="Display product code on printing")
    private Boolean displayProductCodeOnPrinting = Boolean.FALSE;
    @Widget(title="Display tax detail on printing")
    private Boolean displayTaxDetailOnPrinting = Boolean.FALSE;
    @Widget(title="Display supplier code on printing")
    private Boolean displaySupplierCodeOnPrinting = Boolean.FALSE;
    @Widget(title="Display product detail on printing")
    private Boolean displayProductDetailOnPrinting = Boolean.FALSE;
    @Widget(title="Message for requesting prices")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String priceRequest;
    @Widget(title="Analytic distribution required on purchase order line")
    private Boolean isAnalyticDistributionRequired = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getPurchaseOrderInAtiSelect() {
        return this.purchaseOrderInAtiSelect == null ? 0 : this.purchaseOrderInAtiSelect;
    }

    public void setPurchaseOrderInAtiSelect(Integer purchaseOrderInAtiSelect) {
        this.purchaseOrderInAtiSelect = purchaseOrderInAtiSelect;
    }

    public String getPurchaseOrderSupplierBox() {
        return this.purchaseOrderSupplierBox;
    }

    public void setPurchaseOrderSupplierBox(String purchaseOrderSupplierBox) {
        this.purchaseOrderSupplierBox = purchaseOrderSupplierBox;
    }

    public Boolean getDisplayPriceOnQuotationRequest() {
        return this.displayPriceOnQuotationRequest == null ? Boolean.FALSE : this.displayPriceOnQuotationRequest;
    }

    public void setDisplayPriceOnQuotationRequest(Boolean displayPriceOnQuotationRequest) {
        this.displayPriceOnQuotationRequest = displayPriceOnQuotationRequest;
    }

    public Boolean getDisplayBuyerOnPrinting() {
        return this.displayBuyerOnPrinting == null ? Boolean.FALSE : this.displayBuyerOnPrinting;
    }

    public void setDisplayBuyerOnPrinting(Boolean displayBuyerOnPrinting) {
        this.displayBuyerOnPrinting = displayBuyerOnPrinting;
    }

    public Boolean getDisplayProductCodeOnPrinting() {
        return this.displayProductCodeOnPrinting == null ? Boolean.FALSE : this.displayProductCodeOnPrinting;
    }

    public void setDisplayProductCodeOnPrinting(Boolean displayProductCodeOnPrinting) {
        this.displayProductCodeOnPrinting = displayProductCodeOnPrinting;
    }

    public Boolean getDisplayTaxDetailOnPrinting() {
        return this.displayTaxDetailOnPrinting == null ? Boolean.FALSE : this.displayTaxDetailOnPrinting;
    }

    public void setDisplayTaxDetailOnPrinting(Boolean displayTaxDetailOnPrinting) {
        this.displayTaxDetailOnPrinting = displayTaxDetailOnPrinting;
    }

    public Boolean getDisplaySupplierCodeOnPrinting() {
        return this.displaySupplierCodeOnPrinting == null ? Boolean.FALSE : this.displaySupplierCodeOnPrinting;
    }

    public void setDisplaySupplierCodeOnPrinting(Boolean displaySupplierCodeOnPrinting) {
        this.displaySupplierCodeOnPrinting = displaySupplierCodeOnPrinting;
    }

    public Boolean getDisplayProductDetailOnPrinting() {
        return this.displayProductDetailOnPrinting == null ? Boolean.FALSE : this.displayProductDetailOnPrinting;
    }

    public void setDisplayProductDetailOnPrinting(Boolean displayProductDetailOnPrinting) {
        this.displayProductDetailOnPrinting = displayProductDetailOnPrinting;
    }

    public String getPriceRequest() {
        return this.priceRequest;
    }

    public void setPriceRequest(String priceRequest) {
        this.priceRequest = priceRequest;
    }

    public Boolean getIsAnalyticDistributionRequired() {
        return this.isAnalyticDistributionRequired == null ? Boolean.FALSE : this.isAnalyticDistributionRequired;
    }

    public void setIsAnalyticDistributionRequired(Boolean isAnalyticDistributionRequired) {
        this.isAnalyticDistributionRequired = isAnalyticDistributionRequired;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseConfig)) {
            return false;
        }
        PurchaseConfig other = (PurchaseConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals((Object)this.getCompany(), (Object)other.getCompany());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{102939587, this.getCompany()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("purchaseOrderInAtiSelect", (Object)this.getPurchaseOrderInAtiSelect()).add("displayPriceOnQuotationRequest", (Object)this.getDisplayPriceOnQuotationRequest()).add("displayBuyerOnPrinting", (Object)this.getDisplayBuyerOnPrinting()).add("displayProductCodeOnPrinting", (Object)this.getDisplayProductCodeOnPrinting()).add("displayTaxDetailOnPrinting", (Object)this.getDisplayTaxDetailOnPrinting()).add("displaySupplierCodeOnPrinting", (Object)this.getDisplaySupplierCodeOnPrinting()).add("displayProductDetailOnPrinting", (Object)this.getDisplayProductDetailOnPrinting()).add("isAnalyticDistributionRequired", (Object)this.getIsAnalyticDistributionRequired()).omitNullValues().toString();
    }
}

