/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.purchase.db.PurchaseRequest;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PURCHASE_PURCHASE_REQUEST_LINE", indexes={@Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="purchase_request")})
public class PurchaseRequestLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_PURCHASE_REQUEST_LINE_SEQ")
    @SequenceGenerator(name="PURCHASE_PURCHASE_REQUEST_LINE_SEQ", sequenceName="PURCHASE_PURCHASE_REQUEST_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="New product")
    private Boolean newProduct = Boolean.FALSE;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Quantity")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=10)
    private BigDecimal quantity = BigDecimal.ZERO;
    @Widget(title="Product")
    private String productTitle;
    @Widget(title="Purchase request")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseRequest purchaseRequest;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Boolean getNewProduct() {
        return this.newProduct == null ? Boolean.FALSE : this.newProduct;
    }

    public void setNewProduct(Boolean newProduct) {
        this.newProduct = newProduct;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getQuantity() {
        return this.quantity == null ? BigDecimal.ZERO : this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getProductTitle() {
        return this.productTitle;
    }

    public void setProductTitle(String productTitle) {
        this.productTitle = productTitle;
    }

    public PurchaseRequest getPurchaseRequest() {
        return this.purchaseRequest;
    }

    public void setPurchaseRequest(PurchaseRequest purchaseRequest) {
        this.purchaseRequest = purchaseRequest;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseRequestLine)) {
            return false;
        }
        PurchaseRequestLine other = (PurchaseRequestLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("newProduct", (Object)this.getNewProduct()).add("quantity", (Object)this.getQuantity()).add("productTitle", (Object)this.getProductTitle()).omitNullValues().toString();
    }
}

