/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ShippingCoef;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PURCHASE_SUPPLIER_CATALOG", indexes={@Index(columnList="product"), @Index(columnList="supplier_partner")})
public class SupplierCatalog
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_SUPPLIER_CATALOG_SEQ")
    @SequenceGenerator(name="PURCHASE_SUPPLIER_CATALOG_SEQ", sequenceName="PURCHASE_SUPPLIER_CATALOG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Product")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Supplier")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner supplierPartner;
    @Widget(title="Product name on catalog")
    private String productSupplierName;
    @Widget(title="Product code on catalog")
    private String productSupplierCode;
    @Widget(title="Unit price")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=10)
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Last update")
    private LocalDate updateDate;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Calculated price/Qty")
    private BigDecimal calculatedPrice = BigDecimal.ZERO;
    @Widget(title="Shipping Coefficients")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="supplierCatalog", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ShippingCoef> shippingCoefList;
    @Widget(title="Quantity min")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=10)
    private BigDecimal minQty = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Partner getSupplierPartner() {
        return this.supplierPartner;
    }

    public void setSupplierPartner(Partner supplierPartner) {
        this.supplierPartner = supplierPartner;
    }

    public String getProductSupplierName() {
        return this.productSupplierName;
    }

    public void setProductSupplierName(String productSupplierName) {
        this.productSupplierName = productSupplierName;
    }

    public String getProductSupplierCode() {
        return this.productSupplierCode;
    }

    public void setProductSupplierCode(String productSupplierCode) {
        this.productSupplierCode = productSupplierCode;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public LocalDate getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(LocalDate updateDate) {
        this.updateDate = updateDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getCalculatedPrice() {
        return this.calculatedPrice == null ? BigDecimal.ZERO : this.calculatedPrice;
    }

    public void setCalculatedPrice(BigDecimal calculatedPrice) {
        this.calculatedPrice = calculatedPrice;
    }

    public List<ShippingCoef> getShippingCoefList() {
        return this.shippingCoefList;
    }

    public void setShippingCoefList(List<ShippingCoef> shippingCoefList) {
        this.shippingCoefList = shippingCoefList;
    }

    public void addShippingCoefListItem(ShippingCoef item) {
        if (this.getShippingCoefList() == null) {
            this.setShippingCoefList(new ArrayList<ShippingCoef>());
        }
        this.getShippingCoefList().add(item);
        item.setSupplierCatalog(this);
    }

    public void removeShippingCoefListItem(ShippingCoef item) {
        if (this.getShippingCoefList() == null) {
            return;
        }
        this.getShippingCoefList().remove((Object)item);
    }

    public void clearShippingCoefList() {
        if (this.getShippingCoefList() != null) {
            this.getShippingCoefList().clear();
        }
    }

    public BigDecimal getMinQty() {
        return this.minQty == null ? BigDecimal.ZERO : this.minQty;
    }

    public void setMinQty(BigDecimal minQty) {
        this.minQty = minQty;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SupplierCatalog)) {
            return false;
        }
        SupplierCatalog other = (SupplierCatalog)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("productSupplierName", (Object)this.getProductSupplierName()).add("productSupplierCode", (Object)this.getProductSupplierCode()).add("price", (Object)this.getPrice()).add("updateDate", (Object)this.getUpdateDate()).add("calculatedPrice", (Object)this.getCalculatedPrice()).add("minQty", (Object)this.getMinQty()).omitNullValues().toString();
    }
}

