/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service;

import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.ProductMultipleQtyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.base.service.tax.FiscalPositionService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.PurchaseProductService;
import com.axelor.apps.purchase.service.SupplierCatalogService;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.apps.tool.ContextTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderLineServiceImpl
implements PurchaseOrderLineService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    protected CurrencyService currencyService;
    @Inject
    protected AccountManagementService accountManagementService;
    @Inject
    protected PriceListService priceListService;
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    protected PurchaseProductService productService;
    @Inject
    protected ProductMultipleQtyService productMultipleQtyService;
    @Inject
    protected AppPurchaseService appPurchaseService;
    @Inject
    protected SupplierCatalogService supplierCatalogService;
    @Inject
    protected ProductCompanyService productCompanyService;
    @Deprecated
    private int sequence = 0;

    @Override
    public Map<String, BigDecimal> compute(PurchaseOrderLine purchaseOrderLine, PurchaseOrder purchaseOrder) throws AxelorException {
        BigDecimal companyInTaxTotal;
        BigDecimal companyExTaxTotal;
        BigDecimal inTaxTotal;
        BigDecimal exTaxTotal;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (purchaseOrder == null || purchaseOrderLine.getPrice() == null || purchaseOrderLine.getInTaxPrice() == null || purchaseOrderLine.getQty() == null) {
            return map;
        }
        BigDecimal priceDiscounted = this.computeDiscount(purchaseOrderLine, purchaseOrder.getInAti());
        BigDecimal taxRate = BigDecimal.ZERO;
        if (purchaseOrderLine.getTaxLine() != null) {
            taxRate = purchaseOrderLine.getTaxLine().getValue();
        }
        if (!purchaseOrder.getInAti().booleanValue()) {
            exTaxTotal = PurchaseOrderLineServiceImpl.computeAmount(purchaseOrderLine.getQty(), priceDiscounted);
            inTaxTotal = exTaxTotal.add(exTaxTotal.multiply(taxRate));
            companyExTaxTotal = this.getCompanyExTaxTotal(exTaxTotal, purchaseOrder);
            companyInTaxTotal = companyExTaxTotal.add(companyExTaxTotal.multiply(taxRate));
        } else {
            inTaxTotal = PurchaseOrderLineServiceImpl.computeAmount(purchaseOrderLine.getQty(), priceDiscounted);
            exTaxTotal = inTaxTotal.divide(taxRate.add(BigDecimal.ONE), 2, 4);
            companyInTaxTotal = this.getCompanyExTaxTotal(inTaxTotal, purchaseOrder);
            companyExTaxTotal = companyInTaxTotal.divide(taxRate.add(BigDecimal.ONE), 2, 4);
        }
        if (purchaseOrderLine.getProduct() != null) {
            map.put("saleMinPrice", this.getMinSalePrice(purchaseOrder, purchaseOrderLine));
            map.put("salePrice", this.getSalePrice(purchaseOrder, purchaseOrderLine.getProduct(), purchaseOrder.getInAti() != false ? purchaseOrderLine.getInTaxPrice() : purchaseOrderLine.getPrice()));
        }
        map.put("exTaxTotal", exTaxTotal);
        map.put("inTaxTotal", inTaxTotal);
        map.put("companyExTaxTotal", companyExTaxTotal);
        map.put("companyInTaxTotal", companyInTaxTotal);
        map.put("priceDiscounted", priceDiscounted);
        purchaseOrderLine.setExTaxTotal(exTaxTotal);
        purchaseOrderLine.setInTaxTotal(inTaxTotal);
        purchaseOrderLine.setPriceDiscounted(priceDiscounted);
        purchaseOrderLine.setCompanyExTaxTotal(companyExTaxTotal);
        purchaseOrderLine.setCompanyInTaxTotal(companyInTaxTotal);
        purchaseOrderLine.setSaleMinPrice(this.getMinSalePrice(purchaseOrder, purchaseOrderLine));
        purchaseOrderLine.setSalePrice(this.getSalePrice(purchaseOrder, purchaseOrderLine.getProduct(), purchaseOrder.getInAti() != false ? purchaseOrderLine.getInTaxPrice() : purchaseOrderLine.getPrice()));
        return map;
    }

    public static BigDecimal computeAmount(BigDecimal quantity, BigDecimal price) {
        BigDecimal amount = quantity.multiply(price).setScale(2, RoundingMode.HALF_EVEN);
        LOG.debug("Calcul du montant HT avec une quantit\u00e9 de {} pour {} : {}", new Object[]{quantity, price, amount});
        return amount;
    }

    @Override
    public String[] getProductSupplierInfos(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        Product product = purchaseOrderLine.getProduct();
        String productName = "";
        String productCode = "";
        if (product == null) {
            return new String[]{productName, productCode};
        }
        SupplierCatalog supplierCatalog = this.supplierCatalogService.getSupplierCatalog(product, purchaseOrder.getSupplierPartner(), purchaseOrder.getCompany());
        if (supplierCatalog != null) {
            productName = supplierCatalog.getProductSupplierName();
            productCode = supplierCatalog.getProductSupplierCode();
        }
        return new String[]{Strings.isNullOrEmpty((String)productName) ? product.getName() : productName, Strings.isNullOrEmpty((String)productCode) ? product.getCode() : productCode};
    }

    @Override
    public BigDecimal getExTaxUnitPrice(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine, TaxLine taxLine) throws AxelorException {
        return this.getUnitPrice(purchaseOrder, purchaseOrderLine, taxLine, false);
    }

    @Override
    public BigDecimal getInTaxUnitPrice(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine, TaxLine taxLine) throws AxelorException {
        return this.getUnitPrice(purchaseOrder, purchaseOrderLine, taxLine, true);
    }

    private BigDecimal getUnitPrice(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine, TaxLine taxLine, boolean resultInAti) throws AxelorException {
        BigDecimal purchasePrice = new BigDecimal(0);
        Currency purchaseCurrency = null;
        Product product = purchaseOrderLine.getProduct();
        SupplierCatalog supplierCatalog = this.supplierCatalogService.getSupplierCatalog(product, purchaseOrder.getSupplierPartner(), purchaseOrder.getCompany());
        if (supplierCatalog != null) {
            purchasePrice = supplierCatalog.getPrice();
            purchaseCurrency = supplierCatalog.getSupplierPartner().getCurrency();
        } else if (product != null) {
            purchasePrice = (BigDecimal)this.productCompanyService.get(product, "purchasePrice", purchaseOrder.getCompany());
            purchaseCurrency = (Currency)this.productCompanyService.get(product, "purchaseCurrency", purchaseOrder.getCompany());
        }
        Boolean inAti = (Boolean)this.productCompanyService.get(product, "inAti", purchaseOrder.getCompany());
        BigDecimal price = inAti == resultInAti ? purchasePrice : this.convertUnitPrice(inAti, taxLine, purchasePrice);
        return this.currencyService.getAmountCurrencyConvertedAtDate(purchaseCurrency, purchaseOrder.getCurrency(), price, purchaseOrder.getOrderDate()).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
    }

    @Override
    public PurchaseOrderLine fill(PurchaseOrderLine line, PurchaseOrder purchaseOrder) throws AxelorException {
        Preconditions.checkNotNull((Object)((Object)line), (Object)I18n.get((String)"The line cannot be null."));
        Preconditions.checkNotNull((Object)((Object)purchaseOrder), (Object)I18n.get((String)"You need a purchase order associated to line."));
        Partner supplierPartner = purchaseOrder.getSupplierPartner();
        Product product = line.getProduct();
        String[] productSupplierInfos = this.getProductSupplierInfos(purchaseOrder, line);
        if (!line.getEnableFreezeFields().booleanValue()) {
            line.setProductName(productSupplierInfos[0]);
            line.setQty(this.getQty(purchaseOrder, line));
        }
        line.setProductCode(productSupplierInfos[1]);
        line.setUnit(this.getPurchaseUnit(line));
        if (this.appPurchaseService.getAppPurchase().getIsEnabledProductDescriptionCopy().booleanValue()) {
            line.setDescription(product.getDescription());
        }
        TaxLine taxLine = this.getTaxLine(purchaseOrder, line);
        line.setTaxLine(taxLine);
        BigDecimal price = this.getExTaxUnitPrice(purchaseOrder, line, taxLine);
        BigDecimal inTaxPrice = this.getInTaxUnitPrice(purchaseOrder, line, taxLine);
        if (price == null || inTaxPrice == null) {
            throw new AxelorException(5, I18n.get((String)"This product is not available from the supplier."));
        }
        Tax tax = this.accountManagementService.getProductTax(product, purchaseOrder.getCompany(), supplierPartner.getFiscalPosition(), true);
        TaxEquiv taxEquiv = ((FiscalPositionService)Beans.get(FiscalPositionService.class)).getTaxEquiv(supplierPartner.getFiscalPosition(), tax);
        line.setTaxEquiv(taxEquiv);
        Map<String, Object> discounts = this.getDiscountsFromPriceLists(purchaseOrder, line, purchaseOrder.getInAti() != false ? inTaxPrice : price);
        if (discounts != null) {
            if (discounts.get("price") != null) {
                BigDecimal discountPrice = (BigDecimal)discounts.get("price");
                if (product.getInAti().booleanValue()) {
                    inTaxPrice = discountPrice;
                    price = this.convertUnitPrice(true, line.getTaxLine(), discountPrice);
                } else {
                    price = discountPrice;
                    inTaxPrice = this.convertUnitPrice(false, line.getTaxLine(), discountPrice);
                }
            }
            if (product.getInAti() != purchaseOrder.getInAti() && (Integer)discounts.get("discountTypeSelect") != 1) {
                line.setDiscountAmount(this.convertUnitPrice(product.getInAti(), line.getTaxLine(), (BigDecimal)discounts.get("discountAmount")));
            } else {
                line.setDiscountAmount((BigDecimal)discounts.get("discountAmount"));
            }
            line.setDiscountTypeSelect((Integer)discounts.get("discountTypeSelect"));
        }
        if (!line.getEnableFreezeFields().booleanValue()) {
            line.setPrice(price);
        }
        line.setInTaxPrice(inTaxPrice);
        line.setSaleMinPrice(this.getMinSalePrice(purchaseOrder, line));
        line.setSalePrice(this.getSalePrice(purchaseOrder, line.getProduct(), purchaseOrder.getInAti() != false ? inTaxPrice : price));
        return line;
    }

    @Override
    public PurchaseOrderLine reset(PurchaseOrderLine line) {
        if (!line.getEnableFreezeFields().booleanValue()) {
            line.setQty(BigDecimal.ZERO);
            line.setPrice(null);
            line.setProductName(null);
        }
        line.setTaxLine(null);
        line.setUnit(null);
        line.setDiscountAmount(null);
        line.setDiscountTypeSelect(0);
        line.setInTaxPrice(null);
        line.setSaleMinPrice(null);
        line.setSalePrice(null);
        line.setExTaxTotal(null);
        line.setInTaxTotal(null);
        line.setCompanyInTaxTotal(null);
        line.setCompanyExTaxTotal(null);
        line.setProductCode(null);
        if (this.appPurchaseService.getAppPurchase().getIsEnabledProductDescriptionCopy().booleanValue()) {
            line.setDescription(null);
        }
        return line;
    }

    @Override
    public BigDecimal getMinSalePrice(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        try {
            Product product = purchaseOrderLine.getProduct();
            if (product == null || !((Boolean)this.productCompanyService.get(product, "sellable", purchaseOrder.getCompany())).booleanValue()) {
                return BigDecimal.ZERO;
            }
            TaxLine saleTaxLine = this.accountManagementService.getTaxLine(purchaseOrder.getOrderDate(), purchaseOrderLine.getProduct(), purchaseOrder.getCompany(), purchaseOrder.getSupplierPartner().getFiscalPosition(), false);
            BigDecimal price = purchaseOrder.getInAti() != (Boolean)this.productCompanyService.get(product, "inAti", purchaseOrder.getCompany()) ? this.convertUnitPrice((Boolean)this.productCompanyService.get(product, "inAti", purchaseOrder.getCompany()), saleTaxLine, (BigDecimal)this.productCompanyService.get(product, "salePrice", purchaseOrder.getCompany())) : (BigDecimal)this.productCompanyService.get(product, "salePrice", purchaseOrder.getCompany());
            return this.currencyService.getAmountCurrencyConvertedAtDate((Currency)this.productCompanyService.get(product, "saleCurrency", purchaseOrder.getCompany()), purchaseOrder.getCurrency(), price, purchaseOrder.getOrderDate()).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    @Override
    public BigDecimal getSalePrice(PurchaseOrder purchaseOrder, Product product, BigDecimal price) throws AxelorException {
        if (product == null || !((Boolean)this.productCompanyService.get(product, "sellable", purchaseOrder.getCompany())).booleanValue()) {
            return BigDecimal.ZERO;
        }
        price = price.multiply((BigDecimal)this.productCompanyService.get(product, "managPriceCoef", purchaseOrder.getCompany()));
        return this.currencyService.getAmountCurrencyConvertedAtDate((Currency)this.productCompanyService.get(product, "saleCurrency", purchaseOrder.getCompany()), purchaseOrder.getCurrency(), price, purchaseOrder.getOrderDate()).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
    }

    @Override
    public TaxLine getTaxLine(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        return this.accountManagementService.getTaxLine(purchaseOrder.getOrderDate(), purchaseOrderLine.getProduct(), purchaseOrder.getCompany(), purchaseOrder.getSupplierPartner().getFiscalPosition(), true);
    }

    @Override
    public Optional<TaxLine> getOptionalTaxLine(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) {
        try {
            return Optional.of(this.getTaxLine(purchaseOrder, purchaseOrderLine));
        }
        catch (AxelorException e) {
            return Optional.empty();
        }
    }

    @Override
    public BigDecimal computePurchaseOrderLine(PurchaseOrderLine purchaseOrderLine) {
        return purchaseOrderLine.getExTaxTotal();
    }

    @Override
    public BigDecimal getCompanyExTaxTotal(BigDecimal exTaxTotal, PurchaseOrder purchaseOrder) throws AxelorException {
        return this.currencyService.getAmountCurrencyConvertedAtDate(purchaseOrder.getCurrency(), purchaseOrder.getCompany().getCurrency(), exTaxTotal, purchaseOrder.getOrderDate()).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public PriceListLine getPriceListLine(PurchaseOrderLine purchaseOrderLine, PriceList priceList, BigDecimal price) {
        return this.priceListService.getPriceListLine(purchaseOrderLine.getProduct(), purchaseOrderLine.getQty(), priceList, price);
    }

    @Override
    public BigDecimal computeDiscount(PurchaseOrderLine purchaseOrderLine, Boolean inAti) {
        BigDecimal price = inAti != false ? purchaseOrderLine.getInTaxPrice() : purchaseOrderLine.getPrice();
        return this.priceListService.computeDiscount(price, purchaseOrderLine.getDiscountTypeSelect().intValue(), purchaseOrderLine.getDiscountAmount());
    }

    @Override
    public PurchaseOrderLine createPurchaseOrderLine(PurchaseOrder purchaseOrder, Product product, String productName, String description, BigDecimal qty, Unit unit) throws AxelorException {
        BigDecimal companyInTaxTotal;
        BigDecimal companyExTaxTotal;
        BigDecimal inTaxTotal;
        BigDecimal exTaxTotal;
        PurchaseOrderLine purchaseOrderLine = new PurchaseOrderLine();
        purchaseOrderLine.setPurchaseOrder(purchaseOrder);
        purchaseOrderLine.setEstimatedDelivDate(purchaseOrder.getDeliveryDate());
        purchaseOrderLine.setDescription(description);
        purchaseOrderLine.setIsOrdered(false);
        purchaseOrderLine.setQty(qty);
        purchaseOrderLine.setSequence(this.sequence);
        ++this.sequence;
        purchaseOrderLine.setUnit(unit);
        purchaseOrderLine.setProductName(productName);
        if (product == null) {
            return purchaseOrderLine;
        }
        purchaseOrderLine.setProduct(product);
        if (productName == null) {
            purchaseOrderLine.setProductName(product.getName());
        }
        TaxLine taxLine = this.getTaxLine(purchaseOrder, purchaseOrderLine);
        purchaseOrderLine.setTaxLine(taxLine);
        BigDecimal price = this.getExTaxUnitPrice(purchaseOrder, purchaseOrderLine, taxLine);
        BigDecimal inTaxPrice = this.getInTaxUnitPrice(purchaseOrder, purchaseOrderLine, taxLine);
        Map<String, Object> discounts = this.getDiscountsFromPriceLists(purchaseOrder, purchaseOrderLine, product.getInAti() != false ? inTaxPrice : price);
        if (discounts != null) {
            if (discounts.get("price") != null) {
                BigDecimal discountPrice = (BigDecimal)discounts.get("price");
                if (purchaseOrderLine.getProduct().getInAti().booleanValue()) {
                    inTaxPrice = discountPrice;
                    price = this.convertUnitPrice(true, purchaseOrderLine.getTaxLine(), discountPrice);
                } else {
                    price = discountPrice;
                    inTaxPrice = this.convertUnitPrice(false, purchaseOrderLine.getTaxLine(), discountPrice);
                }
            }
            if (purchaseOrderLine.getProduct().getInAti() != purchaseOrder.getInAti()) {
                purchaseOrderLine.setDiscountAmount(this.convertUnitPrice(purchaseOrderLine.getProduct().getInAti(), purchaseOrderLine.getTaxLine(), (BigDecimal)discounts.get("discountAmount")));
            } else {
                purchaseOrderLine.setDiscountAmount((BigDecimal)discounts.get("discountAmount"));
            }
            purchaseOrderLine.setDiscountTypeSelect((Integer)discounts.get("discountTypeSelect"));
        }
        purchaseOrderLine.setPrice(price);
        purchaseOrderLine.setInTaxPrice(inTaxPrice);
        BigDecimal priceDiscounted = this.computeDiscount(purchaseOrderLine, purchaseOrder.getInAti());
        purchaseOrderLine.setPriceDiscounted(priceDiscounted);
        if (!purchaseOrder.getInAti().booleanValue()) {
            exTaxTotal = PurchaseOrderLineServiceImpl.computeAmount(purchaseOrderLine.getQty(), priceDiscounted);
            inTaxTotal = exTaxTotal.add(exTaxTotal.multiply(purchaseOrderLine.getTaxLine().getValue()));
            companyExTaxTotal = this.getCompanyExTaxTotal(exTaxTotal, purchaseOrder);
            companyInTaxTotal = companyExTaxTotal.add(companyExTaxTotal.multiply(purchaseOrderLine.getTaxLine().getValue()));
        } else {
            inTaxTotal = PurchaseOrderLineServiceImpl.computeAmount(purchaseOrderLine.getQty(), priceDiscounted);
            exTaxTotal = inTaxTotal.divide(purchaseOrderLine.getTaxLine().getValue().add(BigDecimal.ONE), 2, 4);
            companyInTaxTotal = this.getCompanyExTaxTotal(inTaxTotal, purchaseOrder);
            companyExTaxTotal = companyInTaxTotal.divide(purchaseOrderLine.getTaxLine().getValue().add(BigDecimal.ONE), 2, 4);
        }
        purchaseOrderLine.setExTaxTotal(exTaxTotal);
        purchaseOrderLine.setCompanyExTaxTotal(companyExTaxTotal);
        purchaseOrderLine.setCompanyInTaxTotal(companyInTaxTotal);
        purchaseOrderLine.setInTaxTotal(inTaxTotal);
        return purchaseOrderLine;
    }

    @Override
    public BigDecimal getQty(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        SupplierCatalog supplierCatalog = this.getSupplierCatalog(purchaseOrder, purchaseOrderLine);
        if (supplierCatalog != null) {
            return supplierCatalog.getMinQty();
        }
        return BigDecimal.ONE;
    }

    @Override
    public SupplierCatalog getSupplierCatalog(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        Product product = purchaseOrderLine.getProduct();
        SupplierCatalog supplierCatalog = this.supplierCatalogService.getSupplierCatalog(product, purchaseOrder.getSupplierPartner(), purchaseOrder.getCompany());
        return supplierCatalog;
    }

    @Override
    public BigDecimal convertUnitPrice(Boolean priceIsAti, TaxLine taxLine, BigDecimal price) {
        if (taxLine == null) {
            return price;
        }
        price = priceIsAti != false ? price.divide(taxLine.getValue().add(BigDecimal.ONE), 2, 4) : price.add(price.multiply(taxLine.getValue()));
        return price;
    }

    @Override
    public Map<String, Object> updateInfoFromCatalog(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        return this.supplierCatalogService.updateInfoFromCatalog(purchaseOrderLine.getProduct(), purchaseOrderLine.getQty(), purchaseOrder.getSupplierPartner(), purchaseOrder.getCurrency(), purchaseOrder.getOrderDate(), purchaseOrder.getCompany());
    }

    @Override
    public Map<String, Object> getDiscountsFromPriceLists(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine, BigDecimal price) {
        Map discounts = null;
        PriceList priceList = purchaseOrder.getPriceList();
        if (priceList != null) {
            PriceListLine priceListLine = this.getPriceListLine(purchaseOrderLine, priceList, price);
            discounts = this.priceListService.getReplacedPriceAndDiscounts(priceList, priceListLine, price);
        }
        return discounts;
    }

    @Override
    public int getDiscountTypeSelect(PurchaseOrderLine purchaseOrderLine, PurchaseOrder purchaseOrder, BigDecimal price) {
        PriceList priceList = purchaseOrder.getPriceList();
        if (priceList != null) {
            PriceListLine priceListLine = this.getPriceListLine(purchaseOrderLine, priceList, price);
            return priceListLine.getTypeSelect();
        }
        return 0;
    }

    @Override
    public Unit getPurchaseUnit(PurchaseOrderLine purchaseOrderLine) {
        Unit unit = purchaseOrderLine.getProduct().getPurchasesUnit();
        if (unit == null) {
            unit = purchaseOrderLine.getProduct().getUnit();
        }
        return unit;
    }

    @Override
    public BigDecimal getMinQty(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        SupplierCatalog supplierCatalog = this.getSupplierCatalog(purchaseOrder, purchaseOrderLine);
        return supplierCatalog != null ? supplierCatalog.getMinQty() : BigDecimal.ONE;
    }

    @Override
    public void checkMinQty(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine, ActionRequest request, ActionResponse response) throws AxelorException {
        BigDecimal minQty = this.getMinQty(purchaseOrder, purchaseOrderLine);
        if (purchaseOrderLine.getQty().compareTo(minQty) < 0) {
            String msg = String.format(I18n.get((String)"The minimum order quantity of %s to the supplier is not respected."), minQty);
            if (request.getAction().endsWith("onchange")) {
                response.setFlash(msg);
            }
            String title = ContextTool.formatLabel((String)msg, (String)ContextTool.SPAN_CLASS_WARNING, (int)75);
            response.setAttr("minQtyNotRespectedLabel", "title", (Object)title);
            response.setAttr("minQtyNotRespectedLabel", "hidden", (Object)false);
        } else {
            response.setAttr("minQtyNotRespectedLabel", "hidden", (Object)true);
        }
    }

    @Override
    public void checkMultipleQty(PurchaseOrderLine purchaseOrderLine, ActionResponse response) {
        Product product = purchaseOrderLine.getProduct();
        if (product == null) {
            return;
        }
        this.productMultipleQtyService.checkMultipleQty(purchaseOrderLine.getQty(), product.getPurchaseProductMultipleQtyList(), product.getAllowToForcePurchaseQty().booleanValue(), response);
    }
}

