/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Blocking;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.base.service.ShippingCoefService;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.PurchaseOrderLineTax;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.PurchaseOrderLineTaxService;
import com.axelor.apps.purchase.service.PurchaseOrderService;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    protected PurchaseOrderLineTaxService purchaseOrderLineVatService;
    @Inject
    protected SequenceService sequenceService;
    @Inject
    protected PartnerRepository partnerRepo;
    @Inject
    protected AppPurchaseService appPurchaseService;
    @Inject
    protected PurchaseOrderRepository purchaseOrderRepo;
    @Inject
    protected ProductCompanyService productCompanyService;

    @Override
    public PurchaseOrder _computePurchaseOrderLines(PurchaseOrder purchaseOrder) throws AxelorException {
        if (purchaseOrder.getPurchaseOrderLineList() != null) {
            PurchaseOrderLineService purchaseOrderLineService = (PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class);
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
                purchaseOrderLine.setExTaxTotal(purchaseOrderLineService.computePurchaseOrderLine(purchaseOrderLine));
                purchaseOrderLine.setCompanyExTaxTotal(purchaseOrderLineService.getCompanyExTaxTotal(purchaseOrderLine.getExTaxTotal(), purchaseOrder));
            }
        }
        return purchaseOrder;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public PurchaseOrder computePurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        this.initPurchaseOrderLineTax(purchaseOrder);
        this._computePurchaseOrderLines(purchaseOrder);
        this._populatePurchaseOrder(purchaseOrder);
        this._computePurchaseOrder(purchaseOrder);
        return purchaseOrder;
    }

    @Override
    public void _populatePurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        this.logger.debug("Peupler une facture => lignes de devis: {} ", new Object[]{purchaseOrder.getPurchaseOrderLineList().size()});
        purchaseOrder.getPurchaseOrderLineTaxList().addAll(this.purchaseOrderLineVatService.createsPurchaseOrderLineTax(purchaseOrder, purchaseOrder.getPurchaseOrderLineList()));
    }

    @Override
    public void _computePurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        purchaseOrder.setExTaxTotal(BigDecimal.ZERO);
        purchaseOrder.setCompanyExTaxTotal(BigDecimal.ZERO);
        purchaseOrder.setTaxTotal(BigDecimal.ZERO);
        purchaseOrder.setInTaxTotal(BigDecimal.ZERO);
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
            purchaseOrder.setExTaxTotal(purchaseOrder.getExTaxTotal().add(purchaseOrderLine.getExTaxTotal()));
            purchaseOrder.setCompanyExTaxTotal(purchaseOrder.getCompanyExTaxTotal().add(purchaseOrderLine.getCompanyExTaxTotal()));
        }
        for (PurchaseOrderLineTax purchaseOrderLineVat : purchaseOrder.getPurchaseOrderLineTaxList()) {
            purchaseOrder.setTaxTotal(purchaseOrder.getTaxTotal().add(purchaseOrderLineVat.getTaxTotal()));
        }
        purchaseOrder.setInTaxTotal(purchaseOrder.getExTaxTotal().add(purchaseOrder.getTaxTotal()));
        this.logger.debug("Montant de la facture: HTT = {},  HT = {}, TVA = {}, TTC = {}", new Object[]{purchaseOrder.getExTaxTotal(), purchaseOrder.getTaxTotal(), purchaseOrder.getInTaxTotal()});
    }

    @Override
    public void initPurchaseOrderLineTax(PurchaseOrder purchaseOrder) {
        if (purchaseOrder.getPurchaseOrderLineTaxList() == null) {
            purchaseOrder.setPurchaseOrderLineTaxList(new ArrayList<PurchaseOrderLineTax>());
        } else {
            purchaseOrder.getPurchaseOrderLineTaxList().clear();
        }
    }

    @Override
    public PurchaseOrder createPurchaseOrder(User buyerUser, Company company, Partner contactPartner, Currency currency, LocalDate deliveryDate, String internalReference, String externalReference, LocalDate orderDate, PriceList priceList, Partner supplierPartner, TradingName tradingName) throws AxelorException {
        this.logger.debug("Cr\u00e9ation d'une commande fournisseur : Soci\u00e9t\u00e9 = {},  Reference externe = {}, Fournisseur = {}", new Object[]{company.getName(), externalReference, supplierPartner.getFullName()});
        PurchaseOrder purchaseOrder = new PurchaseOrder();
        purchaseOrder.setBuyerUser(buyerUser);
        purchaseOrder.setCompany(company);
        purchaseOrder.setContactPartner(contactPartner);
        purchaseOrder.setCurrency(currency);
        purchaseOrder.setDeliveryDate(deliveryDate);
        purchaseOrder.setInternalReference(internalReference);
        purchaseOrder.setExternalReference(externalReference);
        purchaseOrder.setOrderDate(orderDate);
        purchaseOrder.setPriceList(priceList);
        purchaseOrder.setTradingName(tradingName);
        purchaseOrder.setPurchaseOrderLineList(new ArrayList<PurchaseOrderLine>());
        purchaseOrder.setPrintingSettings(((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(null, company));
        purchaseOrder.setPurchaseOrderSeq(this.getSequence(company));
        purchaseOrder.setStatusSelect(1);
        purchaseOrder.setSupplierPartner(supplierPartner);
        return purchaseOrder;
    }

    @Override
    public String getSequence(Company company) throws AxelorException {
        String seq = this.sequenceService.getSequenceNumber("purchaseOrder", company);
        if (seq == null) {
            throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"The company %s doesn't have any configured sequence for the purchase orders"), new Object[]{company.getName()});
        }
        return seq;
    }

    @Override
    @Transactional
    public Partner validateSupplier(PurchaseOrder purchaseOrder) {
        Partner supplierPartner = (Partner)((Object)this.partnerRepo.find(purchaseOrder.getSupplierPartner().getId()));
        supplierPartner.setIsSupplier(true);
        return (Partner)((Object)this.partnerRepo.save((Model)((Object)supplierPartner)));
    }

    @Override
    public void savePurchaseOrderPDFAsAttachment(PurchaseOrder purchaseOrder) throws AxelorException {
        if (purchaseOrder.getPrintingSettings() == null) {
            throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on purchase order %s"), purchaseOrder.getPurchaseOrderSeq()));
        }
        String language = ReportSettings.getPrintingLocale((Partner)purchaseOrder.getSupplierPartner());
        String title = I18n.get((String)"Purchase order") + purchaseOrder.getPurchaseOrderSeq() + (purchaseOrder.getVersionNumber() > 1 ? "-V" + purchaseOrder.getVersionNumber() : "");
        ReportFactory.createReport((String)"PurchaseOrder.rptdesign", (String)(title + "-${date}")).addParam("PurchaseOrderId", (Object)purchaseOrder.getId()).addParam("Locale", (Object)language).addParam("Timezone", purchaseOrder.getCompany() != null ? purchaseOrder.getCompany().getTimezone() : null).addParam("HeaderHeight", (Object)purchaseOrder.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)purchaseOrder.getPrintingSettings().getPdfFooterHeight()).toAttach((Model)((Object)purchaseOrder)).generate().getFileLink();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void requestPurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        purchaseOrder.setStatusSelect(2);
        Partner partner = purchaseOrder.getSupplierPartner();
        Company company = purchaseOrder.getCompany();
        Blocking blocking = ((BlockingService)Beans.get(BlockingService.class)).getBlocking(partner, company, 6);
        if (blocking != null) {
            String reason = blocking.getBlockingReason() != null ? blocking.getBlockingReason().getName() : "";
            throw new AxelorException(5, I18n.get((String)"This supplier is blocked:") + " " + reason, new Object[]{partner});
        }
        if (purchaseOrder.getVersionNumber() == 1 && this.sequenceService.isEmptyOrDraftSequenceNumber(purchaseOrder.getPurchaseOrderSeq())) {
            purchaseOrder.setPurchaseOrderSeq(this.getSequence(purchaseOrder.getCompany()));
        }
        this.purchaseOrderRepo.save((Model)((Object)purchaseOrder));
        if (this.appPurchaseService.getAppPurchase().getManagePurchaseOrderVersion().booleanValue()) {
            this.savePurchaseOrderPDFAsAttachment(purchaseOrder);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public PurchaseOrder mergePurchaseOrders(List<PurchaseOrder> purchaseOrderList, Currency currency, Partner supplierPartner, Company company, Partner contactPartner, PriceList priceList, TradingName tradingName) throws AxelorException {
        String numSeq = "";
        String externalRef = "";
        for (PurchaseOrder purchaseOrderLocal : purchaseOrderList) {
            if (!numSeq.isEmpty()) {
                numSeq = numSeq + "-";
            }
            numSeq = numSeq + purchaseOrderLocal.getPurchaseOrderSeq();
            if (!externalRef.isEmpty()) {
                externalRef = externalRef + "|";
            }
            if (purchaseOrderLocal.getExternalReference() == null) continue;
            externalRef = externalRef + purchaseOrderLocal.getExternalReference();
        }
        PurchaseOrder purchaseOrderMerged = this.createPurchaseOrder(AuthUtils.getUser(), company, contactPartner, currency, null, numSeq, externalRef, this.appPurchaseService.getTodayDate(company), priceList, supplierPartner, tradingName);
        this.attachToNewPurchaseOrder(purchaseOrderList, purchaseOrderMerged);
        this.computePurchaseOrder(purchaseOrderMerged);
        this.purchaseOrderRepo.save((Model)((Object)purchaseOrderMerged));
        this.removeOldPurchaseOrders(purchaseOrderList);
        return purchaseOrderMerged;
    }

    public void attachToNewPurchaseOrder(List<PurchaseOrder> purchaseOrderList, PurchaseOrder purchaseOrderMerged) {
        for (PurchaseOrder purchaseOrder : purchaseOrderList) {
            int countLine = 1;
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
                purchaseOrderLine.setSequence(countLine * 10);
                purchaseOrderMerged.addPurchaseOrderLineListItem(purchaseOrderLine);
                ++countLine;
            }
        }
    }

    public void removeOldPurchaseOrders(List<PurchaseOrder> purchaseOrderList) {
        for (PurchaseOrder purchaseOrder : purchaseOrderList) {
            this.purchaseOrderRepo.remove((Model)((Object)purchaseOrder));
        }
    }

    @Override
    public void setDraftSequence(PurchaseOrder purchaseOrder) throws AxelorException {
        if (purchaseOrder.getId() != null && Strings.isNullOrEmpty((String)purchaseOrder.getPurchaseOrderSeq())) {
            purchaseOrder.setPurchaseOrderSeq(this.sequenceService.getDraftSequenceNumber((Model)((Object)purchaseOrder)));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateCostPrice(PurchaseOrder purchaseOrder) throws AxelorException {
        if (purchaseOrder.getPurchaseOrderLineList() != null) {
            CurrencyService currencyService = (CurrencyService)Beans.get(CurrencyService.class);
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
                Product product = purchaseOrderLine.getProduct();
                if (product == null) continue;
                BigDecimal lastPurchasePrice = (Boolean)this.productCompanyService.get(product, "inAti", purchaseOrder.getCompany()) != false ? purchaseOrderLine.getInTaxPrice() : purchaseOrderLine.getPrice();
                lastPurchasePrice = currencyService.getAmountCurrencyConvertedAtDate(purchaseOrder.getCurrency(), purchaseOrder.getCompany().getCurrency(), lastPurchasePrice, currencyService.getDateToConvert(null));
                this.productCompanyService.set(product, "lastPurchasePrice", (Object)lastPurchasePrice, purchaseOrder.getCompany());
                if (((Boolean)this.productCompanyService.get(product, "defShipCoefByPartner", purchaseOrder.getCompany())).booleanValue()) {
                    Unit productPurchaseUnit = (Unit)this.productCompanyService.get(product, "purchasesUnit", purchaseOrder.getCompany());
                    productPurchaseUnit = productPurchaseUnit != null ? productPurchaseUnit : (Unit)this.productCompanyService.get(product, "unit", purchaseOrder.getCompany());
                    BigDecimal convertedQty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convert(purchaseOrderLine.getUnit(), productPurchaseUnit, purchaseOrderLine.getQty(), purchaseOrderLine.getQty().scale(), product);
                    BigDecimal shippingCoef = ((ShippingCoefService)Beans.get(ShippingCoefService.class)).getShippingCoefDefByPartner(product, purchaseOrder.getSupplierPartner(), purchaseOrder.getCompany(), convertedQty);
                    if (shippingCoef.compareTo(BigDecimal.ZERO) != 0) {
                        this.productCompanyService.set(product, "shippingCoef", (Object)shippingCoef, purchaseOrder.getCompany());
                    }
                }
                if ((Integer)this.productCompanyService.get(product, "costTypeSelect", purchaseOrder.getCompany()) != 2) continue;
                this.productCompanyService.set(product, "costPrice", (Object)lastPurchasePrice, purchaseOrder.getCompany());
                if (!((Boolean)this.productCompanyService.get(product, "autoUpdateSalePrice", purchaseOrder.getCompany())).booleanValue()) continue;
                ((ProductService)Beans.get(ProductService.class)).updateSalePrice(product, purchaseOrder.getCompany());
            }
            this.purchaseOrderRepo.save((Model)((Object)purchaseOrder));
        }
    }

    @Override
    @Transactional
    public void draftPurchaseOrder(PurchaseOrder purchaseOrder) {
        purchaseOrder.setStatusSelect(1);
        this.purchaseOrderRepo.save((Model)((Object)purchaseOrder));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validatePurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        this.computePurchaseOrder(purchaseOrder);
        purchaseOrder.setStatusSelect(3);
        purchaseOrder.setValidationDate(this.appPurchaseService.getTodayDate(purchaseOrder.getCompany()));
        purchaseOrder.setValidatedByUser(AuthUtils.getUser());
        purchaseOrder.setSupplierPartner(this.validateSupplier(purchaseOrder));
        this.updateCostPrice(purchaseOrder);
    }

    @Override
    @Transactional
    public void finishPurchaseOrder(PurchaseOrder purchaseOrder) {
        purchaseOrder.setStatusSelect(4);
        this.purchaseOrderRepo.save((Model)((Object)purchaseOrder));
    }

    @Override
    @Transactional
    public void cancelPurchaseOrder(PurchaseOrder purchaseOrder) {
        purchaseOrder.setStatusSelect(5);
        this.purchaseOrderRepo.save((Model)((Object)purchaseOrder));
    }
}

