/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.ShippingCoefService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.PurchaseProductService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class PurchaseProductServiceImpl
implements PurchaseProductService {
    @Override
    public Map<String, Object> getDiscountsFromCatalog(SupplierCatalog supplierCatalog, BigDecimal price) {
        HashMap<String, Object> discounts = new HashMap<String, Object>();
        if (supplierCatalog.getPrice().compareTo(price) != 0) {
            discounts.put("discountAmount", price.subtract(supplierCatalog.getPrice()));
            discounts.put("discountTypeSelect", 2);
        } else {
            discounts.put("discountTypeSelect", 0);
            discounts.put("discountAmount", BigDecimal.ZERO);
        }
        return discounts;
    }

    @Override
    public BigDecimal getLastShippingCoef(Product product) throws AxelorException {
        PurchaseOrderLine lastPurchaseOrderLine = (PurchaseOrderLine)((Object)((PurchaseOrderLineRepository)((Object)Beans.get(PurchaseOrderLineRepository.class))).all().filter("self.product.id = :productId AND (self.purchaseOrder.statusSelect = :validated OR self.purchaseOrder.statusSelect = :finished)").bind("productId", (Object)product.getId()).bind("validated", (Object)3).bind("finished", (Object)4).order("-purchaseOrder.validationDate").fetchOne());
        if (lastPurchaseOrderLine != null) {
            Partner partner = lastPurchaseOrderLine.getPurchaseOrder().getSupplierPartner();
            Company company = lastPurchaseOrderLine.getPurchaseOrder().getCompany();
            Unit productUnit = ((PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class)).getPurchaseUnit(lastPurchaseOrderLine);
            BigDecimal qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convert(lastPurchaseOrderLine.getUnit(), productUnit, lastPurchaseOrderLine.getQty(), lastPurchaseOrderLine.getQty().scale(), product);
            return ((ShippingCoefService)Beans.get(ShippingCoefService.class)).getShippingCoef(product, partner, company, qty);
        }
        return BigDecimal.ONE;
    }
}

