/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.apps.purchase.db.repo.SupplierCatalogRepository;
import com.axelor.apps.purchase.service.SupplierCatalogService;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SupplierCatalogServiceImpl
implements SupplierCatalogService {
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    protected AppPurchaseService appPurchaseService;
    @Inject
    protected CurrencyService currencyService;
    @Inject
    protected ProductCompanyService productCompanyService;

    @Override
    public Map<String, Object> updateInfoFromCatalog(Product product, BigDecimal qty, Partner partner, Currency currency, LocalDate date, Company company) throws AxelorException {
        HashMap<String, Object> info = null;
        List supplierCatalogList = null;
        if (this.appPurchaseService.getAppPurchase().getManageSupplierCatalog().booleanValue()) {
            supplierCatalogList = (List)this.productCompanyService.get(product, "supplierCatalogList", company);
        }
        if (supplierCatalogList != null && !supplierCatalogList.isEmpty()) {
            SupplierCatalog supplierCatalog = (SupplierCatalog)((Object)((SupplierCatalogRepository)((Object)Beans.get(SupplierCatalogRepository.class))).all().filter("self.product = ?1 AND self.minQty <= ?2 AND self.supplierPartner = ?3 ORDER BY self.minQty DESC", new Object[]{product, qty, partner}).fetchOne());
            if (supplierCatalog != null) {
                info = new HashMap<String, Object>();
                info.put("price", this.currencyService.getAmountCurrencyConvertedAtDate(supplierCatalog.getSupplierPartner().getCurrency(), currency, supplierCatalog.getPrice(), date).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP));
                info.put("productName", supplierCatalog.getProductSupplierName());
                info.put("productCode", supplierCatalog.getProductSupplierCode());
            } else if (this.getSupplierCatalog(product, partner, company) != null) {
                info = new HashMap();
                info.put("price", this.currencyService.getAmountCurrencyConvertedAtDate((Currency)this.productCompanyService.get(product, "purchaseCurrency", company), currency, (BigDecimal)this.productCompanyService.get(product, "purchasePrice", company), date).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP));
                info.put("productName", null);
                info.put("productCode", null);
            }
        }
        return info;
    }

    @Override
    public SupplierCatalog getSupplierCatalog(Product product, Partner supplierPartner, Company company) throws AxelorException {
        List supplierCatalogList = (List)this.productCompanyService.get(product, "supplierCatalogList", company);
        if (this.appPurchaseService.getAppPurchase().getManageSupplierCatalog().booleanValue() && product != null && supplierCatalogList != null) {
            SupplierCatalog resSupplierCatalog = null;
            for (SupplierCatalog supplierCatalog : supplierCatalogList) {
                if (!supplierCatalog.getSupplierPartner().equals((Object)supplierPartner)) continue;
                resSupplierCatalog = resSupplierCatalog == null || resSupplierCatalog.getMinQty().compareTo(supplierCatalog.getMinQty()) > 0 ? supplierCatalog : resSupplierCatalog;
            }
            return resSupplierCatalog;
        }
        return null;
    }
}

