/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service.print;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.apps.purchase.service.print.PurchaseOrderPrintService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PurchaseOrderPrintServiceImpl
implements PurchaseOrderPrintService {
    protected AppPurchaseService appPurchaseService;

    @Inject
    public PurchaseOrderPrintServiceImpl(AppPurchaseService appPurchaseService) {
        this.appPurchaseService = appPurchaseService;
    }

    @Override
    public String printPurchaseOrder(PurchaseOrder purchaseOrder, String formatPdf) throws AxelorException {
        String fileName = this.getFileName(purchaseOrder) + "." + formatPdf;
        return PdfTool.getFileLinkFromPdfFile((File)this.print(purchaseOrder, formatPdf), (String)fileName);
    }

    @Override
    public String printPurchaseOrders(List<Long> ids) throws IOException {
        final ArrayList printedPurchaseOrders = new ArrayList();
        ModelTool.apply(PurchaseOrder.class, ids, (ThrowConsumer)new ThrowConsumer<PurchaseOrder>(){

            public void accept(PurchaseOrder purchaseOrder) throws Exception {
                printedPurchaseOrders.add(PurchaseOrderPrintServiceImpl.this.print(purchaseOrder, "pdf"));
            }
        });
        Integer status = ((PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(ids.get(0)))).getStatusSelect();
        String fileName = this.getPurchaseOrderFilesName(status);
        return PdfTool.mergePdfToFileLink(printedPurchaseOrders, (String)fileName);
    }

    public File print(PurchaseOrder purchaseOrder, String formatPdf) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(purchaseOrder, formatPdf);
        return reportSettings.generate().getFile();
    }

    public ReportSettings prepareReportSettings(PurchaseOrder purchaseOrder, String formatPdf) throws AxelorException {
        if (purchaseOrder.getPrintingSettings() == null) {
            throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on purchase order %s"), purchaseOrder.getPurchaseOrderSeq()), new Object[]{purchaseOrder});
        }
        String locale = ReportSettings.getPrintingLocale((Partner)purchaseOrder.getSupplierPartner());
        String title = this.getFileName(purchaseOrder);
        ReportSettings reportSetting = ReportFactory.createReport((String)"PurchaseOrder.rptdesign", (String)(title + " - ${date}"));
        return reportSetting.addParam("PurchaseOrderId", (Object)purchaseOrder.getId()).addParam("Timezone", purchaseOrder.getCompany() != null ? purchaseOrder.getCompany().getTimezone() : null).addParam("Locale", (Object)locale).addParam("HeaderHeight", (Object)purchaseOrder.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)purchaseOrder.getPrintingSettings().getPdfFooterHeight()).addFormat(formatPdf);
    }

    protected String getPurchaseOrderFilesName(Integer status) {
        String prefixFileName = I18n.get((String)"Purchase orders");
        if (status == 1 || status == 2) {
            prefixFileName = I18n.get((String)"Purchase quotations");
        }
        return prefixFileName + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate((Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)).format(DateTimeFormatter.BASIC_ISO_DATE) + "." + "pdf";
    }

    @Override
    public String getFileName(PurchaseOrder purchaseOrder) {
        String prefixFileName = I18n.get((String)"Purchase order");
        if (purchaseOrder.getStatusSelect() == 1 || purchaseOrder.getStatusSelect() == 2) {
            prefixFileName = I18n.get((String)"Purchase quotation");
        }
        return prefixFileName + " " + purchaseOrder.getPurchaseOrderSeq() + (this.appPurchaseService.getAppPurchase().getManagePurchaseOrderVersion() != false && purchaseOrder.getVersionNumber() > 1 ? "-V" + purchaseOrder.getVersionNumber() : "");
    }
}

