/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.fleet.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.fleet.db.VehicleContract;
import com.axelor.apps.fleet.db.VehicleCost;
import com.axelor.apps.fleet.db.VehicleFuelLog;
import com.axelor.apps.fleet.db.VehicleModel;
import com.axelor.apps.fleet.db.VehicleRepair;
import com.axelor.apps.fleet.db.VehicleServiceLog;
import com.axelor.apps.fleet.db.VehicleTag;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="FLEET_VEHICLE", indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="driver_partner"), @Index(columnList="vehicle_model"), @Index(columnList="image")})
public class Vehicle
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FLEET_VEHICLE_SEQ")
    @SequenceGenerator(name="FLEET_VEHICLE_SEQ", sequenceName="FLEET_VEHICLE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Plate number")
    private String plateNo;
    @Widget(title="Name", readonly=true)
    private String name;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Chassis Number")
    private String chasisNo;
    @Widget(title="Driver")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner driverPartner;
    @Widget(title="Model")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private VehicleModel vehicleModel;
    @Widget(title="Fuel log")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="vehicle", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<VehicleFuelLog> vehicleFuelLogList;
    @Widget(title="Service log")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="vehicle", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<VehicleServiceLog> vehicleServiceLogList;
    @Widget(title="Vehicle contract")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="vehicle", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<VehicleContract> vehicleContractList;
    @Widget(title="Vehicle Cost")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="vehicle", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<VehicleCost> vehicleCostList;
    @Widget(title="Acquisition Date")
    private LocalDate acquisitionDate;
    @Widget(title="Color")
    private String color;
    @Widget(title="State")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String vehicleState;
    @Widget(title="Location")
    private String location;
    @Widget(title="Seats")
    private Integer seats = 0;
    @Widget(title="Doors")
    private Integer doors = 0;
    @Widget(title="Tags")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<VehicleTag> vehicleTagSet;
    @Widget(title="Odometer")
    private BigDecimal vehicleOdometer = BigDecimal.ZERO;
    @Widget(title="Transmission", selection="fleet.vehicle.transimission.select")
    private Integer transmissionSelect = 0;
    @Widget(title="Fuel type", selection="fleet.vehicle.fuel.type.select")
    private Integer fuelTypeSelect = 0;
    @Widget(title="Horse Power")
    private Integer horsePower = 0;
    @Widget(title="Horse Power Tax")
    private BigDecimal horsePowerTax = BigDecimal.ZERO;
    @Widget(title="Power(KW)")
    private Integer powerKw = 0;
    @Widget(title="CO2 Emissions")
    private BigDecimal co2emission = BigDecimal.ZERO;
    @Widget(title="Image")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile image;
    @Widget(title="Car value")
    private BigDecimal carValue = BigDecimal.ZERO;
    @Widget(title="Archived")
    private Boolean isArchived = Boolean.FALSE;
    @Widget(title="Rental car")
    private Boolean isRentalCar = Boolean.FALSE;
    @Widget(title="Fuel card number")
    private String fuelCardNumber;
    @Widget(title="Fuel card code")
    private String fuelCardCode;
    @Widget(title="Repairs")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<VehicleRepair> vehicleRepairList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Vehicle() {
    }

    public Vehicle(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPlateNo() {
        return this.plateNo;
    }

    public void setPlateNo(String plateNo) {
        this.plateNo = plateNo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getChasisNo() {
        return this.chasisNo;
    }

    public void setChasisNo(String chasisNo) {
        this.chasisNo = chasisNo;
    }

    public Partner getDriverPartner() {
        return this.driverPartner;
    }

    public void setDriverPartner(Partner driverPartner) {
        this.driverPartner = driverPartner;
    }

    public VehicleModel getVehicleModel() {
        return this.vehicleModel;
    }

    public void setVehicleModel(VehicleModel vehicleModel) {
        this.vehicleModel = vehicleModel;
    }

    public List<VehicleFuelLog> getVehicleFuelLogList() {
        return this.vehicleFuelLogList;
    }

    public void setVehicleFuelLogList(List<VehicleFuelLog> vehicleFuelLogList) {
        this.vehicleFuelLogList = vehicleFuelLogList;
    }

    public void addVehicleFuelLogListItem(VehicleFuelLog item) {
        if (this.getVehicleFuelLogList() == null) {
            this.setVehicleFuelLogList(new ArrayList<VehicleFuelLog>());
        }
        this.getVehicleFuelLogList().add(item);
        item.setVehicle(this);
    }

    public void removeVehicleFuelLogListItem(VehicleFuelLog item) {
        if (this.getVehicleFuelLogList() == null) {
            return;
        }
        this.getVehicleFuelLogList().remove((Object)item);
    }

    public void clearVehicleFuelLogList() {
        if (this.getVehicleFuelLogList() != null) {
            this.getVehicleFuelLogList().clear();
        }
    }

    public List<VehicleServiceLog> getVehicleServiceLogList() {
        return this.vehicleServiceLogList;
    }

    public void setVehicleServiceLogList(List<VehicleServiceLog> vehicleServiceLogList) {
        this.vehicleServiceLogList = vehicleServiceLogList;
    }

    public void addVehicleServiceLogListItem(VehicleServiceLog item) {
        if (this.getVehicleServiceLogList() == null) {
            this.setVehicleServiceLogList(new ArrayList<VehicleServiceLog>());
        }
        this.getVehicleServiceLogList().add(item);
        item.setVehicle(this);
    }

    public void removeVehicleServiceLogListItem(VehicleServiceLog item) {
        if (this.getVehicleServiceLogList() == null) {
            return;
        }
        this.getVehicleServiceLogList().remove((Object)item);
    }

    public void clearVehicleServiceLogList() {
        if (this.getVehicleServiceLogList() != null) {
            this.getVehicleServiceLogList().clear();
        }
    }

    public List<VehicleContract> getVehicleContractList() {
        return this.vehicleContractList;
    }

    public void setVehicleContractList(List<VehicleContract> vehicleContractList) {
        this.vehicleContractList = vehicleContractList;
    }

    public void addVehicleContractListItem(VehicleContract item) {
        if (this.getVehicleContractList() == null) {
            this.setVehicleContractList(new ArrayList<VehicleContract>());
        }
        this.getVehicleContractList().add(item);
        item.setVehicle(this);
    }

    public void removeVehicleContractListItem(VehicleContract item) {
        if (this.getVehicleContractList() == null) {
            return;
        }
        this.getVehicleContractList().remove((Object)item);
    }

    public void clearVehicleContractList() {
        if (this.getVehicleContractList() != null) {
            this.getVehicleContractList().clear();
        }
    }

    public List<VehicleCost> getVehicleCostList() {
        return this.vehicleCostList;
    }

    public void setVehicleCostList(List<VehicleCost> vehicleCostList) {
        this.vehicleCostList = vehicleCostList;
    }

    public void addVehicleCostListItem(VehicleCost item) {
        if (this.getVehicleCostList() == null) {
            this.setVehicleCostList(new ArrayList<VehicleCost>());
        }
        this.getVehicleCostList().add(item);
        item.setVehicle(this);
    }

    public void removeVehicleCostListItem(VehicleCost item) {
        if (this.getVehicleCostList() == null) {
            return;
        }
        this.getVehicleCostList().remove((Object)item);
    }

    public void clearVehicleCostList() {
        if (this.getVehicleCostList() != null) {
            this.getVehicleCostList().clear();
        }
    }

    public LocalDate getAcquisitionDate() {
        return this.acquisitionDate;
    }

    public void setAcquisitionDate(LocalDate acquisitionDate) {
        this.acquisitionDate = acquisitionDate;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getVehicleState() {
        return this.vehicleState;
    }

    public void setVehicleState(String vehicleState) {
        this.vehicleState = vehicleState;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Integer getSeats() {
        return this.seats == null ? 0 : this.seats;
    }

    public void setSeats(Integer seats) {
        this.seats = seats;
    }

    public Integer getDoors() {
        return this.doors == null ? 0 : this.doors;
    }

    public void setDoors(Integer doors) {
        this.doors = doors;
    }

    public Set<VehicleTag> getVehicleTagSet() {
        return this.vehicleTagSet;
    }

    public void setVehicleTagSet(Set<VehicleTag> vehicleTagSet) {
        this.vehicleTagSet = vehicleTagSet;
    }

    public void addVehicleTagSetItem(VehicleTag item) {
        if (this.getVehicleTagSet() == null) {
            this.setVehicleTagSet(new HashSet<VehicleTag>());
        }
        this.getVehicleTagSet().add(item);
    }

    public void removeVehicleTagSetItem(VehicleTag item) {
        if (this.getVehicleTagSet() == null) {
            return;
        }
        this.getVehicleTagSet().remove((Object)item);
    }

    public void clearVehicleTagSet() {
        if (this.getVehicleTagSet() != null) {
            this.getVehicleTagSet().clear();
        }
    }

    public BigDecimal getVehicleOdometer() {
        return this.vehicleOdometer == null ? BigDecimal.ZERO : this.vehicleOdometer;
    }

    public void setVehicleOdometer(BigDecimal vehicleOdometer) {
        this.vehicleOdometer = vehicleOdometer;
    }

    public Integer getTransmissionSelect() {
        return this.transmissionSelect == null ? 0 : this.transmissionSelect;
    }

    public void setTransmissionSelect(Integer transmissionSelect) {
        this.transmissionSelect = transmissionSelect;
    }

    public Integer getFuelTypeSelect() {
        return this.fuelTypeSelect == null ? 0 : this.fuelTypeSelect;
    }

    public void setFuelTypeSelect(Integer fuelTypeSelect) {
        this.fuelTypeSelect = fuelTypeSelect;
    }

    public Integer getHorsePower() {
        return this.horsePower == null ? 0 : this.horsePower;
    }

    public void setHorsePower(Integer horsePower) {
        this.horsePower = horsePower;
    }

    public BigDecimal getHorsePowerTax() {
        return this.horsePowerTax == null ? BigDecimal.ZERO : this.horsePowerTax;
    }

    public void setHorsePowerTax(BigDecimal horsePowerTax) {
        this.horsePowerTax = horsePowerTax;
    }

    public Integer getPowerKw() {
        return this.powerKw == null ? 0 : this.powerKw;
    }

    public void setPowerKw(Integer powerKw) {
        this.powerKw = powerKw;
    }

    public BigDecimal getCo2emission() {
        return this.co2emission == null ? BigDecimal.ZERO : this.co2emission;
    }

    public void setCo2emission(BigDecimal co2emission) {
        this.co2emission = co2emission;
    }

    public MetaFile getImage() {
        return this.image;
    }

    public void setImage(MetaFile image) {
        this.image = image;
    }

    public BigDecimal getCarValue() {
        return this.carValue == null ? BigDecimal.ZERO : this.carValue;
    }

    public void setCarValue(BigDecimal carValue) {
        this.carValue = carValue;
    }

    public Boolean getIsArchived() {
        return this.isArchived == null ? Boolean.FALSE : this.isArchived;
    }

    public void setIsArchived(Boolean isArchived) {
        this.isArchived = isArchived;
    }

    public Boolean getIsRentalCar() {
        return this.isRentalCar == null ? Boolean.FALSE : this.isRentalCar;
    }

    public void setIsRentalCar(Boolean isRentalCar) {
        this.isRentalCar = isRentalCar;
    }

    public String getFuelCardNumber() {
        return this.fuelCardNumber;
    }

    public void setFuelCardNumber(String fuelCardNumber) {
        this.fuelCardNumber = fuelCardNumber;
    }

    public String getFuelCardCode() {
        return this.fuelCardCode;
    }

    public void setFuelCardCode(String fuelCardCode) {
        this.fuelCardCode = fuelCardCode;
    }

    public List<VehicleRepair> getVehicleRepairList() {
        return this.vehicleRepairList;
    }

    public void setVehicleRepairList(List<VehicleRepair> vehicleRepairList) {
        this.vehicleRepairList = vehicleRepairList;
    }

    public void addVehicleRepairListItem(VehicleRepair item) {
        if (this.getVehicleRepairList() == null) {
            this.setVehicleRepairList(new ArrayList<VehicleRepair>());
        }
        this.getVehicleRepairList().add(item);
    }

    public void removeVehicleRepairListItem(VehicleRepair item) {
        if (this.getVehicleRepairList() == null) {
            return;
        }
        this.getVehicleRepairList().remove((Object)item);
    }

    public void clearVehicleRepairList() {
        if (this.getVehicleRepairList() != null) {
            this.getVehicleRepairList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vehicle)) {
            return false;
        }
        Vehicle other = (Vehicle)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("plateNo", (Object)this.getPlateNo()).add("name", (Object)this.getName()).add("chasisNo", (Object)this.getChasisNo()).add("acquisitionDate", (Object)this.getAcquisitionDate()).add("color", (Object)this.getColor()).add("location", (Object)this.getLocation()).add("seats", (Object)this.getSeats()).add("doors", (Object)this.getDoors()).add("vehicleOdometer", (Object)this.getVehicleOdometer()).add("transmissionSelect", (Object)this.getTransmissionSelect()).add("fuelTypeSelect", (Object)this.getFuelTypeSelect()).omitNullValues().toString();
    }
}

