/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.fleet.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.fleet.db.Vehicle;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="FLEET_VEHICLE_FUEL_LOG", indexes={@Index(columnList="vehicle"), @Index(columnList="purchase_partner"), @Index(columnList="vendor_partner")})
public class VehicleFuelLog
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FLEET_VEHICLE_FUEL_LOG_SEQ")
    @SequenceGenerator(name="FLEET_VEHICLE_FUEL_LOG_SEQ", sequenceName="FLEET_VEHICLE_FUEL_LOG_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Vehicle vehicle;
    @Widget(title="Liter")
    private BigDecimal liter = BigDecimal.ZERO;
    @Widget(title="Price per Liter")
    private BigDecimal pericePerLiter = BigDecimal.ZERO;
    @Widget(title="Total Price")
    private BigDecimal totalPrice = BigDecimal.ZERO;
    @Widget(title="Purchaser")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner purchasePartner;
    @Widget(title="Invoice Reference")
    private String invoiceRef;
    @Widget(title="Vendor")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner vendorPartner;
    @Widget(title="Notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String notes;
    @Widget(title="Date")
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
    }

    public BigDecimal getLiter() {
        return this.liter == null ? BigDecimal.ZERO : this.liter;
    }

    public void setLiter(BigDecimal liter) {
        this.liter = liter;
    }

    public BigDecimal getPericePerLiter() {
        return this.pericePerLiter == null ? BigDecimal.ZERO : this.pericePerLiter;
    }

    public void setPericePerLiter(BigDecimal pericePerLiter) {
        this.pericePerLiter = pericePerLiter;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice == null ? BigDecimal.ZERO : this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Partner getPurchasePartner() {
        return this.purchasePartner;
    }

    public void setPurchasePartner(Partner purchasePartner) {
        this.purchasePartner = purchasePartner;
    }

    public String getInvoiceRef() {
        return this.invoiceRef;
    }

    public void setInvoiceRef(String invoiceRef) {
        this.invoiceRef = invoiceRef;
    }

    public Partner getVendorPartner() {
        return this.vendorPartner;
    }

    public void setVendorPartner(Partner vendorPartner) {
        this.vendorPartner = vendorPartner;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VehicleFuelLog)) {
            return false;
        }
        VehicleFuelLog other = (VehicleFuelLog)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("liter", (Object)this.getLiter()).add("pericePerLiter", (Object)this.getPericePerLiter()).add("totalPrice", (Object)this.getTotalPrice()).add("invoiceRef", (Object)this.getInvoiceRef()).add("date", (Object)this.getDate()).omitNullValues().toString();
    }
}

