/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.fleet.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.fleet.db.VehicleModel;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="FLEET_VEHICLE_RENT", indexes={@Index(columnList="customer"), @Index(columnList="vehicle_model"), @Index(columnList="unit")})
public class VehicleRent
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FLEET_VEHICLE_RENT_SEQ")
    @SequenceGenerator(name="FLEET_VEHICLE_RENT_SEQ", sequenceName="FLEET_VEHICLE_RENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner customer;
    @Widget(title="Model")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private VehicleModel vehicleModel;
    @Widget(title="Plate number")
    private String plateNo;
    @Widget(title="Contract number")
    private String contractNo;
    @Widget(title="Rent start")
    private LocalDate rentStartDate;
    @Widget(title="Rent end")
    private LocalDate rentEndDate;
    @Widget(title="Mileage")
    private BigDecimal mileage = BigDecimal.ZERO;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Partner getCustomer() {
        return this.customer;
    }

    public void setCustomer(Partner customer) {
        this.customer = customer;
    }

    public VehicleModel getVehicleModel() {
        return this.vehicleModel;
    }

    public void setVehicleModel(VehicleModel vehicleModel) {
        this.vehicleModel = vehicleModel;
    }

    public String getPlateNo() {
        return this.plateNo;
    }

    public void setPlateNo(String plateNo) {
        this.plateNo = plateNo;
    }

    public String getContractNo() {
        return this.contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo;
    }

    public LocalDate getRentStartDate() {
        return this.rentStartDate;
    }

    public void setRentStartDate(LocalDate rentStartDate) {
        this.rentStartDate = rentStartDate;
    }

    public LocalDate getRentEndDate() {
        return this.rentEndDate;
    }

    public void setRentEndDate(LocalDate rentEndDate) {
        this.rentEndDate = rentEndDate;
    }

    public BigDecimal getMileage() {
        return this.mileage == null ? BigDecimal.ZERO : this.mileage;
    }

    public void setMileage(BigDecimal mileage) {
        this.mileage = mileage;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VehicleRent)) {
            return false;
        }
        VehicleRent other = (VehicleRent)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("plateNo", (Object)this.getPlateNo()).add("contractNo", (Object)this.getContractNo()).add("rentStartDate", (Object)this.getRentStartDate()).add("rentEndDate", (Object)this.getRentEndDate()).add("mileage", (Object)this.getMileage()).omitNullValues().toString();
    }
}

