/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.db;

import com.axelor.apps.base.db.CalendarManagement;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.ICalendar;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaPermission;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@Table(name="AUTH_USER", indexes={@Index(columnList="name"), @Index(columnList="group_id"), @Index(columnList="active_company"), @Index(columnList="partner"), @Index(columnList="active_team"), @Index(columnList="fullName"), @Index(columnList="i_calendar"), @Index(columnList="electronic_signature"), @Index(columnList="group_id")})
@Track(fields={@TrackField(name="name"), @TrackField(name="code"), @TrackField(name="email"), @TrackField(name="theme"), @TrackField(name="activateOn"), @TrackField(name="expiresOn"), @TrackField(name="activeCompany"), @TrackField(name="partner"), @TrackField(name="today"), @TrackField(name="activeTeam"), @TrackField(name="fullName"), @TrackField(name="iCalendar"), @TrackField(name="electronicSignature"), @TrackField(name="group"), @TrackField(name="language"), @TrackField(name="singleTab"), @TrackField(name="noHelp"), @TrackField(name="blocked"), @TrackField(name="sendEmailUponPasswordChange"), @TrackField(name="homeAction"), @TrackField(name="receiveEmails")})
public class User
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AUTH_USER_SEQ")
    @SequenceGenerator(name="AUTH_USER_SEQ", sequenceName="AUTH_USER_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Login")
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String code;
    @NotNull
    @Size(min=2)
    private String name;
    @Widget(password=true)
    @NotNull
    @Size(min=4)
    private String password;
    @Widget(title="Last password update date")
    private LocalDateTime passwordUpdatedOn;
    @Widget(help="Force the user to change their password at next login.")
    private Boolean forcePasswordChange = Boolean.FALSE;
    @Widget(image=true, title="Photo", help="Max size 4MB.")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] image;
    private String email;
    private String theme;
    @Widget(help="Activate the user from the specified date.")
    private LocalDateTime activateOn;
    @Widget(help="Disable the user from the specified date.")
    private LocalDateTime expiresOn;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Permission> permissions;
    @Widget(title="Permissions (fields)")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaPermission> metaPermissions;
    @Widget(title="Company")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Company> companySet;
    @Widget(title="Active company", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company activeCompany;
    @Widget(title="Partner")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Today date")
    private ZonedDateTime today;
    @Widget(title="Teams")
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="members", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Team> teamSet;
    @Widget(title="Active Team", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team activeTeam;
    @Widget(title="Partner name", search={"partner", "name"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Main calendar")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ICalendar iCalendar;
    @Widget(title="Followed users")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> followersCalUserSet;
    @Widget(title="Calendars permissions")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentUser", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CalendarManagement> calendarManagementList;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile electronicSignature;
    @Widget(title="Use signature for sales quotations")
    private Boolean useSignatureForSalesQuotations = Boolean.FALSE;
    @Widget(title="Use signature for purchase quotations")
    private Boolean useSignatureForPurchaseQuotations = Boolean.FALSE;
    @Widget(massUpdate=true)
    @JoinColumn(name="group_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Group group;
    @Widget(selection="select.language", massUpdate=true)
    private String language;
    @Widget(help="Whether to use tabbed ui.", massUpdate=true)
    private Boolean singleTab = Boolean.FALSE;
    @Widget(help="Whether to show help messages.", massUpdate=true)
    private Boolean noHelp = Boolean.FALSE;
    @Widget(help="Specify whether to block the user for an indefinite period.", massUpdate=true)
    private Boolean blocked = Boolean.TRUE;
    private Boolean sendEmailUponPasswordChange = Boolean.FALSE;
    @Widget(massUpdate=true)
    private String homeAction;
    @Widget(title="Receive notifications by email", help="Allow notifications to be sent by email")
    private Boolean receiveEmails = Boolean.TRUE;
    @Widget(title="Entities you wish to follow by email")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaModel> followedMetaModelSet;
    @Widget(title="Email accounts")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<EmailAccount> emailAccountList;
    @Transient
    private String transientPassword;
    @Widget(selection="base.user.form.step.select")
    private Integer stepStatusSelect = 0;
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;
    @Widget(title="Email signature")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String emailSignature;

    public User() {
    }

    public User(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public LocalDateTime getPasswordUpdatedOn() {
        return this.passwordUpdatedOn;
    }

    public void setPasswordUpdatedOn(LocalDateTime passwordUpdatedOn) {
        this.passwordUpdatedOn = passwordUpdatedOn;
    }

    public Boolean getForcePasswordChange() {
        return this.forcePasswordChange == null ? Boolean.FALSE : this.forcePasswordChange;
    }

    public void setForcePasswordChange(Boolean forcePasswordChange) {
        this.forcePasswordChange = forcePasswordChange;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public LocalDateTime getActivateOn() {
        return this.activateOn;
    }

    public void setActivateOn(LocalDateTime activateOn) {
        this.activateOn = activateOn;
    }

    public LocalDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public void setExpiresOn(LocalDateTime expiresOn) {
        this.expiresOn = expiresOn;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet<Role>());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove((Object)item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(Permission item) {
        if (this.getPermissions() == null) {
            this.setPermissions(new HashSet<Permission>());
        }
        this.getPermissions().add(item);
    }

    public void removePermission(Permission item) {
        if (this.getPermissions() == null) {
            return;
        }
        this.getPermissions().remove((Object)item);
    }

    public void clearPermissions() {
        if (this.getPermissions() != null) {
            this.getPermissions().clear();
        }
    }

    public Set<MetaPermission> getMetaPermissions() {
        return this.metaPermissions;
    }

    public void setMetaPermissions(Set<MetaPermission> metaPermissions) {
        this.metaPermissions = metaPermissions;
    }

    public void addMetaPermission(MetaPermission item) {
        if (this.getMetaPermissions() == null) {
            this.setMetaPermissions(new HashSet<MetaPermission>());
        }
        this.getMetaPermissions().add(item);
    }

    public void removeMetaPermission(MetaPermission item) {
        if (this.getMetaPermissions() == null) {
            return;
        }
        this.getMetaPermissions().remove(item);
    }

    public void clearMetaPermissions() {
        if (this.getMetaPermissions() != null) {
            this.getMetaPermissions().clear();
        }
    }

    public Set<Company> getCompanySet() {
        return this.companySet;
    }

    public void setCompanySet(Set<Company> companySet) {
        this.companySet = companySet;
    }

    public void addCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            this.setCompanySet(new HashSet<Company>());
        }
        this.getCompanySet().add(item);
    }

    public void removeCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            return;
        }
        this.getCompanySet().remove(item);
    }

    public void clearCompanySet() {
        if (this.getCompanySet() != null) {
            this.getCompanySet().clear();
        }
    }

    public Company getActiveCompany() {
        return this.activeCompany;
    }

    public void setActiveCompany(Company activeCompany) {
        this.activeCompany = activeCompany;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public ZonedDateTime getToday() {
        return this.today;
    }

    public void setToday(ZonedDateTime today) {
        this.today = today;
    }

    public Set<Team> getTeamSet() {
        return this.teamSet;
    }

    public void setTeamSet(Set<Team> teamSet) {
        this.teamSet = teamSet;
    }

    public void addTeamSetItem(Team item) {
        if (this.getTeamSet() == null) {
            this.setTeamSet(new HashSet<Team>());
        }
        this.getTeamSet().add(item);
    }

    public void removeTeamSetItem(Team item) {
        if (this.getTeamSet() == null) {
            return;
        }
        this.getTeamSet().remove((Object)item);
    }

    public void clearTeamSet() {
        if (this.getTeamSet() != null) {
            this.getTeamSet().clear();
        }
    }

    public Team getActiveTeam() {
        return this.activeTeam;
    }

    public void setActiveTeam(Team activeTeam) {
        this.activeTeam = activeTeam;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        if (this.partner != null) {
            if (this.partner.getFirstName() != null) {
                return this.partner.getFirstName() + " " + this.partner.getName();
            }
            return this.partner.getName();
        }
        return this.name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public ICalendar getiCalendar() {
        return this.iCalendar;
    }

    public void setiCalendar(ICalendar iCalendar) {
        this.iCalendar = iCalendar;
    }

    public Set<User> getFollowersCalUserSet() {
        return this.followersCalUserSet;
    }

    public void setFollowersCalUserSet(Set<User> followersCalUserSet) {
        this.followersCalUserSet = followersCalUserSet;
    }

    public void addFollowersCalUserSetItem(User item) {
        if (this.getFollowersCalUserSet() == null) {
            this.setFollowersCalUserSet(new HashSet<User>());
        }
        this.getFollowersCalUserSet().add(item);
    }

    public void removeFollowersCalUserSetItem(User item) {
        if (this.getFollowersCalUserSet() == null) {
            return;
        }
        this.getFollowersCalUserSet().remove((Object)item);
    }

    public void clearFollowersCalUserSet() {
        if (this.getFollowersCalUserSet() != null) {
            this.getFollowersCalUserSet().clear();
        }
    }

    public List<CalendarManagement> getCalendarManagementList() {
        return this.calendarManagementList;
    }

    public void setCalendarManagementList(List<CalendarManagement> calendarManagementList) {
        this.calendarManagementList = calendarManagementList;
    }

    public void addCalendarManagementListItem(CalendarManagement item) {
        if (this.getCalendarManagementList() == null) {
            this.setCalendarManagementList(new ArrayList<CalendarManagement>());
        }
        this.getCalendarManagementList().add(item);
        item.setParentUser(this);
    }

    public void removeCalendarManagementListItem(CalendarManagement item) {
        if (this.getCalendarManagementList() == null) {
            return;
        }
        this.getCalendarManagementList().remove(item);
    }

    public void clearCalendarManagementList() {
        if (this.getCalendarManagementList() != null) {
            this.getCalendarManagementList().clear();
        }
    }

    public MetaFile getElectronicSignature() {
        return this.electronicSignature;
    }

    public void setElectronicSignature(MetaFile electronicSignature) {
        this.electronicSignature = electronicSignature;
    }

    public Boolean getUseSignatureForSalesQuotations() {
        return this.useSignatureForSalesQuotations == null ? Boolean.FALSE : this.useSignatureForSalesQuotations;
    }

    public void setUseSignatureForSalesQuotations(Boolean useSignatureForSalesQuotations) {
        this.useSignatureForSalesQuotations = useSignatureForSalesQuotations;
    }

    public Boolean getUseSignatureForPurchaseQuotations() {
        return this.useSignatureForPurchaseQuotations == null ? Boolean.FALSE : this.useSignatureForPurchaseQuotations;
    }

    public void setUseSignatureForPurchaseQuotations(Boolean useSignatureForPurchaseQuotations) {
        this.useSignatureForPurchaseQuotations = useSignatureForPurchaseQuotations;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Boolean getSingleTab() {
        return this.singleTab == null ? Boolean.FALSE : this.singleTab;
    }

    public void setSingleTab(Boolean singleTab) {
        this.singleTab = singleTab;
    }

    public Boolean getNoHelp() {
        return this.noHelp == null ? Boolean.FALSE : this.noHelp;
    }

    public void setNoHelp(Boolean noHelp) {
        this.noHelp = noHelp;
    }

    public Boolean getBlocked() {
        return this.blocked == null ? Boolean.FALSE : this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public Boolean getSendEmailUponPasswordChange() {
        return this.sendEmailUponPasswordChange == null ? Boolean.FALSE : this.sendEmailUponPasswordChange;
    }

    public void setSendEmailUponPasswordChange(Boolean sendEmailUponPasswordChange) {
        this.sendEmailUponPasswordChange = sendEmailUponPasswordChange;
    }

    public String getHomeAction() {
        return this.homeAction;
    }

    public void setHomeAction(String homeAction) {
        this.homeAction = homeAction;
    }

    public Boolean getReceiveEmails() {
        return this.receiveEmails == null ? Boolean.FALSE : this.receiveEmails;
    }

    public void setReceiveEmails(Boolean receiveEmails) {
        this.receiveEmails = receiveEmails;
    }

    public Set<MetaModel> getFollowedMetaModelSet() {
        return this.followedMetaModelSet;
    }

    public void setFollowedMetaModelSet(Set<MetaModel> followedMetaModelSet) {
        this.followedMetaModelSet = followedMetaModelSet;
    }

    public void addFollowedMetaModelSetItem(MetaModel item) {
        if (this.getFollowedMetaModelSet() == null) {
            this.setFollowedMetaModelSet(new HashSet<MetaModel>());
        }
        this.getFollowedMetaModelSet().add(item);
    }

    public void removeFollowedMetaModelSetItem(MetaModel item) {
        if (this.getFollowedMetaModelSet() == null) {
            return;
        }
        this.getFollowedMetaModelSet().remove(item);
    }

    public void clearFollowedMetaModelSet() {
        if (this.getFollowedMetaModelSet() != null) {
            this.getFollowedMetaModelSet().clear();
        }
    }

    public List<EmailAccount> getEmailAccountList() {
        return this.emailAccountList;
    }

    public void setEmailAccountList(List<EmailAccount> emailAccountList) {
        this.emailAccountList = emailAccountList;
    }

    public void addEmailAccountListItem(EmailAccount item) {
        if (this.getEmailAccountList() == null) {
            this.setEmailAccountList(new ArrayList<EmailAccount>());
        }
        this.getEmailAccountList().add(item);
    }

    public void removeEmailAccountListItem(EmailAccount item) {
        if (this.getEmailAccountList() == null) {
            return;
        }
        this.getEmailAccountList().remove((Object)item);
    }

    public void clearEmailAccountList() {
        if (this.getEmailAccountList() != null) {
            this.getEmailAccountList().clear();
        }
    }

    public String getTransientPassword() {
        return this.transientPassword;
    }

    public void setTransientPassword(String transientPassword) {
        this.transientPassword = transientPassword;
    }

    public Integer getStepStatusSelect() {
        return this.stepStatusSelect == null ? 0 : this.stepStatusSelect;
    }

    public void setStepStatusSelect(Integer stepStatusSelect) {
        this.stepStatusSelect = stepStatusSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public String getEmailSignature() {
        return this.emailSignature;
    }

    public void setEmailSignature(String emailSignature) {
        this.emailSignature = emailSignature;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(2645995, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("passwordUpdatedOn", (Object)this.getPasswordUpdatedOn()).add("forcePasswordChange", (Object)this.getForcePasswordChange()).add("email", (Object)this.getEmail()).add("theme", (Object)this.getTheme()).add("activateOn", (Object)this.getActivateOn()).add("expiresOn", (Object)this.getExpiresOn()).add("today", (Object)this.getToday()).add("useSignatureForSalesQuotations", (Object)this.getUseSignatureForSalesQuotations()).add("useSignatureForPurchaseQuotations", (Object)this.getUseSignatureForPurchaseQuotations()).omitNullValues().toString();
    }
}

