/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.cash.management.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MANAGEMENT_FORECAST_RECAP_LINE_TYPE", indexes={@Index(columnList="name")})
@Track(fields={@TrackField(name="typeSelect"), @TrackField(name="elementSelect"), @TrackField(name="statusSelect"), @TrackField(name="operationTypeSelect")}, messages={@TrackMessage(message="Forecast recap line type updated.", condition="true", on={TrackEvent.UPDATE})})
public class ForecastRecapLineType
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MANAGEMENT_FORECAST_RECAP_LINE_TYPE_SEQ")
    @SequenceGenerator(name="MANAGEMENT_FORECAST_RECAP_LINE_TYPE_SEQ", sequenceName="MANAGEMENT_FORECAST_RECAP_LINE_TYPE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Element", selection="forecast.recap.line.type.element.select")
    private Integer elementSelect = 0;
    @Widget(title="Type", selection="iaccount.payment.mode.in.out.select")
    private Integer typeSelect = 0;
    @Widget(title="Operation type", selection="iinvoice.operation.type.select")
    private Integer operationTypeSelect = 0;
    @Widget(title="Pay Day", selection="forecast.recap.line.type.pay.day.select")
    private Integer payDaySelect = 0;
    @Widget(title="Statuses to take into account")
    private String statusSelect;
    @Widget(title="Estimated duration after order creation (in days)")
    @Min(value=0L)
    private Integer estimatedDuration = 0;
    @Widget(title="Name")
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ForecastRecapLineType() {
    }

    public ForecastRecapLineType(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getElementSelect() {
        return this.elementSelect == null ? 0 : this.elementSelect;
    }

    public void setElementSelect(Integer elementSelect) {
        this.elementSelect = elementSelect;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getOperationTypeSelect() {
        return this.operationTypeSelect == null ? 0 : this.operationTypeSelect;
    }

    public void setOperationTypeSelect(Integer operationTypeSelect) {
        this.operationTypeSelect = operationTypeSelect;
    }

    public Integer getPayDaySelect() {
        return this.payDaySelect == null ? 0 : this.payDaySelect;
    }

    public void setPayDaySelect(Integer payDaySelect) {
        this.payDaySelect = payDaySelect;
    }

    public String getStatusSelect() {
        return this.statusSelect;
    }

    public void setStatusSelect(String statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getEstimatedDuration() {
        return this.estimatedDuration == null ? 0 : this.estimatedDuration;
    }

    public void setEstimatedDuration(Integer estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForecastRecapLineType)) {
            return false;
        }
        ForecastRecapLineType other = (ForecastRecapLineType)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("elementSelect", (Object)this.getElementSelect()).add("typeSelect", (Object)this.getTypeSelect()).add("operationTypeSelect", (Object)this.getOperationTypeSelect()).add("payDaySelect", (Object)this.getPayDaySelect()).add("statusSelect", (Object)this.getStatusSelect()).add("estimatedDuration", (Object)this.getEstimatedDuration()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

