/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.cash.management.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.cash.management.db.Forecast;
import com.axelor.apps.cash.management.db.ForecastReason;
import com.axelor.apps.cash.management.db.ForecastRecap;
import com.axelor.apps.cash.management.db.ForecastRecapLine;
import com.axelor.apps.cash.management.db.ForecastRecapLineType;
import com.axelor.apps.cash.management.db.repo.ForecastRecapLineRepository;
import com.axelor.apps.cash.management.db.repo.ForecastRecapLineTypeRepository;
import com.axelor.apps.cash.management.db.repo.ForecastRecapRepository;
import com.axelor.apps.cash.management.db.repo.ForecastRepository;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.crm.db.repo.OpportunityRepository;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.db.repo.TimetableRepository;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ForecastRecapService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppBaseService appBaseService;
    protected ForecastRepository forecastRepo;
    protected ForecastRecapLineRepository forecastRecapLineRepo;
    protected CurrencyService currencyService;
    protected ForecastRecapLineTypeRepository forecastRecapLineTypeRepo;
    protected ForecastRecapRepository forecastRecapRepo;
    protected OpportunityRepository opportunityRepo;
    protected InvoiceRepository invoiceRepo;
    protected EmployeeRepository employeeRepo;
    protected SaleOrderRepository saleOrderRepo;
    protected PurchaseOrderRepository purchaseOrderRepo;
    protected TimetableRepository timetableRepo;
    protected ExpenseRepository expenseRepo;
    protected LocalDate today;

    @Inject
    public ForecastRecapService(AppBaseService appBaseService, ForecastRepository forecastRepo, ForecastRecapLineRepository forecastRecapLineRepo, CurrencyService currencyService, ForecastRecapLineTypeRepository forecastRecapLineTypeRepo, ForecastRecapRepository forecastRecapRepo, OpportunityRepository opportunityRepo, InvoiceRepository invoiceRepo, EmployeeRepository employeeRepo, SaleOrderRepository saleOrderRepo, PurchaseOrderRepository purchaseOrderRepo, TimetableRepository timetableRepo, ExpenseRepository expenseRepo) {
        this.appBaseService = appBaseService;
        this.forecastRepo = forecastRepo;
        this.forecastRecapLineRepo = forecastRecapLineRepo;
        this.forecastRecapLineTypeRepo = forecastRecapLineTypeRepo;
        this.forecastRecapRepo = forecastRecapRepo;
        this.currencyService = currencyService;
        this.opportunityRepo = opportunityRepo;
        this.invoiceRepo = invoiceRepo;
        this.employeeRepo = employeeRepo;
        this.saleOrderRepo = saleOrderRepo;
        this.purchaseOrderRepo = purchaseOrderRepo;
        this.timetableRepo = timetableRepo;
        this.expenseRepo = expenseRepo;
    }

    @Transactional
    public void reset(ForecastRecap forecastRecap) {
        forecastRecap.clearForecastRecapLineList();
        forecastRecap.setCurrentBalance(forecastRecap.getStartingBalance());
        this.today = this.appBaseService.getTodayDate(forecastRecap.getCompany());
        this.forecastRecapRepo.save((Model)((Object)forecastRecap));
    }

    @Transactional
    public void finish(ForecastRecap forecastRecap) {
        this.computeForecastRecapLineBalance(forecastRecap);
        forecastRecap.setEndingBalance(forecastRecap.getCurrentBalance());
        forecastRecap.setCalculationDate(this.today);
        forecastRecap.setIsComplete(true);
        this.forecastRecapRepo.save((Model)((Object)forecastRecap));
    }

    public void populate(ForecastRecap forecastRecap) throws AxelorException {
        this.reset((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
        if (forecastRecap.getOpportunitiesTypeSelect() != null && forecastRecap.getOpportunitiesTypeSelect() > 1) {
            this.populateWithOpportunities((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
        }
        this.populateWithInvoices((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
        this.populateWithSalaries((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
        this.populateWithSaleOrders((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
        this.populateWithPurchaseOrders((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
        if (forecastRecap.getIsReport().booleanValue()) {
            this.populateWithForecastsNoSave(forecastRecap);
        } else {
            this.populateWithForecasts((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
        }
        this.populateWithExpenses((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
        this.finish((ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
    }

    public void populateWithOpportunities(ForecastRecap forecastRecap) throws AxelorException {
        List opportunityList = new ArrayList();
        ForecastRecapLineType opportunityForecastRecapLineType = this.getForecastRecapLineType(6);
        List statusList = StringTool.getIntegerList((String)opportunityForecastRecapLineType.getStatusSelect());
        opportunityList = this.opportunityRepo.all().filter("self.company = ?1" + (forecastRecap.getBankDetails() != null ? " AND self.bankDetails = ?2" : "") + " AND self.expectedCloseDate BETWEEN ?3 AND ?4 AND self.saleOrderList IS EMPTY" + (statusList.isEmpty() ? "" : " AND self.salesStageSelect IN ?5"), new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails(), forecastRecap.getFromDate(), forecastRecap.getToDate(), statusList}).fetch();
        for (Opportunity opportunity : opportunityList) {
            BigDecimal amountCompanyCurr = BigDecimal.ZERO;
            opportunity = (Opportunity)((Object)this.opportunityRepo.find(opportunity.getId()));
            amountCompanyCurr = forecastRecap.getOpportunitiesTypeSelect() == 2 ? this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), opportunity.getAmount().multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.today).setScale(2, RoundingMode.HALF_UP) : (forecastRecap.getOpportunitiesTypeSelect() == 4 ? this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), opportunity.getBestCase().multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.today).setScale(2, RoundingMode.HALF_UP) : this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), opportunity.getWorstCase().multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.today).setScale(2, RoundingMode.HALF_UP));
            this.createForecastRecapLine(opportunity.getExpectedCloseDate(), opportunityForecastRecapLineType.getTypeSelect(), amountCompanyCurr, Opportunity.class.getName(), opportunity.getId(), opportunity.getName(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(opportunityForecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
            JPA.clear();
        }
    }

    public void getOpportunities(ForecastRecap forecastRecap, Map<LocalDate, BigDecimal> mapExpected, Map<LocalDate, BigDecimal> mapConfirmed) throws AxelorException {
        List opportunityList = new ArrayList();
        opportunityList = forecastRecap.getBankDetails() != null ? ((OpportunityRepository)((Object)Beans.get(OpportunityRepository.class))).all().filter("self.company = ?1 AND self.bankDetails = ?2 AND self.expectedCloseDate BETWEEN ?3 AND ?4 AND self.saleOrderList IS EMPTY", new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch() : ((OpportunityRepository)((Object)Beans.get(OpportunityRepository.class))).all().filter("self.company = ?1 AND self.expectedCloseDate BETWEEN ?2 AND ?3 AND self.saleOrderList IS EMPTY", new Object[]{forecastRecap.getCompany(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch();
        for (Opportunity opportunity : opportunityList) {
            BigDecimal amountCompanyCurr = BigDecimal.ZERO;
            amountCompanyCurr = forecastRecap.getOpportunitiesTypeSelect() == 2 ? this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), opportunity.getAmount().multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate(forecastRecap.getCompany())).setScale(2, RoundingMode.HALF_UP) : (forecastRecap.getOpportunitiesTypeSelect() == 4 ? this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), opportunity.getBestCase().multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate(forecastRecap.getCompany())).setScale(2, RoundingMode.HALF_UP) : this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), opportunity.getWorstCase().multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate(forecastRecap.getCompany())).setScale(2, RoundingMode.HALF_UP));
            if (opportunity.getSalesStageSelect() == 9) {
                if (mapExpected.containsKey(opportunity.getExpectedCloseDate())) {
                    mapExpected.put(opportunity.getExpectedCloseDate(), mapExpected.get(opportunity.getExpectedCloseDate()).add(amountCompanyCurr));
                    continue;
                }
                mapExpected.put(opportunity.getExpectedCloseDate(), amountCompanyCurr);
                continue;
            }
            if (mapConfirmed.containsKey(opportunity.getExpectedCloseDate())) {
                mapConfirmed.put(opportunity.getExpectedCloseDate(), mapConfirmed.get(opportunity.getExpectedCloseDate()).add(amountCompanyCurr));
                continue;
            }
            mapConfirmed.put(opportunity.getExpectedCloseDate(), amountCompanyCurr);
        }
    }

    public void populateWithInvoices(ForecastRecap forecastRecap) throws AxelorException {
        List invoiceList = new ArrayList();
        ForecastRecapLineType invoiceForecastRecapLineType = this.getForecastRecapLineType(1);
        List statusList = StringTool.getIntegerList((String)invoiceForecastRecapLineType.getStatusSelect());
        if (statusList.isEmpty()) {
            statusList.add(2);
        }
        invoiceList = this.invoiceRepo.all().filter("self.company = ?1" + (forecastRecap.getBankDetails() != null ? " AND self.companyBankDetails = ?2" : "") + " AND self.statusSelect IN (?3) AND self.operationTypeSelect = ?4 AND self.estimatedPaymentDate BETWEEN ?5 AND ?6 AND self.companyInTaxTotalRemaining != 0", new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails(), statusList, invoiceForecastRecapLineType.getOperationTypeSelect(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch();
        for (Invoice invoice : invoiceList) {
            BigDecimal amount = (invoice = (Invoice)((Object)this.invoiceRepo.find(invoice.getId()))).getMove() == null ? this.currencyService.getAmountCurrencyConvertedAtDate(invoice.getCurrency(), forecastRecap.getCompany().getCurrency(), invoice.getCompanyInTaxTotal(), this.today).setScale(2, RoundingMode.HALF_UP) : this.currencyService.getAmountCurrencyConvertedAtDate(invoice.getCurrency(), forecastRecap.getCompany().getCurrency(), invoice.getCompanyInTaxTotalRemaining(), this.today).setScale(2, RoundingMode.HALF_UP);
            this.createForecastRecapLine(invoice.getEstimatedPaymentDate(), invoiceForecastRecapLineType.getTypeSelect(), amount, ((Object)((Object)invoice)).getClass().getName(), invoice.getId(), invoice.getInvoiceId(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(invoiceForecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
            JPA.clear();
        }
    }

    public void getInvoices(ForecastRecap forecastRecap, Map<LocalDate, BigDecimal> mapExpected, Map<LocalDate, BigDecimal> mapConfirmed) {
        List invoiceList = new ArrayList();
        invoiceList = forecastRecap.getBankDetails() != null ? ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter("self.company = ?1 AND self.companyBankDetails = ?2 AND self.statusSelect = 3 AND self.estimatedPaymentDate BETWEEN ?3 AND ?4 AND self.companyInTaxTotalRemaining != 0", new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch() : ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter("self.company = ?1 AND self.statusSelect = 3 AND self.estimatedPaymentDate BETWEEN ?2 AND ?3 AND self.companyInTaxTotalRemaining != 0", new Object[]{forecastRecap.getCompany(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch();
        for (Invoice invoice : invoiceList) {
            BigDecimal amountPaidExTax = invoice.getAmountPaid().multiply(invoice.getCompanyExTaxTotal()).divide(invoice.getCompanyInTaxTotal(), 2, RoundingMode.HALF_UP);
            BigDecimal amount = invoice.getCompanyExTaxTotal().subtract(amountPaidExTax);
            if (invoice.getOperationTypeSelect() != 2 && invoice.getOperationTypeSelect() != 3) continue;
            if (mapConfirmed.containsKey(invoice.getEstimatedPaymentDate())) {
                mapConfirmed.put(invoice.getEstimatedPaymentDate(), mapConfirmed.get(invoice.getEstimatedPaymentDate()).add(amount));
                continue;
            }
            mapConfirmed.put(invoice.getEstimatedPaymentDate(), amount);
        }
    }

    public void populateWithSalaries(ForecastRecap forecastRecap) throws AxelorException {
        List employeeList = new ArrayList();
        ForecastRecapLineType salaryForecastRecapLineType = this.getForecastRecapLineType(7);
        employeeList = this.employeeRepo.all().filter("self.mainEmploymentContract.payCompany = ?1 AND self.mainEmploymentContract.monthlyGlobalCost != 0" + (forecastRecap.getBankDetails() != null ? " AND self.bankDetails = ?2" : ""), new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
        LocalDate itDate = LocalDate.parse(forecastRecap.getFromDate().toString(), DateTimeFormatter.ISO_DATE);
        while (!itDate.isAfter(forecastRecap.getToDate())) {
            LocalDate payDay = itDate.withDayOfMonth(salaryForecastRecapLineType.getPayDaySelect() == 0 ? itDate.lengthOfMonth() : salaryForecastRecapLineType.getPayDaySelect().intValue());
            if (itDate.isEqual(payDay)) {
                for (Employee employee : employeeList) {
                    this.employeeRepo.find(employee.getId());
                    this.createForecastRecapLine(itDate, salaryForecastRecapLineType.getTypeSelect(), employee.getMainEmploymentContract().getMonthlyGlobalCost(), ((Object)((Object)employee)).getClass().getName(), employee.getId(), employee.getName(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(salaryForecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
                    JPA.clear();
                }
                itDate = itDate.plusMonths(1L);
                continue;
            }
            itDate = payDay;
        }
    }

    public void populateWithSaleOrders(ForecastRecap forecastRecap) throws AxelorException {
        ForecastRecapLineType saleOrderForecastRecapLineType = this.getForecastRecapLineType(2);
        List statusList = StringTool.getIntegerList((String)saleOrderForecastRecapLineType.getStatusSelect());
        List saleOrderList = new ArrayList();
        if (statusList.isEmpty()) {
            statusList.add(3);
        }
        this.populateWithTimetables(forecastRecap, saleOrderForecastRecapLineType, statusList);
        saleOrderList = saleOrderForecastRecapLineType.getEstimatedDuration() != null ? this.saleOrderRepo.all().filter("(self.expectedRealisationDate BETWEEN ?1 AND ?2 OR (self.creationDate BETWEEN ?3 AND ?4 AND self.expectedRealisationDate IS NULL)) AND self.company = ?5 AND self.statusSelect IN (?6) AND self.inTaxTotal != 0" + (forecastRecap.getBankDetails() != null ? " AND self.companyBankDetails = ?7" : "") + " AND self.timetableList IS EMPTY", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getFromDate().minusDays(saleOrderForecastRecapLineType.getEstimatedDuration().intValue()), forecastRecap.getToDate().minusDays(saleOrderForecastRecapLineType.getEstimatedDuration().intValue()), forecastRecap.getCompany(), statusList, forecastRecap.getBankDetails()}).fetch() : this.saleOrderRepo.all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.statusSelect IN (?4) AND self.inTaxTotal != 0" + (forecastRecap.getBankDetails() != null ? " AND self.companyBankDetails = ?5" : "") + " AND self.timetableList IS EMPTY", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), statusList, forecastRecap.getBankDetails()}).fetch();
        for (SaleOrder saleOrder : saleOrderList) {
            saleOrder = (SaleOrder)((Object)this.saleOrderRepo.find(saleOrder.getId()));
            BigDecimal amount = this.currencyService.getAmountCurrencyConvertedAtDate(saleOrder.getCurrency(), forecastRecap.getCompany().getCurrency(), saleOrder.getInTaxTotal(), this.today).setScale(2, RoundingMode.HALF_UP);
            this.createForecastRecapLine(saleOrder.getExpectedRealisationDate() == null ? saleOrder.getCreationDate().plusDays(saleOrderForecastRecapLineType.getEstimatedDuration().intValue()) : saleOrder.getExpectedRealisationDate(), saleOrderForecastRecapLineType.getTypeSelect(), amount, ((Object)((Object)saleOrder)).getClass().getName(), saleOrder.getId(), saleOrder.getSaleOrderSeq(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(saleOrderForecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
            JPA.clear();
        }
    }

    public void populateWithPurchaseOrders(ForecastRecap forecastRecap) throws AxelorException {
        ForecastRecapLineType purchaseOrderForecastRecapLineType = this.getForecastRecapLineType(3);
        List statusList = StringTool.getIntegerList((String)purchaseOrderForecastRecapLineType.getStatusSelect());
        List purchaseOrderList = new ArrayList();
        if (statusList.isEmpty()) {
            statusList.add(3);
        }
        this.populateWithTimetables(forecastRecap, purchaseOrderForecastRecapLineType, statusList);
        purchaseOrderList = purchaseOrderForecastRecapLineType.getEstimatedDuration() != null ? this.purchaseOrderRepo.all().filter("(self.expectedRealisationDate BETWEEN ?1 AND ?2 OR (self.orderDate BETWEEN ?3 AND ?4 AND self.expectedRealisationDate IS NULL)) AND self.company = ?5 AND self.statusSelect IN (?6) AND self.inTaxTotal != 0" + (forecastRecap.getBankDetails() != null ? " AND self.companyBankDetails = ?7" : "") + " AND self.timetableList IS EMPTY", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getFromDate().minusDays(purchaseOrderForecastRecapLineType.getEstimatedDuration().intValue()), forecastRecap.getToDate().minusDays(purchaseOrderForecastRecapLineType.getEstimatedDuration().intValue()), forecastRecap.getCompany(), statusList, forecastRecap.getBankDetails()}).fetch() : this.purchaseOrderRepo.all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.statusSelect IN (?4) AND self.inTaxTotal != 0" + (forecastRecap.getBankDetails() != null ? " AND self.companyBankDetails = ?5" : "") + " AND self.timetableList IS EMPTY", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), statusList, forecastRecap.getBankDetails()}).fetch();
        for (PurchaseOrder purchaseOrder : purchaseOrderList) {
            purchaseOrder = (PurchaseOrder)((Object)this.purchaseOrderRepo.find(purchaseOrder.getId()));
            BigDecimal amount = this.currencyService.getAmountCurrencyConvertedAtDate(purchaseOrder.getCurrency(), forecastRecap.getCompany().getCurrency(), purchaseOrder.getInTaxTotal(), this.today).setScale(2, RoundingMode.HALF_UP);
            this.createForecastRecapLine(purchaseOrder.getExpectedRealisationDate() == null ? purchaseOrder.getOrderDate().plusDays(purchaseOrderForecastRecapLineType.getEstimatedDuration().intValue()) : purchaseOrder.getExpectedRealisationDate(), purchaseOrderForecastRecapLineType.getTypeSelect(), amount, ((Object)((Object)purchaseOrder)).getClass().getName(), purchaseOrder.getId(), purchaseOrder.getPurchaseOrderSeq(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(purchaseOrderForecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
            JPA.clear();
        }
    }

    public void populateWithTimetables(ForecastRecap forecastRecap, ForecastRecapLineType forecastRecapLineType, List<Integer> statusList) throws AxelorException {
        block6: {
            List timetableList;
            block5: {
                timetableList = new ArrayList();
                if (forecastRecapLineType.getElementSelect() == 2) {
                    timetableList = this.timetableRepo.all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND self.saleOrder.statusSelect IN (?4) AND self.amount != 0" + (forecastRecap.getBankDetails() != null ? " AND self.saleOrder.companyBankDetails = ?5" : ""), new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), statusList, forecastRecap.getBankDetails()}).fetch();
                } else if (forecastRecapLineType.getElementSelect() == 3) {
                    timetableList = this.timetableRepo.all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.purchaseOrder.company = ?3 AND self.purchaseOrder.statusSelect IN (?4) AND self.amount != 0" + (forecastRecap.getBankDetails() != null ? " AND self.purchaseOrder.companyBankDetails = ?5" : ""), new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), statusList, forecastRecap.getBankDetails()}).fetch();
                }
                if (forecastRecapLineType.getElementSelect() != 2) break block5;
                for (Timetable timetable : timetableList) {
                    timetable = (Timetable)this.timetableRepo.find(timetable.getId());
                    BigDecimal amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(timetable.getSaleOrder().getCurrency(), forecastRecap.getCompany().getCurrency(), timetable.getAmount(), this.today).setScale(2, RoundingMode.HALF_UP);
                    this.createForecastRecapLine(timetable.getEstimatedDate(), forecastRecapLineType.getTypeSelect(), amountCompanyCurr, SaleOrder.class.getName(), timetable.getSaleOrder().getId(), timetable.getSaleOrder().getSaleOrderSeq(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(forecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
                    JPA.clear();
                }
                break block6;
            }
            if (forecastRecapLineType.getElementSelect() != 3) break block6;
            for (Timetable timetable : timetableList) {
                timetable = (Timetable)this.timetableRepo.find(timetable.getId());
                BigDecimal amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(timetable.getPurchaseOrder().getCurrency(), forecastRecap.getCompany().getCurrency(), timetable.getAmount(), this.today).setScale(2, RoundingMode.HALF_UP);
                this.createForecastRecapLine(timetable.getEstimatedDate(), forecastRecapLineType.getTypeSelect(), amountCompanyCurr, PurchaseOrder.class.getName(), timetable.getPurchaseOrder().getId(), timetable.getPurchaseOrder().getPurchaseOrderSeq(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(forecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
                JPA.clear();
            }
        }
    }

    public void getTimetablesOrOrders(ForecastRecap forecastRecap, Map<LocalDate, BigDecimal> mapExpected, Map<LocalDate, BigDecimal> mapConfirmed) throws AxelorException {
        List timetableSaleOrderList = new ArrayList();
        ArrayList<SaleOrder> saleOrderList = new ArrayList<SaleOrder>();
        timetableSaleOrderList = forecastRecap.getBankDetails() != null ? ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND self.saleOrder.companyBankDetails = ?4 AND (self.saleOrder.statusSelect = 2 OR self.saleOrder.statusSelect = 3) AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch() : ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND (self.saleOrder.statusSelect = 2 OR self.saleOrder.statusSelect = 3) AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        for (Timetable timetable : timetableSaleOrderList) {
            saleOrderList.add(timetable.getSaleOrder());
            BigDecimal amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(timetable.getSaleOrder().getCurrency(), timetable.getSaleOrder().getCompany().getCurrency(), timetable.getAmount(), this.appBaseService.getTodayDate(forecastRecap.getCompany())).setScale(2, RoundingMode.HALF_UP);
            if (timetable.getSaleOrder().getStatusSelect() == 2) {
                if (mapExpected.containsKey(timetable.getEstimatedDate())) {
                    mapExpected.put(timetable.getEstimatedDate(), mapExpected.get(timetable.getEstimatedDate()).add(amountCompanyCurr));
                    continue;
                }
                mapExpected.put(timetable.getEstimatedDate(), amountCompanyCurr);
                continue;
            }
            if (mapConfirmed.containsKey(timetable.getEstimatedDate())) {
                mapConfirmed.put(timetable.getEstimatedDate(), mapConfirmed.get(timetable.getEstimatedDate()).add(amountCompanyCurr));
                continue;
            }
            mapConfirmed.put(timetable.getEstimatedDate(), amountCompanyCurr);
        }
        List saleOrderNoTimeTableList = new ArrayList();
        saleOrderNoTimeTableList = forecastRecap.getBankDetails() != null ? ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.companyBankDetails = ?4 AND (self.statusSelect = 2 OR self.statusSelect = 3)", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch() : ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND (self.statusSelect = 2 OR self.statusSelect = 3)", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        for (SaleOrder saleOrder : saleOrderNoTimeTableList) {
            BigDecimal amountCompanyCurr;
            if (saleOrderList.contains((Object)saleOrder) || (amountCompanyCurr = saleOrder.getCompanyExTaxTotal().subtract(saleOrder.getAmountInvoiced())).compareTo(BigDecimal.ZERO) != 0) continue;
            if (saleOrder.getStatusSelect() == 2) {
                if (mapExpected.containsKey(saleOrder.getExpectedRealisationDate())) {
                    mapExpected.put(saleOrder.getExpectedRealisationDate(), mapExpected.get(saleOrder.getExpectedRealisationDate()).add(amountCompanyCurr));
                    continue;
                }
                mapExpected.put(saleOrder.getExpectedRealisationDate(), amountCompanyCurr);
                continue;
            }
            if (mapConfirmed.containsKey(saleOrder.getExpectedRealisationDate())) {
                mapConfirmed.put(saleOrder.getExpectedRealisationDate(), mapConfirmed.get(saleOrder.getExpectedRealisationDate()).add(amountCompanyCurr));
                continue;
            }
            mapConfirmed.put(saleOrder.getExpectedRealisationDate(), amountCompanyCurr);
        }
    }

    @Transactional
    public void populateWithForecasts(ForecastRecap forecastRecap) throws AxelorException {
        List forecastList = new ArrayList();
        ForecastRecapLineType forecastForecastRecapLineType = this.getForecastRecapLineType(5);
        forecastList = this.forecastRepo.all().filter("self.estimatedDate < ?1 AND self.company = ?2" + (forecastRecap.getBankDetails() != null ? " AND self.bankDetails = ?3" : "") + " AND self.realizationDate IS NULL", new Object[]{forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
        for (Forecast forecast : forecastList) {
            forecast = (Forecast)((Object)this.forecastRepo.find(forecast.getId()));
            ForecastReason forecastReason = forecast.getForecastReason();
            LocalDate realizationDate = forecast.getEstimatedDate().isAfter(this.appBaseService.getTodayDate(forecastRecap.getCompany())) ? forecast.getEstimatedDate() : this.appBaseService.getTodayDate(forecastRecap.getCompany());
            this.createForecastRecapLine(realizationDate, forecast.getAmount().compareTo(BigDecimal.ZERO) == -1 ? 2 : 1, forecast.getAmount().abs(), ForecastReason.class.getName(), forecastReason.getId(), forecastReason.getReason(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(forecastForecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
            forecast.setRealizationDate(realizationDate);
            this.forecastRepo.save((Model)((Object)forecast));
            JPA.clear();
        }
    }

    public void populateWithForecastsNoSave(ForecastRecap forecastRecap) throws AxelorException {
        ForecastRecapLineType forecastForecastRecapLineType = this.getForecastRecapLineType(5);
        List forecastList = new ArrayList();
        forecastList = this.forecastRepo.all().filter("self.estimatedDate < ?1 AND self.company = ?2" + (forecastRecap.getBankDetails() != null ? " AND self.bankDetails = ?3" : "") + " AND self.realizationDate IS NULL", new Object[]{forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
        for (Forecast forecast : forecastList) {
            forecast = (Forecast)((Object)this.forecastRepo.find(forecast.getId()));
            ForecastReason forecastReason = forecast.getForecastReason();
            LocalDate realizationDate = forecast.getEstimatedDate().isAfter(this.appBaseService.getTodayDate(forecastRecap.getCompany())) ? forecast.getEstimatedDate() : this.appBaseService.getTodayDate(forecastRecap.getCompany());
            this.createForecastRecapLine(realizationDate, forecast.getAmount().compareTo(BigDecimal.ZERO) == -1 ? 2 : 1, forecast.getAmount().abs(), ForecastReason.class.getName(), forecastReason.getId(), forecastReason.getReason(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(forecastForecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
            JPA.clear();
        }
    }

    public void getForecasts(ForecastRecap forecastRecap, Map<LocalDate, BigDecimal> mapExpected, Map<LocalDate, BigDecimal> mapConfirmed) {
        List forecastList = new ArrayList();
        forecastList = forecastRecap.getBankDetails() != null ? ((ForecastRepository)((Object)Beans.get(ForecastRepository.class))).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.bankDetails = ?4 AND self.realizationDate IS NULL", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch() : ((ForecastRepository)((Object)Beans.get(ForecastRepository.class))).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.realizationDate IS NULL", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        for (Forecast forecast : forecastList) {
            if (forecast.getAmount().compareTo(BigDecimal.ZERO) == -1) continue;
            if (mapExpected.containsKey(forecast.getEstimatedDate())) {
                mapExpected.put(forecast.getEstimatedDate(), mapExpected.get(forecast.getEstimatedDate()).add(forecast.getAmount()));
                continue;
            }
            mapExpected.put(forecast.getEstimatedDate(), forecast.getAmount());
        }
    }

    public void populateWithExpenses(ForecastRecap forecastRecap) throws AxelorException {
        ForecastRecapLineType expenseForecastRecapLineType = this.getForecastRecapLineType(4);
        List statusList = StringTool.getIntegerList((String)expenseForecastRecapLineType.getStatusSelect());
        if (statusList.isEmpty()) {
            statusList.add(3);
        }
        List expenseList = new ArrayList();
        expenseList = this.expenseRepo.all().filter("self.validationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.statusSelect IN (?4)" + (forecastRecap.getBankDetails() != null ? " AND self.bankDetails = ?5" : ""), new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), statusList, forecastRecap.getBankDetails()}).fetch();
        for (Expense expense : expenseList) {
            expense = (Expense)this.expenseRepo.find(expense.getId());
            this.createForecastRecapLine(expense.getValidationDate(), expenseForecastRecapLineType.getTypeSelect(), expense.getExTaxTotal(), Expense.class.getName(), expense.getId(), expense.getExpenseSeq(), (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.find(expenseForecastRecapLineType.getId())), (ForecastRecap)((Object)this.forecastRecapRepo.find(forecastRecap.getId())));
            JPA.clear();
        }
    }

    @Transactional
    public void createForecastRecapLine(LocalDate date, int type, BigDecimal amount, String relatedToSelect, Long relatedToSelectId, String relatedToSelectName, ForecastRecapLineType forecastRecapLineType, ForecastRecap forecastRecap) {
        ForecastRecapLine forecastRecapLine = new ForecastRecapLine();
        forecastRecapLine.setEstimatedDate(date);
        forecastRecapLine.setTypeSelect(type);
        forecastRecapLine.setAmount(type == 1 ? amount.abs() : amount.negate());
        forecastRecapLine.setRelatedToSelect(relatedToSelect);
        forecastRecapLine.setRelatedToSelectId(relatedToSelectId);
        forecastRecapLine.setRelatedToSelectName(relatedToSelectName);
        forecastRecapLine.setForecastRecapLineType(forecastRecapLineType);
        forecastRecap.addForecastRecapLineListItem(forecastRecapLine);
        this.forecastRecapRepo.save((Model)((Object)forecastRecap));
    }

    public void computeForecastRecapLineBalance(ForecastRecap forecastRecap) {
        List<ForecastRecapLine> forecastRecapLines = forecastRecap.getForecastRecapLineList();
        Collections.sort(forecastRecapLines, new Comparator<ForecastRecapLine>(){

            @Override
            public int compare(ForecastRecapLine forecastRecapLine1, ForecastRecapLine forecastRecapLine2) {
                int compareEstimatedDate = forecastRecapLine1.getEstimatedDate().compareTo(forecastRecapLine2.getEstimatedDate());
                int compareTypeSelect = forecastRecapLine1.getForecastRecapLineType().getSequence().compareTo(forecastRecapLine2.getForecastRecapLineType().getSequence());
                int compareId = forecastRecapLine1.getId().compareTo(forecastRecapLine2.getId());
                if (compareEstimatedDate == 0) {
                    return compareTypeSelect == 0 ? compareId : compareTypeSelect;
                }
                return compareEstimatedDate;
            }
        });
        for (ForecastRecapLine forecastRecapLine : forecastRecapLines) {
            forecastRecap.setCurrentBalance(forecastRecap.getCurrentBalance().add(forecastRecapLine.getAmount()));
            forecastRecapLine.setBalance(forecastRecap.getCurrentBalance());
        }
        forecastRecap.setForecastRecapLineList(forecastRecapLines);
    }

    public String getForecastRecapFileLink(Long forecastRecapId, String reportType) throws AxelorException {
        String title = I18n.get((String)"ForecastRecap");
        title = title + forecastRecapId;
        ForecastRecap forecastRecap = (ForecastRecap)((Object)JPA.find(ForecastRecap.class, (Long)forecastRecapId));
        return ReportFactory.createReport((String)"ForecastRecap.rptdesign", (String)(title + "-${date}")).addParam("ForecastRecapId", (Object)forecastRecapId.toString()).addParam("Timezone", forecastRecap.getCompany() != null ? forecastRecap.getCompany().getTimezone() : null).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addFormat(reportType).generate().getFileLink();
    }

    protected ForecastRecapLineType getForecastRecapLineType(int elementSelect) throws AxelorException {
        ForecastRecapLineType forecastRecapLineType = (ForecastRecapLineType)((Object)this.forecastRecapLineTypeRepo.all().filter("self.elementSelect = ?1", new Object[]{elementSelect}).fetchOne());
        if (forecastRecapLineType != null) {
            return forecastRecapLineType;
        }
        throw new AxelorException(4, I18n.get((String)"No move type found for element : %s"), new Object[]{elementSelect});
    }
}

