/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.cash.management.web;

import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.cash.management.db.ForecastRecap;
import com.axelor.apps.cash.management.db.ForecastRecapLine;
import com.axelor.apps.cash.management.db.repo.ForecastRecapRepository;
import com.axelor.apps.cash.management.service.ForecastRecapService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForecastRecapController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void populate(ActionRequest request, ActionResponse response) throws AxelorException {
        ForecastRecap forecastRecap = (ForecastRecap)((Object)request.getContext().asType(ForecastRecap.class));
        if (forecastRecap.getCompany() == null) {
            throw new AxelorException(4, I18n.get((String)"Please select a company"));
        }
        ((ForecastRecapService)Beans.get(ForecastRecapService.class)).populate((ForecastRecap)((Object)((ForecastRecapRepository)((Object)Beans.get(ForecastRecapRepository.class))).find(forecastRecap.getId())));
        response.setReload(true);
    }

    public void fillStartingBalance(ActionRequest request, ActionResponse response) {
        ForecastRecap forecastRecap = (ForecastRecap)((Object)request.getContext().asType(ForecastRecap.class));
        try {
            if (forecastRecap.getBankDetails() != null) {
                BigDecimal amount = ((CurrencyService)Beans.get(CurrencyService.class)).getAmountCurrencyConvertedAtDate(forecastRecap.getBankDetails().getCurrency(), forecastRecap.getCompany().getCurrency(), forecastRecap.getBankDetails().getBalance(), ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(forecastRecap.getCompany())).setScale(2, RoundingMode.HALF_UP);
                forecastRecap.setStartingBalance(amount);
            } else {
                BigDecimal amount = ((CurrencyService)Beans.get(CurrencyService.class)).getAmountCurrencyConvertedAtDate(forecastRecap.getCompany().getDefaultBankDetails().getCurrency(), forecastRecap.getCompany().getCurrency(), forecastRecap.getCompany().getDefaultBankDetails().getBalance(), ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(forecastRecap.getCompany())).setScale(2, RoundingMode.HALF_UP);
                forecastRecap.setStartingBalance(amount);
            }
            response.setValues((Object)forecastRecap);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void sales(ActionRequest request, ActionResponse response) throws AxelorException {
        HashMap<String, Object> dataMap;
        Long id = new Long(request.getContext().get((Object)"_id").toString());
        ForecastRecapService forecastRecapService = (ForecastRecapService)Beans.get(ForecastRecapService.class);
        ForecastRecap forecastRecap = (ForecastRecap)((Object)((ForecastRecapRepository)((Object)Beans.get(ForecastRecapRepository.class))).find(id));
        forecastRecap.setForecastRecapLineList(new ArrayList<ForecastRecapLine>());
        HashMap<LocalDate, BigDecimal> mapExpected = new HashMap<LocalDate, BigDecimal>();
        HashMap<LocalDate, BigDecimal> mapConfirmed = new HashMap<LocalDate, BigDecimal>();
        if (forecastRecap.getOpportunitiesTypeSelect() != null && forecastRecap.getOpportunitiesTypeSelect() > 1) {
            forecastRecapService.getOpportunities(forecastRecap, mapExpected, mapConfirmed);
        }
        forecastRecapService.getInvoices(forecastRecap, mapExpected, mapConfirmed);
        forecastRecapService.getTimetablesOrOrders(forecastRecap, mapExpected, mapConfirmed);
        forecastRecapService.getForecasts(forecastRecap, mapExpected, mapConfirmed);
        ArrayList dataList = new ArrayList();
        Set keyList = mapExpected.keySet();
        for (LocalDate date : keyList) {
            dataMap = new HashMap<String, Object>();
            dataMap.put("date", date);
            dataMap.put("amount", mapExpected.get(date));
            dataMap.put("type", I18n.get((String)"Expected"));
            dataList.add(dataMap);
        }
        keyList = mapConfirmed.keySet();
        for (LocalDate date : keyList) {
            dataMap = new HashMap();
            dataMap.put("date", date);
            dataMap.put("amount", mapConfirmed.get(date));
            dataMap.put("type", I18n.get((String)"Confirmed"));
            dataList.add(dataMap);
        }
        response.setData(dataList);
    }

    public void spending(ActionRequest request, ActionResponse response) throws AxelorException {
        Long id = new Long(request.getContext().get((Object)"_id").toString());
        ForecastRecap forecastRecap = (ForecastRecap)((Object)((ForecastRecapRepository)((Object)Beans.get(ForecastRecapRepository.class))).find(id));
        ArrayList dataList = new ArrayList();
        HashMap<LocalDate, BigDecimal> map = new HashMap<LocalDate, BigDecimal>();
        for (ForecastRecapLine forecastRecapLine : forecastRecap.getForecastRecapLineList()) {
            if (forecastRecapLine.getTypeSelect() != 2) continue;
            if (map.containsKey(forecastRecapLine.getEstimatedDate())) {
                map.put(forecastRecapLine.getEstimatedDate(), ((BigDecimal)map.get(forecastRecapLine.getEstimatedDate())).add(forecastRecapLine.getAmount()));
                continue;
            }
            map.put(forecastRecapLine.getEstimatedDate(), forecastRecapLine.getAmount());
        }
        Set keyList = map.keySet();
        for (LocalDate date : keyList) {
            HashMap<String, LocalDate> dataMap = new HashMap<String, LocalDate>();
            dataMap.put("date", date);
            dataMap.put("amount", (LocalDate)map.get(date));
            dataList.add(dataMap);
        }
        response.setData(dataList);
    }

    public void marges(ActionRequest request, ActionResponse response) throws AxelorException {
        Long id = new Long(request.getContext().get((Object)"_id").toString());
        ForecastRecap forecastRecap = (ForecastRecap)((Object)((ForecastRecapRepository)((Object)Beans.get(ForecastRecapRepository.class))).find(id));
        ArrayList dataList = new ArrayList();
        HashMap<LocalDate, BigDecimal> map = new HashMap<LocalDate, BigDecimal>();
        for (ForecastRecapLine forecastRecapLine : forecastRecap.getForecastRecapLineList()) {
            if (forecastRecapLine.getTypeSelect() == 2) {
                if (map.containsKey(forecastRecapLine.getEstimatedDate())) {
                    map.put(forecastRecapLine.getEstimatedDate(), ((BigDecimal)map.get(forecastRecapLine.getEstimatedDate())).subtract(forecastRecapLine.getAmount()));
                    continue;
                }
                map.put(forecastRecapLine.getEstimatedDate(), BigDecimal.ZERO.subtract(forecastRecapLine.getAmount()));
                continue;
            }
            if (map.containsKey(forecastRecapLine.getEstimatedDate())) {
                map.put(forecastRecapLine.getEstimatedDate(), ((BigDecimal)map.get(forecastRecapLine.getEstimatedDate())).add(forecastRecapLine.getAmount()));
                continue;
            }
            map.put(forecastRecapLine.getEstimatedDate(), forecastRecapLine.getAmount());
        }
        Set keyList = map.keySet();
        for (LocalDate date : keyList) {
            HashMap<String, LocalDate> dataMap = new HashMap<String, LocalDate>();
            dataMap.put("date", date);
            dataMap.put("amount", (LocalDate)map.get(date));
            dataList.add(dataMap);
        }
        response.setData(dataList);
    }

    public void print(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        Long forecastRecapId = new Long(context.get((Object)"_forecastRecapId").toString());
        String reportType = (String)context.get((Object)"reportTypeSelect");
        String fileLink = ((ForecastRecapService)Beans.get(ForecastRecapService.class)).getForecastRecapFileLink(forecastRecapId, reportType);
        String title = I18n.get((String)"ForecastRecap");
        title = title + forecastRecapId;
        this.logger.debug("Printing " + title);
        response.setView(ActionView.define((String)title).add("html", fileLink).map());
        response.setCanClose(true);
    }
}

