/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.Umr;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Blocking;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Function;
import com.axelor.apps.base.db.IndustrySector;
import com.axelor.apps.base.db.Language;
import com.axelor.apps.base.db.PartnerAddress;
import com.axelor.apps.base.db.PartnerCategory;
import com.axelor.apps.base.db.PartnerPriceList;
import com.axelor.apps.base.db.Source;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.sale.db.CustomerCatalog;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_PARTNER", indexes={@Index(columnList="partner_category"), @Index(columnList="job_title_function"), @Index(columnList="language"), @Index(columnList="email_address"), @Index(columnList="sale_partner_price_list"), @Index(columnList="purchase_partner_price_list"), @Index(columnList="fullName"), @Index(columnList="fiscal_position"), @Index(columnList="main_address")})
public class Partner
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PARTNER_SEQ")
    @SequenceGenerator(name="BASE_PARTNER_SEQ", sequenceName="BASE_PARTNER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Category", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PartnerCategory partnerCategory;
    @HashKey
    @Widget(title="Reference", readonly=true)
    @Column(unique=true)
    private String partnerSeq;
    @Widget(title="Partner Type", selection="partner.partner.type.select")
    private Integer partnerTypeSelect = 0;
    @Widget(title="Civility", selection="partner.title.type.select", massUpdate=true)
    private Integer titleSelect = 0;
    @Widget(title="Name/Company Name")
    @NotNull
    private String name;
    @Widget(title="First Name")
    private String firstName;
    @Widget(title="Function")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Function jobTitleFunction;
    @Widget(title="Photo")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile picture;
    @Widget(title="Customer")
    private Boolean isCustomer = Boolean.FALSE;
    @Widget(title="Prospect")
    private Boolean isProspect = Boolean.FALSE;
    @Widget(title="Supplier")
    private Boolean isSupplier = Boolean.FALSE;
    @Widget(title="Employee")
    private Boolean isEmployee = Boolean.FALSE;
    @Widget(title="Contact")
    private Boolean isContact = Boolean.FALSE;
    @Widget(title="Language", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Language language;
    @Widget(title="Mother company", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner parentPartner;
    @Widget(title="Addresses")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PartnerAddress> partnerAddressList;
    @Widget(title="Contacts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> contactPartnerSet;
    @Widget(title="Main company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner mainPartner;
    @Widget(title="Source", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Source source;
    @Widget(title="Email")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAddress emailAddress;
    @Widget(title="Fax")
    private String fax;
    @Widget(title="Fixed phone")
    private String fixedPhone;
    @Widget(title="Mobile phone")
    private String mobilePhone;
    @Widget(title="Website")
    private String webSite;
    @Widget(title="Dept./Div.")
    private String department;
    @Widget(title="Companies associated to")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Company> companySet;
    @Widget(title="Bank Details list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BankDetails> bankDetailsList;
    @Widget(title="Currency", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Sale price lists")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PartnerPriceList salePartnerPriceList;
    @Widget(title="Purchase price lists")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PartnerPriceList purchasePartnerPriceList;
    @Widget(title="Payment delay (Average in days)", massUpdate=true)
    private BigDecimal paymentDelay = BigDecimal.ZERO;
    @Widget(title="Blocking follow-up List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="blockingToDate DESC")
    private List<Blocking> blockingList;
    @Widget(title="Batches")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Assigned to", massUpdate=true)
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="User")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User linkedUser;
    @Widget(title="Team", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Reports to", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner reportsTo;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Industry sector", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private IndustrySector industrySector;
    @Widget(title="Employees (Nbr)")
    @Min(value=0L)
    private Integer nbrEmployees = 0;
    @Widget(title="Turnover")
    private Integer saleTurnover = 0;
    @Widget(title="Registration code")
    private String registrationCode;
    @Widget(title="Main activity code")
    private String mainActivityCode;
    @Widget(title="Tax N\u00b0")
    private String taxNbr;
    @Widget(title="Name")
    @NameColumn
    private String fullName;
    @Widget(title="Name")
    private String simpleFullName;
    @Widget(title="Fiscal position", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FiscalPosition fiscalPosition;
    @Widget(title="Address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address mainAddress;
    @Widget(title="Time slot")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String timeSlot;
    @Widget(title="Companies")
    private String companyStr;
    @Widget(title="Fields")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String partnerAttrs;
    @Widget(title="Fields")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String contactAttrs;
    @Widget(title="Head office address")
    private String headOfficeAddress;
    @Widget(title="Comment to display on invoice")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String invoiceComments;
    @Widget(title="Comment to display on sale order")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String saleOrderComments;
    @Widget(title="Comment to display on purchase order")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String purchaseOrderComments;
    @Widget(title="Comment to display on delivery")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String deliveryComments;
    @Widget(title="Comment to display on picking order")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String pickingOrderComments;
    @Widget(title="Comment to display on proforma")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String proformaComments;
    @Widget(title="Label to be displayed on sale orders", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String saleOrderInformation;
    @Widget(title="Customer Catalog Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="customerPartner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CustomerCatalog> customerCatalogList;
    @Widget(title="Payer quality", readonly=true)
    private BigDecimal payerQuality = BigDecimal.ZERO;
    @Widget(title="Accounting situation")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountingSituation> accountingSituationList;
    @Widget(title="Invoice sending media", selection="invoice.account.condition.invoice.sending.format.select")
    private String invoiceSendingFormatSelect;
    @Widget(title="In Payment Mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode inPaymentMode;
    @Widget(title="Out Payment Mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode outPaymentMode;
    @Widget(title="Payment condition", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @Widget(title="Reject counter")
    private Integer rejectCounter = 0;
    @Widget(title="Invoices copy", selection="grade.1.up.to.10.select")
    private Integer invoicesCopySelect = 1;
    @Widget(title="UMR List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Umr> umrList;
    @Widget(title="Active UMR")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Umr activeUmr;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Specific tax note")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String specificTaxNote;
    @Widget(title="Factor")
    private Boolean isFactor = Boolean.FALSE;
    private Boolean factorizedCustomer = Boolean.FALSE;
    private String sellerCode;
    @Widget(title="Employee")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="contactPartner", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Partner() {
    }

    public Partner(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PartnerCategory getPartnerCategory() {
        return this.partnerCategory;
    }

    public void setPartnerCategory(PartnerCategory partnerCategory) {
        this.partnerCategory = partnerCategory;
    }

    public String getPartnerSeq() {
        return this.partnerSeq;
    }

    public void setPartnerSeq(String partnerSeq) {
        this.partnerSeq = partnerSeq;
    }

    public Integer getPartnerTypeSelect() {
        return this.partnerTypeSelect == null ? 0 : this.partnerTypeSelect;
    }

    public void setPartnerTypeSelect(Integer partnerTypeSelect) {
        this.partnerTypeSelect = partnerTypeSelect;
    }

    public Integer getTitleSelect() {
        return this.titleSelect == null ? 0 : this.titleSelect;
    }

    public void setTitleSelect(Integer titleSelect) {
        this.titleSelect = titleSelect;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Function getJobTitleFunction() {
        return this.jobTitleFunction;
    }

    public void setJobTitleFunction(Function jobTitleFunction) {
        this.jobTitleFunction = jobTitleFunction;
    }

    public MetaFile getPicture() {
        return this.picture;
    }

    public void setPicture(MetaFile picture) {
        this.picture = picture;
    }

    public Boolean getIsCustomer() {
        return this.isCustomer == null ? Boolean.FALSE : this.isCustomer;
    }

    public void setIsCustomer(Boolean isCustomer) {
        this.isCustomer = isCustomer;
    }

    public Boolean getIsProspect() {
        return this.isProspect == null ? Boolean.FALSE : this.isProspect;
    }

    public void setIsProspect(Boolean isProspect) {
        this.isProspect = isProspect;
    }

    public Boolean getIsSupplier() {
        return this.isSupplier == null ? Boolean.FALSE : this.isSupplier;
    }

    public void setIsSupplier(Boolean isSupplier) {
        this.isSupplier = isSupplier;
    }

    public Boolean getIsEmployee() {
        return this.isEmployee == null ? Boolean.FALSE : this.isEmployee;
    }

    public void setIsEmployee(Boolean isEmployee) {
        this.isEmployee = isEmployee;
    }

    public Boolean getIsContact() {
        return this.isContact == null ? Boolean.FALSE : this.isContact;
    }

    public void setIsContact(Boolean isContact) {
        this.isContact = isContact;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Partner getParentPartner() {
        return this.parentPartner;
    }

    public void setParentPartner(Partner parentPartner) {
        this.parentPartner = parentPartner;
    }

    public List<PartnerAddress> getPartnerAddressList() {
        return this.partnerAddressList;
    }

    public void setPartnerAddressList(List<PartnerAddress> partnerAddressList) {
        this.partnerAddressList = partnerAddressList;
    }

    public void addPartnerAddressListItem(PartnerAddress item) {
        if (this.getPartnerAddressList() == null) {
            this.setPartnerAddressList(new ArrayList<PartnerAddress>());
        }
        this.getPartnerAddressList().add(item);
        item.setPartner(this);
    }

    public void removePartnerAddressListItem(PartnerAddress item) {
        if (this.getPartnerAddressList() == null) {
            return;
        }
        this.getPartnerAddressList().remove(item);
    }

    public void clearPartnerAddressList() {
        if (this.getPartnerAddressList() != null) {
            this.getPartnerAddressList().clear();
        }
    }

    public Set<Partner> getContactPartnerSet() {
        return this.contactPartnerSet;
    }

    public void setContactPartnerSet(Set<Partner> contactPartnerSet) {
        this.contactPartnerSet = contactPartnerSet;
    }

    public void addContactPartnerSetItem(Partner item) {
        if (this.getContactPartnerSet() == null) {
            this.setContactPartnerSet(new HashSet<Partner>());
        }
        this.getContactPartnerSet().add(item);
    }

    public void removeContactPartnerSetItem(Partner item) {
        if (this.getContactPartnerSet() == null) {
            return;
        }
        this.getContactPartnerSet().remove((Object)item);
    }

    public void clearContactPartnerSet() {
        if (this.getContactPartnerSet() != null) {
            this.getContactPartnerSet().clear();
        }
    }

    public Partner getMainPartner() {
        return this.mainPartner;
    }

    public void setMainPartner(Partner mainPartner) {
        this.mainPartner = mainPartner;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddress emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getFixedPhone() {
        return this.fixedPhone;
    }

    public void setFixedPhone(String fixedPhone) {
        this.fixedPhone = fixedPhone;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getWebSite() {
        return this.webSite;
    }

    public void setWebSite(String webSite) {
        this.webSite = webSite;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public Set<Company> getCompanySet() {
        return this.companySet;
    }

    public void setCompanySet(Set<Company> companySet) {
        this.companySet = companySet;
    }

    public void addCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            this.setCompanySet(new HashSet<Company>());
        }
        this.getCompanySet().add(item);
    }

    public void removeCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            return;
        }
        this.getCompanySet().remove((Object)item);
    }

    public void clearCompanySet() {
        if (this.getCompanySet() != null) {
            this.getCompanySet().clear();
        }
    }

    public List<BankDetails> getBankDetailsList() {
        return this.bankDetailsList;
    }

    public void setBankDetailsList(List<BankDetails> bankDetailsList) {
        this.bankDetailsList = bankDetailsList;
    }

    public void addBankDetailsListItem(BankDetails item) {
        if (this.getBankDetailsList() == null) {
            this.setBankDetailsList(new ArrayList<BankDetails>());
        }
        this.getBankDetailsList().add(item);
        item.setPartner(this);
    }

    public void removeBankDetailsListItem(BankDetails item) {
        if (this.getBankDetailsList() == null) {
            return;
        }
        this.getBankDetailsList().remove((Object)item);
    }

    public void clearBankDetailsList() {
        if (this.getBankDetailsList() != null) {
            this.getBankDetailsList().clear();
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public PartnerPriceList getSalePartnerPriceList() {
        return this.salePartnerPriceList;
    }

    public void setSalePartnerPriceList(PartnerPriceList salePartnerPriceList) {
        this.salePartnerPriceList = salePartnerPriceList;
    }

    public PartnerPriceList getPurchasePartnerPriceList() {
        return this.purchasePartnerPriceList;
    }

    public void setPurchasePartnerPriceList(PartnerPriceList purchasePartnerPriceList) {
        this.purchasePartnerPriceList = purchasePartnerPriceList;
    }

    public BigDecimal getPaymentDelay() {
        return this.paymentDelay == null ? BigDecimal.ZERO : this.paymentDelay;
    }

    public void setPaymentDelay(BigDecimal paymentDelay) {
        this.paymentDelay = paymentDelay;
    }

    public List<Blocking> getBlockingList() {
        return this.blockingList;
    }

    public void setBlockingList(List<Blocking> blockingList) {
        this.blockingList = blockingList;
    }

    public void addBlockingListItem(Blocking item) {
        if (this.getBlockingList() == null) {
            this.setBlockingList(new ArrayList<Blocking>());
        }
        this.getBlockingList().add(item);
        item.setPartner(this);
    }

    public void removeBlockingListItem(Blocking item) {
        if (this.getBlockingList() == null) {
            return;
        }
        this.getBlockingList().remove((Object)item);
    }

    public void clearBlockingList() {
        if (this.getBlockingList() != null) {
            this.getBlockingList().clear();
        }
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getLinkedUser() {
        return this.linkedUser;
    }

    public void setLinkedUser(User linkedUser) {
        if (this.getLinkedUser() != null) {
            this.getLinkedUser().setPartner(null);
        }
        if (linkedUser != null) {
            linkedUser.setPartner(this);
        }
        this.linkedUser = linkedUser;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Partner getReportsTo() {
        return this.reportsTo;
    }

    public void setReportsTo(Partner reportsTo) {
        this.reportsTo = reportsTo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IndustrySector getIndustrySector() {
        return this.industrySector;
    }

    public void setIndustrySector(IndustrySector industrySector) {
        this.industrySector = industrySector;
    }

    public Integer getNbrEmployees() {
        return this.nbrEmployees == null ? 0 : this.nbrEmployees;
    }

    public void setNbrEmployees(Integer nbrEmployees) {
        this.nbrEmployees = nbrEmployees;
    }

    public Integer getSaleTurnover() {
        return this.saleTurnover == null ? 0 : this.saleTurnover;
    }

    public void setSaleTurnover(Integer saleTurnover) {
        this.saleTurnover = saleTurnover;
    }

    public String getRegistrationCode() {
        return this.registrationCode;
    }

    public void setRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
    }

    public String getMainActivityCode() {
        return this.mainActivityCode;
    }

    public void setMainActivityCode(String mainActivityCode) {
        this.mainActivityCode = mainActivityCode;
    }

    public String getTaxNbr() {
        return this.taxNbr;
    }

    public void setTaxNbr(String taxNbr) {
        this.taxNbr = taxNbr;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getSimpleFullName() {
        return this.simpleFullName;
    }

    public void setSimpleFullName(String simpleFullName) {
        this.simpleFullName = simpleFullName;
    }

    public FiscalPosition getFiscalPosition() {
        return this.fiscalPosition;
    }

    public void setFiscalPosition(FiscalPosition fiscalPosition) {
        this.fiscalPosition = fiscalPosition;
    }

    public Address getMainAddress() {
        return this.mainAddress;
    }

    public void setMainAddress(Address mainAddress) {
        this.mainAddress = mainAddress;
    }

    public String getTimeSlot() {
        return this.timeSlot;
    }

    public void setTimeSlot(String timeSlot) {
        this.timeSlot = timeSlot;
    }

    public String getCompanyStr() {
        return this.companyStr;
    }

    public void setCompanyStr(String companyStr) {
        this.companyStr = companyStr;
    }

    public String getPartnerAttrs() {
        return this.partnerAttrs;
    }

    public void setPartnerAttrs(String partnerAttrs) {
        this.partnerAttrs = partnerAttrs;
    }

    public String getContactAttrs() {
        return this.contactAttrs;
    }

    public void setContactAttrs(String contactAttrs) {
        this.contactAttrs = contactAttrs;
    }

    public String getHeadOfficeAddress() {
        return this.headOfficeAddress;
    }

    public void setHeadOfficeAddress(String headOfficeAddress) {
        this.headOfficeAddress = headOfficeAddress;
    }

    public String getInvoiceComments() {
        return this.invoiceComments;
    }

    public void setInvoiceComments(String invoiceComments) {
        this.invoiceComments = invoiceComments;
    }

    public String getSaleOrderComments() {
        return this.saleOrderComments;
    }

    public void setSaleOrderComments(String saleOrderComments) {
        this.saleOrderComments = saleOrderComments;
    }

    public String getPurchaseOrderComments() {
        return this.purchaseOrderComments;
    }

    public void setPurchaseOrderComments(String purchaseOrderComments) {
        this.purchaseOrderComments = purchaseOrderComments;
    }

    public String getDeliveryComments() {
        return this.deliveryComments;
    }

    public void setDeliveryComments(String deliveryComments) {
        this.deliveryComments = deliveryComments;
    }

    public String getPickingOrderComments() {
        return this.pickingOrderComments;
    }

    public void setPickingOrderComments(String pickingOrderComments) {
        this.pickingOrderComments = pickingOrderComments;
    }

    public String getProformaComments() {
        return this.proformaComments;
    }

    public void setProformaComments(String proformaComments) {
        this.proformaComments = proformaComments;
    }

    public String getSaleOrderInformation() {
        return this.saleOrderInformation;
    }

    public void setSaleOrderInformation(String saleOrderInformation) {
        this.saleOrderInformation = saleOrderInformation;
    }

    public List<CustomerCatalog> getCustomerCatalogList() {
        return this.customerCatalogList;
    }

    public void setCustomerCatalogList(List<CustomerCatalog> customerCatalogList) {
        this.customerCatalogList = customerCatalogList;
    }

    public void addCustomerCatalogListItem(CustomerCatalog item) {
        if (this.getCustomerCatalogList() == null) {
            this.setCustomerCatalogList(new ArrayList<CustomerCatalog>());
        }
        this.getCustomerCatalogList().add(item);
        item.setCustomerPartner(this);
    }

    public void removeCustomerCatalogListItem(CustomerCatalog item) {
        if (this.getCustomerCatalogList() == null) {
            return;
        }
        this.getCustomerCatalogList().remove(item);
    }

    public void clearCustomerCatalogList() {
        if (this.getCustomerCatalogList() != null) {
            this.getCustomerCatalogList().clear();
        }
    }

    public BigDecimal getPayerQuality() {
        return this.payerQuality == null ? BigDecimal.ZERO : this.payerQuality;
    }

    public void setPayerQuality(BigDecimal payerQuality) {
        this.payerQuality = payerQuality;
    }

    public List<AccountingSituation> getAccountingSituationList() {
        return this.accountingSituationList;
    }

    public void setAccountingSituationList(List<AccountingSituation> accountingSituationList) {
        this.accountingSituationList = accountingSituationList;
    }

    public void addAccountingSituationListItem(AccountingSituation item) {
        if (this.getAccountingSituationList() == null) {
            this.setAccountingSituationList(new ArrayList<AccountingSituation>());
        }
        this.getAccountingSituationList().add(item);
        item.setPartner(this);
    }

    public void removeAccountingSituationListItem(AccountingSituation item) {
        if (this.getAccountingSituationList() == null) {
            return;
        }
        this.getAccountingSituationList().remove(item);
    }

    public void clearAccountingSituationList() {
        if (this.getAccountingSituationList() != null) {
            this.getAccountingSituationList().clear();
        }
    }

    public String getInvoiceSendingFormatSelect() {
        return this.invoiceSendingFormatSelect;
    }

    public void setInvoiceSendingFormatSelect(String invoiceSendingFormatSelect) {
        this.invoiceSendingFormatSelect = invoiceSendingFormatSelect;
    }

    public PaymentMode getInPaymentMode() {
        return this.inPaymentMode;
    }

    public void setInPaymentMode(PaymentMode inPaymentMode) {
        this.inPaymentMode = inPaymentMode;
    }

    public PaymentMode getOutPaymentMode() {
        return this.outPaymentMode;
    }

    public void setOutPaymentMode(PaymentMode outPaymentMode) {
        this.outPaymentMode = outPaymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public Integer getRejectCounter() {
        return this.rejectCounter == null ? 0 : this.rejectCounter;
    }

    public void setRejectCounter(Integer rejectCounter) {
        this.rejectCounter = rejectCounter;
    }

    public Integer getInvoicesCopySelect() {
        return this.invoicesCopySelect == null ? 0 : this.invoicesCopySelect;
    }

    public void setInvoicesCopySelect(Integer invoicesCopySelect) {
        this.invoicesCopySelect = invoicesCopySelect;
    }

    public List<Umr> getUmrList() {
        return this.umrList;
    }

    public void setUmrList(List<Umr> umrList) {
        this.umrList = umrList;
    }

    public void addUmrListItem(Umr item) {
        if (this.getUmrList() == null) {
            this.setUmrList(new ArrayList<Umr>());
        }
        this.getUmrList().add(item);
        item.setPartner(this);
    }

    public void removeUmrListItem(Umr item) {
        if (this.getUmrList() == null) {
            return;
        }
        this.getUmrList().remove(item);
    }

    public void clearUmrList() {
        if (this.getUmrList() != null) {
            this.getUmrList().clear();
        }
    }

    public Umr getActiveUmr() {
        return this.activeUmr;
    }

    public void setActiveUmr(Umr activeUmr) {
        this.activeUmr = activeUmr;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public String getSpecificTaxNote() {
        return this.specificTaxNote;
    }

    public void setSpecificTaxNote(String specificTaxNote) {
        this.specificTaxNote = specificTaxNote;
    }

    public Boolean getIsFactor() {
        return this.isFactor == null ? Boolean.FALSE : this.isFactor;
    }

    public void setIsFactor(Boolean isFactor) {
        this.isFactor = isFactor;
    }

    public Boolean getFactorizedCustomer() {
        return this.factorizedCustomer == null ? Boolean.FALSE : this.factorizedCustomer;
    }

    public void setFactorizedCustomer(Boolean factorizedCustomer) {
        this.factorizedCustomer = factorizedCustomer;
    }

    public String getSellerCode() {
        return this.sellerCode;
    }

    public void setSellerCode(String sellerCode) {
        this.sellerCode = sellerCode;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        if (this.getEmployee() != null) {
            this.getEmployee().setContactPartner(null);
        }
        if (employee != null) {
            employee.setContactPartner(this);
        }
        this.employee = employee;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Partner)) {
            return false;
        }
        Partner other = (Partner)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getPartnerSeq(), other.getPartnerSeq());
    }

    public int hashCode() {
        return Objects.hash(871724200, this.getPartnerSeq());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("partnerSeq", (Object)this.getPartnerSeq()).add("partnerTypeSelect", (Object)this.getPartnerTypeSelect()).add("titleSelect", (Object)this.getTitleSelect()).add("name", (Object)this.getName()).add("firstName", (Object)this.getFirstName()).add("isCustomer", (Object)this.getIsCustomer()).add("isProspect", (Object)this.getIsProspect()).add("isSupplier", (Object)this.getIsSupplier()).add("isEmployee", (Object)this.getIsEmployee()).add("isContact", (Object)this.getIsContact()).add("fax", (Object)this.getFax()).omitNullValues().toString();
    }
}

