/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.mobile.web;

import com.axelor.apps.base.db.AppMobile;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.auth.db.AuditableModel;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class AppMobileController {
    public void getAppMobile(ActionRequest request, ActionResponse response) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        AppService appService = (AppService)Beans.get(AppService.class);
        AppMobile appMobile = (AppMobile)appService.getApp("mobile");
        data.put("isAppMobileEnable", appMobile.getActive());
        data.put("isSaleAppEnable", appService.isApp("sale") ? appMobile.getIsSaleAppEnable() : false);
        data.put("isCrmAppEnable", appService.isApp("crm") ? appMobile.getIsCrmAppEnable() : false);
        data.put("isTimesheetAppEnable", appService.isApp("timesheet") ? appMobile.getIsTimesheetAppEnable() : false);
        data.put("isLeaveAppEnable", appService.isApp("leave") ? appMobile.getIsLeaveAppEnable() : false);
        data.put("isExpenseAppEnable", appService.isApp("expense") ? appMobile.getIsExpenseAppEnable() : false);
        data.put("isTaskAppEnable", appService.isApp("project") ? appMobile.getIsTaskAppEnable() : false);
        data.put("isQualityAppEnable", appService.isApp("quality") ? appMobile.getIsQualityAppEnable() : false);
        data.put("isStockAppEnable", appService.isApp("stock") ? appMobile.getIsStockAppEnable() : false);
        boolean isProductionAppEnable = appService.isApp("production") ? appMobile.getIsProductionAppEnable() : false;
        data.put("isProductionAppEnable", isProductionAppEnable);
        if (isProductionAppEnable) {
            data.put("mOFilterOnStockDetailStatusSelect", appMobile.getmOFilterOnStockDetailStatusSelect());
        }
        data.put("offlineRecordLimit", appMobile.getOfflineRecordLimit());
        data.put("partnerSet", this.convertToData(appMobile.getPartnerSet()));
        data.put("partnerContactSet", this.convertToData(appMobile.getPartnerContactSet()));
        data.put("projectSet", this.convertToData(appMobile.getProjectSet()));
        data.put("leadSet", this.convertToData(appMobile.getLeadSet()));
        data.put("productSet", this.convertToData(appMobile.getProductSet()));
        response.setData(data);
    }

    private Object convertToData(Set<? extends AuditableModel> modelSet) {
        return modelSet.stream().map(it -> new HashMap<String, Object>(){
            {
                this.put("id", it.getId());
                this.put("version", it.getVersion());
            }
        }).collect(Collectors.toSet());
    }
}

