/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.stock.db.InventoryLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_INVENTORY", uniqueConstraints={@UniqueConstraint(columnNames={"inventorySeq", "stock_location"})}, indexes={@Index(columnList="inventorySeq"), @Index(columnList="stock_location"), @Index(columnList="import_file"), @Index(columnList="company"), @Index(columnList="product_family"), @Index(columnList="product_category"), @Index(columnList="product"), @Index(columnList="validated_by"), @Index(columnList="completed_by")})
public class Inventory
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_INVENTORY_SEQ")
    @SequenceGenerator(name="STOCK_INVENTORY_SEQ", sequenceName="STOCK_INVENTORY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Inventory N\u00b0", readonly=true)
    @NameColumn
    private String inventorySeq;
    @Widget(title="Stock location")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Status", readonly=true, selection="inventory.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Planned Start Date")
    private ZonedDateTime plannedStartDateT;
    @Widget(title="Planned End Date")
    private ZonedDateTime plannedEndDateT;
    @Widget(title="Inventory Title")
    private String inventoryTitle;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Inventory lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="inventory", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InventoryLine> inventoryLineList;
    @Widget(title="File Format", selection="inventory.export.format.select")
    private String formatSelect;
    @Widget(title="File (CSV)")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile importFile;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Accounting family")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductFamily productFamily;
    @Widget(title="Product category")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductCategory productCategory;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Excl. out of stock products")
    private Boolean excludeOutOfStock = Boolean.FALSE;
    @Widget(title="Incl. obsolete products")
    private Boolean includeObsolete = Boolean.FALSE;
    @Widget(title="From rack")
    private String fromRack;
    @Widget(title="To rack")
    private String toRack;
    @Widget(title="Validated By")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedBy;
    @Widget(title="User")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User completedBy;
    @Widget(title="Validated On")
    private LocalDate validatedOn;
    @Widget(title="Type", selection="product.inventory.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getInventorySeq() {
        return this.inventorySeq;
    }

    public void setInventorySeq(String inventorySeq) {
        this.inventorySeq = inventorySeq;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public ZonedDateTime getPlannedStartDateT() {
        return this.plannedStartDateT;
    }

    public void setPlannedStartDateT(ZonedDateTime plannedStartDateT) {
        this.plannedStartDateT = plannedStartDateT;
    }

    public ZonedDateTime getPlannedEndDateT() {
        return this.plannedEndDateT;
    }

    public void setPlannedEndDateT(ZonedDateTime plannedEndDateT) {
        this.plannedEndDateT = plannedEndDateT;
    }

    public String getInventoryTitle() {
        return this.inventoryTitle;
    }

    public void setInventoryTitle(String inventoryTitle) {
        this.inventoryTitle = inventoryTitle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<InventoryLine> getInventoryLineList() {
        return this.inventoryLineList;
    }

    public void setInventoryLineList(List<InventoryLine> inventoryLineList) {
        this.inventoryLineList = inventoryLineList;
    }

    public void addInventoryLineListItem(InventoryLine item) {
        if (this.getInventoryLineList() == null) {
            this.setInventoryLineList(new ArrayList<InventoryLine>());
        }
        this.getInventoryLineList().add(item);
        item.setInventory(this);
    }

    public void removeInventoryLineListItem(InventoryLine item) {
        if (this.getInventoryLineList() == null) {
            return;
        }
        this.getInventoryLineList().remove((Object)item);
    }

    public void clearInventoryLineList() {
        if (this.getInventoryLineList() != null) {
            this.getInventoryLineList().clear();
        }
    }

    public String getFormatSelect() {
        return this.formatSelect;
    }

    public void setFormatSelect(String formatSelect) {
        this.formatSelect = formatSelect;
    }

    public MetaFile getImportFile() {
        return this.importFile;
    }

    public void setImportFile(MetaFile importFile) {
        this.importFile = importFile;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public ProductFamily getProductFamily() {
        return this.productFamily;
    }

    public void setProductFamily(ProductFamily productFamily) {
        this.productFamily = productFamily;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(ProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Boolean getExcludeOutOfStock() {
        return this.excludeOutOfStock == null ? Boolean.FALSE : this.excludeOutOfStock;
    }

    public void setExcludeOutOfStock(Boolean excludeOutOfStock) {
        this.excludeOutOfStock = excludeOutOfStock;
    }

    public Boolean getIncludeObsolete() {
        return this.includeObsolete == null ? Boolean.FALSE : this.includeObsolete;
    }

    public void setIncludeObsolete(Boolean includeObsolete) {
        this.includeObsolete = includeObsolete;
    }

    public String getFromRack() {
        return this.fromRack;
    }

    public void setFromRack(String fromRack) {
        this.fromRack = fromRack;
    }

    public String getToRack() {
        return this.toRack;
    }

    public void setToRack(String toRack) {
        this.toRack = toRack;
    }

    public User getValidatedBy() {
        return this.validatedBy;
    }

    public void setValidatedBy(User validatedBy) {
        this.validatedBy = validatedBy;
    }

    public User getCompletedBy() {
        return this.completedBy;
    }

    public void setCompletedBy(User completedBy) {
        this.completedBy = completedBy;
    }

    public LocalDate getValidatedOn() {
        return this.validatedOn;
    }

    public void setValidatedOn(LocalDate validatedOn) {
        this.validatedOn = validatedOn;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Inventory)) {
            return false;
        }
        Inventory other = (Inventory)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("inventorySeq", (Object)this.getInventorySeq()).add("statusSelect", (Object)this.getStatusSelect()).add("plannedStartDateT", (Object)this.getPlannedStartDateT()).add("plannedEndDateT", (Object)this.getPlannedEndDateT()).add("inventoryTitle", (Object)this.getInventoryTitle()).add("formatSelect", (Object)this.getFormatSelect()).add("excludeOutOfStock", (Object)this.getExcludeOutOfStock()).add("includeObsolete", (Object)this.getIncludeObsolete()).add("fromRack", (Object)this.getFromRack()).add("toRack", (Object)this.getToRack()).add("validatedOn", (Object)this.getValidatedOn()).omitNullValues().toString();
    }
}

