/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.Incoterm;
import com.axelor.apps.stock.db.LogisticalFormLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_LOGISTICAL_FORM", indexes={@Index(columnList="deliveryNumberSeq"), @Index(columnList="company"), @Index(columnList="stock_location"), @Index(columnList="deliver_to_customer_partner"), @Index(columnList="carrier_partner"), @Index(columnList="forwarder_partner"), @Index(columnList="incoterm")})
@Track(fields={@TrackField(name="statusSelect"), @TrackField(name="deliveryNumberSeq"), @TrackField(name="collectionDate"), @TrackField(name="deliverToCustomerPartner"), @TrackField(name="carrierPartner"), @TrackField(name="forwarderPartner"), @TrackField(name="incoterm"), @TrackField(name="tracking")}, messages={@TrackMessage(message="Provision", condition="statusSelect == 1", tag="important"), @TrackMessage(message="Carrier validated", condition="statusSelect == 2", tag="info"), @TrackMessage(message="Collected", condition="statusSelect == 3", tag="success")})
public class LogisticalForm
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_LOGISTICAL_FORM_SEQ")
    @SequenceGenerator(name="STOCK_LOGISTICAL_FORM_SEQ", sequenceName="STOCK_LOGISTICAL_FORM_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Delivery number", readonly=true)
    @NameColumn
    private String deliveryNumberSeq;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Deliver to customer")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner deliverToCustomerPartner;
    @NotNull
    private LocalDate collectionDate;
    @Widget(title="Carrier")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner carrierPartner;
    @Widget(title="Forwarder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner forwarderPartner;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Incoterm incoterm;
    private String tracking;
    @Widget(readonly=true)
    @Digits(integer=17, fraction=3)
    private BigDecimal totalGrossMass = BigDecimal.ZERO;
    @Widget(readonly=true)
    @Digits(integer=17, fraction=3)
    private BigDecimal totalNetMass = BigDecimal.ZERO;
    @Widget(title="Total volume (m\u00b3)", readonly=true)
    @Digits(integer=17, fraction=3)
    private BigDecimal totalVolume = BigDecimal.ZERO;
    @Widget(title="Status", readonly=true, selection="logistical.form.status.select")
    private Integer statusSelect = 1;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String internalDeliveryComment;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String externalDeliveryComment;
    @Widget(title="Account selection to carrier", selection="logistical.form.account.to.carrier.select")
    private Integer accountSelectionToCarrierSelect = 1;
    private String customerAccountNumberToCarrier;
    @Widget(title="Packing lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="logisticalForm", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LogisticalFormLine> logisticalFormLineList;
    @Widget(title="Email sent", readonly=true)
    private Boolean isEmailSent = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDeliveryNumberSeq() {
        return this.deliveryNumberSeq;
    }

    public void setDeliveryNumberSeq(String deliveryNumberSeq) {
        this.deliveryNumberSeq = deliveryNumberSeq;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public Partner getDeliverToCustomerPartner() {
        return this.deliverToCustomerPartner;
    }

    public void setDeliverToCustomerPartner(Partner deliverToCustomerPartner) {
        this.deliverToCustomerPartner = deliverToCustomerPartner;
    }

    public LocalDate getCollectionDate() {
        return this.collectionDate;
    }

    public void setCollectionDate(LocalDate collectionDate) {
        this.collectionDate = collectionDate;
    }

    public Partner getCarrierPartner() {
        return this.carrierPartner;
    }

    public void setCarrierPartner(Partner carrierPartner) {
        this.carrierPartner = carrierPartner;
    }

    public Partner getForwarderPartner() {
        return this.forwarderPartner;
    }

    public void setForwarderPartner(Partner forwarderPartner) {
        this.forwarderPartner = forwarderPartner;
    }

    public Incoterm getIncoterm() {
        return this.incoterm;
    }

    public void setIncoterm(Incoterm incoterm) {
        this.incoterm = incoterm;
    }

    public String getTracking() {
        return this.tracking;
    }

    public void setTracking(String tracking) {
        this.tracking = tracking;
    }

    public BigDecimal getTotalGrossMass() {
        return this.totalGrossMass == null ? BigDecimal.ZERO : this.totalGrossMass;
    }

    public void setTotalGrossMass(BigDecimal totalGrossMass) {
        this.totalGrossMass = totalGrossMass;
    }

    public BigDecimal getTotalNetMass() {
        return this.totalNetMass == null ? BigDecimal.ZERO : this.totalNetMass;
    }

    public void setTotalNetMass(BigDecimal totalNetMass) {
        this.totalNetMass = totalNetMass;
    }

    public BigDecimal getTotalVolume() {
        return this.totalVolume == null ? BigDecimal.ZERO : this.totalVolume;
    }

    public void setTotalVolume(BigDecimal totalVolume) {
        this.totalVolume = totalVolume;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getInternalDeliveryComment() {
        return this.internalDeliveryComment;
    }

    public void setInternalDeliveryComment(String internalDeliveryComment) {
        this.internalDeliveryComment = internalDeliveryComment;
    }

    public String getExternalDeliveryComment() {
        return this.externalDeliveryComment;
    }

    public void setExternalDeliveryComment(String externalDeliveryComment) {
        this.externalDeliveryComment = externalDeliveryComment;
    }

    public Integer getAccountSelectionToCarrierSelect() {
        return this.accountSelectionToCarrierSelect == null ? 0 : this.accountSelectionToCarrierSelect;
    }

    public void setAccountSelectionToCarrierSelect(Integer accountSelectionToCarrierSelect) {
        this.accountSelectionToCarrierSelect = accountSelectionToCarrierSelect;
    }

    public String getCustomerAccountNumberToCarrier() {
        return this.customerAccountNumberToCarrier;
    }

    public void setCustomerAccountNumberToCarrier(String customerAccountNumberToCarrier) {
        this.customerAccountNumberToCarrier = customerAccountNumberToCarrier;
    }

    public List<LogisticalFormLine> getLogisticalFormLineList() {
        return this.logisticalFormLineList;
    }

    public void setLogisticalFormLineList(List<LogisticalFormLine> logisticalFormLineList) {
        this.logisticalFormLineList = logisticalFormLineList;
    }

    public void addLogisticalFormLineListItem(LogisticalFormLine item) {
        if (this.getLogisticalFormLineList() == null) {
            this.setLogisticalFormLineList(new ArrayList<LogisticalFormLine>());
        }
        this.getLogisticalFormLineList().add(item);
        item.setLogisticalForm(this);
    }

    public void removeLogisticalFormLineListItem(LogisticalFormLine item) {
        if (this.getLogisticalFormLineList() == null) {
            return;
        }
        this.getLogisticalFormLineList().remove((Object)item);
    }

    public void clearLogisticalFormLineList() {
        if (this.getLogisticalFormLineList() != null) {
            this.getLogisticalFormLineList().clear();
        }
    }

    public Boolean getIsEmailSent() {
        return this.isEmailSent == null ? Boolean.FALSE : this.isEmailSent;
    }

    public void setIsEmailSent(Boolean isEmailSent) {
        this.isEmailSent = isEmailSent;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogisticalForm)) {
            return false;
        }
        LogisticalForm other = (LogisticalForm)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("deliveryNumberSeq", (Object)this.getDeliveryNumberSeq()).add("collectionDate", (Object)this.getCollectionDate()).add("tracking", (Object)this.getTracking()).add("totalGrossMass", (Object)this.getTotalGrossMass()).add("totalNetMass", (Object)this.getTotalNetMass()).add("totalVolume", (Object)this.getTotalVolume()).add("statusSelect", (Object)this.getStatusSelect()).add("accountSelectionToCarrierSelect", (Object)this.getAccountSelectionToCarrierSelect()).add("customerAccountNumberToCarrier", (Object)this.getCustomerAccountNumberToCarrier()).add("isEmailSent", (Object)this.getIsEmailSent()).omitNullValues().toString();
    }
}

