/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STOCK_PARTNER_PRODUCT_QUALITY_RATING", indexes={@Index(columnList="partner"), @Index(columnList="product")})
public class PartnerProductQualityRating
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_PARTNER_PRODUCT_QUALITY_RATING_SEQ")
    @SequenceGenerator(name="STOCK_PARTNER_PRODUCT_QUALITY_RATING_SEQ", sequenceName="STOCK_PARTNER_PRODUCT_QUALITY_RATING_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Quality rating")
    private BigDecimal qualityRating = BigDecimal.ZERO;
    @Widget(title="Quality rating", selection="rating.icon.select")
    private BigDecimal qualityRatingSelect = BigDecimal.ZERO;
    @Digits(integer=10, fraction=10)
    private BigDecimal compliantArrivalProductQty = BigDecimal.ZERO;
    @Digits(integer=10, fraction=10)
    private BigDecimal arrivalProductQty = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PartnerProductQualityRating() {
    }

    public PartnerProductQualityRating(Product product) {
        this.product = product;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQualityRating() {
        return this.qualityRating == null ? BigDecimal.ZERO : this.qualityRating;
    }

    public void setQualityRating(BigDecimal qualityRating) {
        this.qualityRating = qualityRating;
    }

    public BigDecimal getQualityRatingSelect() {
        return this.qualityRatingSelect == null ? BigDecimal.ZERO : this.qualityRatingSelect;
    }

    public void setQualityRatingSelect(BigDecimal qualityRatingSelect) {
        this.qualityRatingSelect = qualityRatingSelect;
    }

    public BigDecimal getCompliantArrivalProductQty() {
        return this.compliantArrivalProductQty == null ? BigDecimal.ZERO : this.compliantArrivalProductQty;
    }

    public void setCompliantArrivalProductQty(BigDecimal compliantArrivalProductQty) {
        this.compliantArrivalProductQty = compliantArrivalProductQty;
    }

    public BigDecimal getArrivalProductQty() {
        return this.arrivalProductQty == null ? BigDecimal.ZERO : this.arrivalProductQty;
    }

    public void setArrivalProductQty(BigDecimal arrivalProductQty) {
        this.arrivalProductQty = arrivalProductQty;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartnerProductQualityRating)) {
            return false;
        }
        PartnerProductQualityRating other = (PartnerProductQualityRating)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("qualityRating", (Object)this.getQualityRating()).add("qualityRatingSelect", (Object)this.getQualityRatingSelect()).add("compliantArrivalProductQty", (Object)this.getCompliantArrivalProductQty()).add("arrivalProductQty", (Object)this.getArrivalProductQty()).omitNullValues().toString();
    }
}

