/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.stock.db.Incoterm;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STOCK_PARTNER_STOCK_SETTINGS", indexes={@Index(columnList="real_stock_move_message_template"), @Index(columnList="planned_stock_move_message_template"), @Index(columnList="partner"), @Index(columnList="company"), @Index(columnList="default_stock_location"), @Index(columnList="default_external_stock_location"), @Index(columnList="incoterm")})
public class PartnerStockSettings
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_PARTNER_STOCK_SETTINGS_SEQ")
    @SequenceGenerator(name="STOCK_PARTNER_STOCK_SETTINGS_SEQ", sequenceName="STOCK_PARTNER_STOCK_SETTINGS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Send email on stock move realization")
    private Boolean realStockMoveAutomaticMail = Boolean.FALSE;
    @Widget(title="Send email when planning stock move")
    private Boolean plannedStockMoveAutomaticMail = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template realStockMoveMessageTemplate;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template plannedStockMoveMessageTemplate;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Default stock location", help="Default from stock location for sales and to stock location for purchases")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation defaultStockLocation;
    @Widget(title="Default external stock location", help="Default to stock location for sales and from stock location for purchases")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation defaultExternalStockLocation;
    @Widget(title="Incoterm")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Incoterm incoterm;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getRealStockMoveAutomaticMail() {
        return this.realStockMoveAutomaticMail == null ? Boolean.FALSE : this.realStockMoveAutomaticMail;
    }

    public void setRealStockMoveAutomaticMail(Boolean realStockMoveAutomaticMail) {
        this.realStockMoveAutomaticMail = realStockMoveAutomaticMail;
    }

    public Boolean getPlannedStockMoveAutomaticMail() {
        return this.plannedStockMoveAutomaticMail == null ? Boolean.FALSE : this.plannedStockMoveAutomaticMail;
    }

    public void setPlannedStockMoveAutomaticMail(Boolean plannedStockMoveAutomaticMail) {
        this.plannedStockMoveAutomaticMail = plannedStockMoveAutomaticMail;
    }

    public Template getRealStockMoveMessageTemplate() {
        return this.realStockMoveMessageTemplate;
    }

    public void setRealStockMoveMessageTemplate(Template realStockMoveMessageTemplate) {
        this.realStockMoveMessageTemplate = realStockMoveMessageTemplate;
    }

    public Template getPlannedStockMoveMessageTemplate() {
        return this.plannedStockMoveMessageTemplate;
    }

    public void setPlannedStockMoveMessageTemplate(Template plannedStockMoveMessageTemplate) {
        this.plannedStockMoveMessageTemplate = plannedStockMoveMessageTemplate;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public StockLocation getDefaultStockLocation() {
        return this.defaultStockLocation;
    }

    public void setDefaultStockLocation(StockLocation defaultStockLocation) {
        this.defaultStockLocation = defaultStockLocation;
    }

    public StockLocation getDefaultExternalStockLocation() {
        return this.defaultExternalStockLocation;
    }

    public void setDefaultExternalStockLocation(StockLocation defaultExternalStockLocation) {
        this.defaultExternalStockLocation = defaultExternalStockLocation;
    }

    public Incoterm getIncoterm() {
        return this.incoterm;
    }

    public void setIncoterm(Incoterm incoterm) {
        this.incoterm = incoterm;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartnerStockSettings)) {
            return false;
        }
        PartnerStockSettings other = (PartnerStockSettings)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("realStockMoveAutomaticMail", (Object)this.getRealStockMoveAutomaticMail()).add("plannedStockMoveAutomaticMail", (Object)this.getPlannedStockMoveAutomaticMail()).omitNullValues().toString();
    }
}

