/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.stock.db.FreightCarrierMode;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_SHIPMENT_MODE", indexes={@Index(columnList="name")})
public class ShipmentMode
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_SHIPMENT_MODE_SEQ")
    @SequenceGenerator(name="STOCK_SHIPMENT_MODE_SEQ", sequenceName="STOCK_SHIPMENT_MODE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Shipment Mode")
    private String name;
    @Widget(title="Freight Carrier Mode")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="shipmentMode", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FreightCarrierMode> freightCarrierMode;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ShipmentMode() {
    }

    public ShipmentMode(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<FreightCarrierMode> getFreightCarrierMode() {
        return this.freightCarrierMode;
    }

    public void setFreightCarrierMode(List<FreightCarrierMode> freightCarrierMode) {
        this.freightCarrierMode = freightCarrierMode;
    }

    public void addFreightCarrierMode(FreightCarrierMode item) {
        if (this.getFreightCarrierMode() == null) {
            this.setFreightCarrierMode(new ArrayList<FreightCarrierMode>());
        }
        this.getFreightCarrierMode().add(item);
        item.setShipmentMode(this);
    }

    public void removeFreightCarrierMode(FreightCarrierMode item) {
        if (this.getFreightCarrierMode() == null) {
            return;
        }
        this.getFreightCarrierMode().remove((Object)item);
    }

    public void clearFreightCarrierMode() {
        if (this.getFreightCarrierMode() != null) {
            this.getFreightCarrierMode().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShipmentMode)) {
            return false;
        }
        ShipmentMode other = (ShipmentMode)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

