/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.stock.db.StockCorrectionReason;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_STOCK_CORRECTION", indexes={@Index(columnList="stock_location"), @Index(columnList="product"), @Index(columnList="tracking_number"), @Index(columnList="stock_correction_reason")})
public class StockCorrection
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_CORRECTION_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_CORRECTION_SEQ", sequenceName="STOCK_STOCK_CORRECTION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Stock Location")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Product")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Tracking Number")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TrackingNumber trackingNumber;
    @Widget(title="Real Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal realQty = BigDecimal.ZERO;
    @Widget(title="Future Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal futureQty = BigDecimal.ZERO;
    @Widget(title="Reserved Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal reservedQty = BigDecimal.ZERO;
    @Widget(title="Reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockCorrectionReason stockCorrectionReason;
    @Widget(title="Status", readonly=true, selection="stock.correction.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Validation Date", readonly=true)
    private LocalDateTime validationDateT;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public TrackingNumber getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(TrackingNumber trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public BigDecimal getRealQty() {
        return this.realQty == null ? BigDecimal.ZERO : this.realQty;
    }

    public void setRealQty(BigDecimal realQty) {
        this.realQty = realQty;
    }

    public BigDecimal getFutureQty() {
        return this.futureQty == null ? BigDecimal.ZERO : this.futureQty;
    }

    public void setFutureQty(BigDecimal futureQty) {
        this.futureQty = futureQty;
    }

    public BigDecimal getReservedQty() {
        return this.reservedQty == null ? BigDecimal.ZERO : this.reservedQty;
    }

    public void setReservedQty(BigDecimal reservedQty) {
        this.reservedQty = reservedQty;
    }

    public StockCorrectionReason getStockCorrectionReason() {
        return this.stockCorrectionReason;
    }

    public void setStockCorrectionReason(StockCorrectionReason stockCorrectionReason) {
        this.stockCorrectionReason = stockCorrectionReason;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDateTime getValidationDateT() {
        return this.validationDateT;
    }

    public void setValidationDateT(LocalDateTime validationDateT) {
        this.validationDateT = validationDateT;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockCorrection)) {
            return false;
        }
        StockCorrection other = (StockCorrection)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("realQty", (Object)this.getRealQty()).add("futureQty", (Object)this.getFutureQty()).add("reservedQty", (Object)this.getReservedQty()).add("statusSelect", (Object)this.getStatusSelect()).add("validationDateT", (Object)this.getValidationDateT()).omitNullValues().toString();
    }
}

