/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_STOCK_RULES", indexes={@Index(columnList="name"), @Index(columnList="stock_location"), @Index(columnList="product"), @Index(columnList="user_id"), @Index(columnList="team"), @Index(columnList="stock_rule_message_template")})
@Track(fields={@TrackField(name="stockLocation"), @TrackField(name="product"), @TrackField(name="useCaseSelect"), @TrackField(name="typeSelect", condition="useCaseSelect == 2"), @TrackField(name="orderAlertSelect"), @TrackField(name="minQty"), @TrackField(name="useIdealQty"), @TrackField(name="idealQty", condition="useIdealQty"), @TrackField(name="useMaxQty"), @TrackField(name="maxQty", condition="useMaxQty"), @TrackField(name="reOrderQty"), @TrackField(name="user", condition="orderAlertSelect == 1"), @TrackField(name="team", condition="orderAlertSelect == 1")}, messages={@TrackMessage(message="Stock rules created", condition="true", on={TrackEvent.CREATE})})
public class StockRules
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_RULES_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_RULES_SEQ", sequenceName="STOCK_STOCK_RULES_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="Stock location", massUpdate=true)
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Product", massUpdate=true)
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Min. Qty", massUpdate=true)
    @NotNull
    @Digits(integer=10, fraction=10)
    private BigDecimal minQty = BigDecimal.ZERO;
    @Widget(title="Ideal Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal idealQty = BigDecimal.ZERO;
    @Widget(title="Max. Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal maxQty = BigDecimal.ZERO;
    @Widget(title="Refill Qty")
    @NotNull
    @Digits(integer=10, fraction=10)
    private BigDecimal reOrderQty = BigDecimal.ZERO;
    @Widget(title="Define ideal Qty")
    private Boolean useIdealQty = Boolean.FALSE;
    @Widget(title="Define max Qty")
    private Boolean useMaxQty = Boolean.FALSE;
    @Widget(title="Use Case", selection="stock.stock.rules.use.case.select")
    @NotNull
    private Integer useCaseSelect = 0;
    @Widget(title="Type", selection="stock.stock.rules.type.select")
    @Column(nullable=true)
    private Integer typeSelect;
    @Widget(title="Refill type", selection="stock.stock.rules.order.alert.select", massUpdate=true)
    @NotNull
    private Integer orderAlertSelect = 0;
    @Widget(title="User to alert")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Team to alert")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Message template for stock rules")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template stockRuleMessageTemplate;
    @Widget(title="Alert")
    private Boolean alert = Boolean.FALSE;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public StockRules() {
    }

    public StockRules(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getMinQty() {
        return this.minQty == null ? BigDecimal.ZERO : this.minQty;
    }

    public void setMinQty(BigDecimal minQty) {
        this.minQty = minQty;
    }

    public BigDecimal getIdealQty() {
        return this.idealQty == null ? BigDecimal.ZERO : this.idealQty;
    }

    public void setIdealQty(BigDecimal idealQty) {
        this.idealQty = idealQty;
    }

    public BigDecimal getMaxQty() {
        return this.maxQty == null ? BigDecimal.ZERO : this.maxQty;
    }

    public void setMaxQty(BigDecimal maxQty) {
        this.maxQty = maxQty;
    }

    public BigDecimal getReOrderQty() {
        return this.reOrderQty == null ? BigDecimal.ZERO : this.reOrderQty;
    }

    public void setReOrderQty(BigDecimal reOrderQty) {
        this.reOrderQty = reOrderQty;
    }

    public Boolean getUseIdealQty() {
        return this.useIdealQty == null ? Boolean.FALSE : this.useIdealQty;
    }

    public void setUseIdealQty(Boolean useIdealQty) {
        this.useIdealQty = useIdealQty;
    }

    public Boolean getUseMaxQty() {
        return this.useMaxQty == null ? Boolean.FALSE : this.useMaxQty;
    }

    public void setUseMaxQty(Boolean useMaxQty) {
        this.useMaxQty = useMaxQty;
    }

    public Integer getUseCaseSelect() {
        return this.useCaseSelect == null ? 0 : this.useCaseSelect;
    }

    public void setUseCaseSelect(Integer useCaseSelect) {
        this.useCaseSelect = useCaseSelect;
    }

    public Integer getTypeSelect() {
        return this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getOrderAlertSelect() {
        return this.orderAlertSelect == null ? 0 : this.orderAlertSelect;
    }

    public void setOrderAlertSelect(Integer orderAlertSelect) {
        this.orderAlertSelect = orderAlertSelect;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Template getStockRuleMessageTemplate() {
        return this.stockRuleMessageTemplate;
    }

    public void setStockRuleMessageTemplate(Template stockRuleMessageTemplate) {
        this.stockRuleMessageTemplate = stockRuleMessageTemplate;
    }

    public Boolean getAlert() {
        return this.alert == null ? Boolean.FALSE : this.alert;
    }

    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockRules)) {
            return false;
        }
        StockRules other = (StockRules)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("minQty", (Object)this.getMinQty()).add("idealQty", (Object)this.getIdealQty()).add("maxQty", (Object)this.getMaxQty()).add("reOrderQty", (Object)this.getReOrderQty()).add("useIdealQty", (Object)this.getUseIdealQty()).add("useMaxQty", (Object)this.getUseMaxQty()).add("useCaseSelect", (Object)this.getUseCaseSelect()).add("typeSelect", (Object)this.getTypeSelect()).add("orderAlertSelect", (Object)this.getOrderAlertSelect()).add("alert", (Object)this.getAlert()).omitNullValues().toString();
    }
}

