/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Product;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_TRACKING_NUMBER", uniqueConstraints={@UniqueConstraint(columnNames={"product", "trackingNumberSeq"})}, indexes={@Index(columnList="product"), @Index(columnList="trackingNumberSeq")})
public class TrackingNumber
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_TRACKING_NUMBER_SEQ")
    @SequenceGenerator(name="STOCK_TRACKING_NUMBER_SEQ", sequenceName="STOCK_TRACKING_NUMBER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Warranty expiration date", readonly=true)
    private LocalDate warrantyExpirationDate;
    @Widget(title="Perishable expiration date", readonly=true)
    private LocalDate perishableExpirationDate;
    @Widget(title="Tracking Nbr.")
    @NameColumn
    @NotNull
    private String trackingNumberSeq;
    @Widget(title="Counter")
    @Digits(integer=10, fraction=10)
    private BigDecimal counter = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public LocalDate getWarrantyExpirationDate() {
        return this.warrantyExpirationDate;
    }

    public void setWarrantyExpirationDate(LocalDate warrantyExpirationDate) {
        this.warrantyExpirationDate = warrantyExpirationDate;
    }

    public LocalDate getPerishableExpirationDate() {
        return this.perishableExpirationDate;
    }

    public void setPerishableExpirationDate(LocalDate perishableExpirationDate) {
        this.perishableExpirationDate = perishableExpirationDate;
    }

    public String getTrackingNumberSeq() {
        return this.trackingNumberSeq;
    }

    public void setTrackingNumberSeq(String trackingNumberSeq) {
        this.trackingNumberSeq = trackingNumberSeq;
    }

    public BigDecimal getCounter() {
        return this.counter == null ? BigDecimal.ZERO : this.counter;
    }

    public void setCounter(BigDecimal counter) {
        this.counter = counter;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TrackingNumber)) {
            return false;
        }
        TrackingNumber other = (TrackingNumber)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("warrantyExpirationDate", (Object)this.getWarrantyExpirationDate()).add("perishableExpirationDate", (Object)this.getPerishableExpirationDate()).add("trackingNumberSeq", (Object)this.getTrackingNumberSeq()).add("counter", (Object)this.getCounter()).omitNullValues().toString();
    }
}

