/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Sequence;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_TRACKING_NUMBER_CONFIGURATION", indexes={@Index(columnList="sequence"), @Index(columnList="name"), @Index(columnList="fullName")})
public class TrackingNumberConfiguration
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_TRACKING_NUMBER_CONFIGURATION_SEQ")
    @SequenceGenerator(name="STOCK_TRACKING_NUMBER_CONFIGURATION_SEQ", sequenceName="STOCK_TRACKING_NUMBER_CONFIGURATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Manage purchase tracking Nbr.")
    private Boolean isPurchaseTrackingManaged = Boolean.FALSE;
    @Widget(title="Manage production tracking Nbr.")
    private Boolean isProductionTrackingManaged = Boolean.FALSE;
    @Widget(title="Manage sale tracking Nbr.")
    private Boolean isSaleTrackingManaged = Boolean.FALSE;
    @Widget(title="Generate new purchase auto tracking Nbr.")
    private Boolean generatePurchaseAutoTrackingNbr = Boolean.FALSE;
    @Widget(title="Generate new production auto tracking Nbr.")
    private Boolean generateProductionAutoTrackingNbr = Boolean.FALSE;
    @Widget(title="Generate new sale auto tracking Nbr.")
    private Boolean generateSaleAutoTrackingNbr = Boolean.FALSE;
    @Widget(title="Auto select sale tracking Nbr.")
    private Boolean hasSaleAutoSelectTrackingNbr = Boolean.FALSE;
    @Widget(title="Auto sale tracking Nbr. order", selection="tracking.number.configuration.tracking.number.order.select")
    private Integer saleAutoTrackingNbrOrderSelect = 0;
    @Widget(title="Auto select product tracking Nbr.")
    private Boolean hasProductAutoSelectTrackingNbr = Boolean.FALSE;
    @Widget(title="Auto product tracking Nbr. order", selection="tracking.number.configuration.tracking.number.order.select")
    private Integer productAutoTrackingNbrOrderSelect = 0;
    @Widget(title="Sale Qty by tracking")
    @Digits(integer=10, fraction=10)
    private BigDecimal saleQtyByTracking = BigDecimal.ZERO;
    @Widget(title="Purchase Qty by tracking")
    @Digits(integer=10, fraction=10)
    private BigDecimal purchaseQtyByTracking = BigDecimal.ZERO;
    @Widget(title="Production Qty by tracking")
    @Digits(integer=10, fraction=10)
    private BigDecimal productionQtyByTracking = BigDecimal.ZERO;
    @Widget(title="Sequence")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence sequence;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Full name")
    @NameColumn
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TrackingNumberConfiguration() {
    }

    public TrackingNumberConfiguration(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getIsPurchaseTrackingManaged() {
        return this.isPurchaseTrackingManaged == null ? Boolean.FALSE : this.isPurchaseTrackingManaged;
    }

    public void setIsPurchaseTrackingManaged(Boolean isPurchaseTrackingManaged) {
        this.isPurchaseTrackingManaged = isPurchaseTrackingManaged;
    }

    public Boolean getIsProductionTrackingManaged() {
        return this.isProductionTrackingManaged == null ? Boolean.FALSE : this.isProductionTrackingManaged;
    }

    public void setIsProductionTrackingManaged(Boolean isProductionTrackingManaged) {
        this.isProductionTrackingManaged = isProductionTrackingManaged;
    }

    public Boolean getIsSaleTrackingManaged() {
        return this.isSaleTrackingManaged == null ? Boolean.FALSE : this.isSaleTrackingManaged;
    }

    public void setIsSaleTrackingManaged(Boolean isSaleTrackingManaged) {
        this.isSaleTrackingManaged = isSaleTrackingManaged;
    }

    public Boolean getGeneratePurchaseAutoTrackingNbr() {
        return this.generatePurchaseAutoTrackingNbr == null ? Boolean.FALSE : this.generatePurchaseAutoTrackingNbr;
    }

    public void setGeneratePurchaseAutoTrackingNbr(Boolean generatePurchaseAutoTrackingNbr) {
        this.generatePurchaseAutoTrackingNbr = generatePurchaseAutoTrackingNbr;
    }

    public Boolean getGenerateProductionAutoTrackingNbr() {
        return this.generateProductionAutoTrackingNbr == null ? Boolean.FALSE : this.generateProductionAutoTrackingNbr;
    }

    public void setGenerateProductionAutoTrackingNbr(Boolean generateProductionAutoTrackingNbr) {
        this.generateProductionAutoTrackingNbr = generateProductionAutoTrackingNbr;
    }

    public Boolean getGenerateSaleAutoTrackingNbr() {
        return this.generateSaleAutoTrackingNbr == null ? Boolean.FALSE : this.generateSaleAutoTrackingNbr;
    }

    public void setGenerateSaleAutoTrackingNbr(Boolean generateSaleAutoTrackingNbr) {
        this.generateSaleAutoTrackingNbr = generateSaleAutoTrackingNbr;
    }

    public Boolean getHasSaleAutoSelectTrackingNbr() {
        return this.hasSaleAutoSelectTrackingNbr == null ? Boolean.FALSE : this.hasSaleAutoSelectTrackingNbr;
    }

    public void setHasSaleAutoSelectTrackingNbr(Boolean hasSaleAutoSelectTrackingNbr) {
        this.hasSaleAutoSelectTrackingNbr = hasSaleAutoSelectTrackingNbr;
    }

    public Integer getSaleAutoTrackingNbrOrderSelect() {
        return this.saleAutoTrackingNbrOrderSelect == null ? 0 : this.saleAutoTrackingNbrOrderSelect;
    }

    public void setSaleAutoTrackingNbrOrderSelect(Integer saleAutoTrackingNbrOrderSelect) {
        this.saleAutoTrackingNbrOrderSelect = saleAutoTrackingNbrOrderSelect;
    }

    public Boolean getHasProductAutoSelectTrackingNbr() {
        return this.hasProductAutoSelectTrackingNbr == null ? Boolean.FALSE : this.hasProductAutoSelectTrackingNbr;
    }

    public void setHasProductAutoSelectTrackingNbr(Boolean hasProductAutoSelectTrackingNbr) {
        this.hasProductAutoSelectTrackingNbr = hasProductAutoSelectTrackingNbr;
    }

    public Integer getProductAutoTrackingNbrOrderSelect() {
        return this.productAutoTrackingNbrOrderSelect == null ? 0 : this.productAutoTrackingNbrOrderSelect;
    }

    public void setProductAutoTrackingNbrOrderSelect(Integer productAutoTrackingNbrOrderSelect) {
        this.productAutoTrackingNbrOrderSelect = productAutoTrackingNbrOrderSelect;
    }

    public BigDecimal getSaleQtyByTracking() {
        return this.saleQtyByTracking == null ? BigDecimal.ZERO : this.saleQtyByTracking;
    }

    public void setSaleQtyByTracking(BigDecimal saleQtyByTracking) {
        this.saleQtyByTracking = saleQtyByTracking;
    }

    public BigDecimal getPurchaseQtyByTracking() {
        return this.purchaseQtyByTracking == null ? BigDecimal.ZERO : this.purchaseQtyByTracking;
    }

    public void setPurchaseQtyByTracking(BigDecimal purchaseQtyByTracking) {
        this.purchaseQtyByTracking = purchaseQtyByTracking;
    }

    public BigDecimal getProductionQtyByTracking() {
        return this.productionQtyByTracking == null ? BigDecimal.ZERO : this.productionQtyByTracking;
    }

    public void setProductionQtyByTracking(BigDecimal productionQtyByTracking) {
        this.productionQtyByTracking = productionQtyByTracking;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TrackingNumberConfiguration)) {
            return false;
        }
        TrackingNumberConfiguration other = (TrackingNumberConfiguration)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("isPurchaseTrackingManaged", (Object)this.getIsPurchaseTrackingManaged()).add("isProductionTrackingManaged", (Object)this.getIsProductionTrackingManaged()).add("isSaleTrackingManaged", (Object)this.getIsSaleTrackingManaged()).add("generatePurchaseAutoTrackingNbr", (Object)this.getGeneratePurchaseAutoTrackingNbr()).add("generateProductionAutoTrackingNbr", (Object)this.getGenerateProductionAutoTrackingNbr()).add("generateSaleAutoTrackingNbr", (Object)this.getGenerateSaleAutoTrackingNbr()).add("hasSaleAutoSelectTrackingNbr", (Object)this.getHasSaleAutoSelectTrackingNbr()).add("saleAutoTrackingNbrOrderSelect", (Object)this.getSaleAutoTrackingNbrOrderSelect()).add("hasProductAutoSelectTrackingNbr", (Object)this.getHasProductAutoSelectTrackingNbr()).add("productAutoTrackingNbrOrderSelect", (Object)this.getProductAutoTrackingNbrOrderSelect()).add("saleQtyByTracking", (Object)this.getSaleQtyByTracking()).omitNullValues().toString();
    }
}

