/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Unit;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_WAP_HISTORY", indexes={@Index(columnList="stock_location_line"), @Index(columnList="unit"), @Index(columnList="stock_move_line")})
public class WapHistory
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_WAP_HISTORY_SEQ")
    @SequenceGenerator(name="STOCK_WAP_HISTORY_SEQ", sequenceName="STOCK_WAP_HISTORY_SEQ", allocationSize=1)
    private Long id;
    @Widget(readonly=true)
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocationLine stockLocationLine;
    @Widget(readonly=true)
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="WAP", readonly=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal wap = BigDecimal.ZERO;
    @Widget(title="Quantity", readonly=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Unit", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Stock move line", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMoveLine stockMoveLine;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public WapHistory() {
    }

    public WapHistory(StockLocationLine stockLocationLine, LocalDate date, BigDecimal wap, BigDecimal qty, Unit unit, StockMoveLine stockMoveLine) {
        this.stockLocationLine = stockLocationLine;
        this.date = date;
        this.wap = wap;
        this.qty = qty;
        this.unit = unit;
        this.stockMoveLine = stockMoveLine;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public StockLocationLine getStockLocationLine() {
        return this.stockLocationLine;
    }

    public void setStockLocationLine(StockLocationLine stockLocationLine) {
        this.stockLocationLine = stockLocationLine;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public BigDecimal getWap() {
        return this.wap == null ? BigDecimal.ZERO : this.wap;
    }

    public void setWap(BigDecimal wap) {
        this.wap = wap;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public StockMoveLine getStockMoveLine() {
        return this.stockMoveLine;
    }

    public void setStockMoveLine(StockMoveLine stockMoveLine) {
        this.stockMoveLine = stockMoveLine;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WapHistory)) {
            return false;
        }
        WapHistory other = (WapHistory)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("date", (Object)this.getDate()).add("wap", (Object)this.getWap()).add("qty", (Object)this.getQty()).omitNullValues().toString();
    }
}

