/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db.repo;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.repo.LogisticalFormRepository;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import javax.persistence.PersistenceException;

public class LogisticalFormStockRepository
extends LogisticalFormRepository {
    public LogisticalForm save(LogisticalForm logisticalForm) {
        try {
            Company company = logisticalForm.getCompany();
            if (company != null) {
                StockConfig stockConfig;
                if (Strings.isNullOrEmpty((String)logisticalForm.getDeliveryNumberSeq())) {
                    String sequenceNumber = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("logisticalForm", logisticalForm.getCompany());
                    if (Strings.isNullOrEmpty((String)sequenceNumber)) {
                        throw new AxelorException(Sequence.class, 3, I18n.get((String)"Missing logistical form sequence for company %s"), new Object[]{logisticalForm.getCompany().getName()});
                    }
                    logisticalForm.setDeliveryNumberSeq(sequenceNumber);
                }
                if (!logisticalForm.getIsEmailSent().booleanValue() && (stockConfig = ((StockConfigService)Beans.get(StockConfigService.class)).getStockConfig(company)).getLogisticalFormAutomaticEmail().booleanValue()) {
                    Template template = stockConfig.getLogisticalFormMessageTemplate();
                    if (template == null) {
                        throw new AxelorException(4, I18n.get((String)"The template to send message on save is missing."), new Object[]{logisticalForm});
                    }
                    ((TemplateMessageService)Beans.get(TemplateMessageService.class)).generateAndSendMessage((Model)((Object)logisticalForm), template);
                    logisticalForm.setIsEmailSent(true);
                }
            }
            return (LogisticalForm)((Object)super.save((Model)((Object)logisticalForm)));
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }
}

